/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.fix;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.corext.fix.CleanUpPreferenceUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.fix.MapCleanUpOptions;
import org.eclipse.jdt.internal.ui.fix.SaveActionSelectionDialog;
import org.eclipse.jdt.internal.ui.fix.SaveParticipantMessages;
import org.eclipse.jdt.internal.ui.javaeditor.saveparticipant.AbstractSaveParticipantPreferenceConfiguration;
import org.eclipse.jdt.internal.ui.preferences.BulletListBlock;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.ui.cleanup.CleanUpOptions;
import org.eclipse.jdt.ui.cleanup.ICleanUp;
import org.eclipse.jface.dialogs.ControlEnableState;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.preference.IPreferencePageContainer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class CleanUpSaveParticipantPreferenceConfiguration
extends AbstractSaveParticipantPreferenceConfiguration {
    private static final int INDENT = 10;
    private IScopeContext fContext;
    private Map<String, String> fSettings;
    private BulletListBlock fSelectedActionsText;
    private Button fFormatCodeButton;
    private Button fFormatChangedOnlyButton;
    private Button fOrganizeImportsButton;
    private Shell fShell;
    private Link fFormatConfigLink;
    private Link fOrganizeImportsConfigLink;
    private IPreferencePageContainer fContainer;
    private Button fAdditionalActionButton;
    private Button fConfigureButton;
    private Button fFormatAllButton;
    private Composite fCleanUpOptionsComposite;
    private ControlEnableState fControlEnableState;

    @Override
    public void createConfigControl(Composite parent, IPreferencePageContainer container) {
        this.fContainer = container;
        this.fShell = parent.getShell();
        this.fCleanUpOptionsComposite = new Composite(parent, 0);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.horizontalIndent = 10;
        this.fCleanUpOptionsComposite.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        this.fCleanUpOptionsComposite.setLayout((Layout)gridLayout);
        this.fFormatCodeButton = new Button(this.fCleanUpOptionsComposite, 32);
        this.fFormatCodeButton.setText(SaveParticipantMessages.CleanUpSaveParticipantPreferenceConfiguration_SaveActionPreferencePage_FormatSource_Checkbox);
        this.fFormatCodeButton.setLayoutData((Object)new GridData(4, 128, true, false));
        this.fFormatCodeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CleanUpSaveParticipantPreferenceConfiguration.this.changeSettingsValue("cleanup.format_source_code", CleanUpSaveParticipantPreferenceConfiguration.this.fFormatCodeButton.getSelection());
            }
        });
        Composite regionFormatingCombo = new Composite(this.fCleanUpOptionsComposite, 0);
        gridData = new GridData(4, 128, true, false);
        gridData.horizontalIndent = LayoutUtil.getIndent();
        regionFormatingCombo.setLayoutData((Object)gridData);
        gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        regionFormatingCombo.setLayout((Layout)gridLayout);
        this.fFormatAllButton = new Button(regionFormatingCombo, 16);
        this.fFormatAllButton.setText(SaveParticipantMessages.CleanUpSaveParticipantPreferenceConfiguration_SaveActionPreferencePAge_FormatAllLines_Radio);
        gridData = new GridData(4, 128, true, false);
        this.fFormatAllButton.setLayoutData((Object)gridData);
        this.fFormatAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CleanUpSaveParticipantPreferenceConfiguration.this.changeSettingsValue("cleanup.format_source_code_changes_only", !CleanUpSaveParticipantPreferenceConfiguration.this.fFormatAllButton.getSelection());
            }
        });
        this.fFormatChangedOnlyButton = new Button(regionFormatingCombo, 16);
        this.fFormatChangedOnlyButton.setText(SaveParticipantMessages.CleanUpSaveParticipantPreferenceConfiguration_SaveActionPreferencePage_FormatOnlyChangedRegions_Radio);
        gridData = new GridData(4, 128, true, false);
        this.fFormatChangedOnlyButton.setLayoutData((Object)gridData);
        this.fFormatChangedOnlyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CleanUpSaveParticipantPreferenceConfiguration.this.changeSettingsValue("cleanup.format_source_code_changes_only", CleanUpSaveParticipantPreferenceConfiguration.this.fFormatChangedOnlyButton.getSelection());
            }
        });
        PixelConverter pixelConverter = new PixelConverter((Control)parent);
        int heightOneHalf = (int)Math.round((double)pixelConverter.convertHeightInCharsToPixels(1) * 1.5);
        this.fFormatConfigLink = new Link(this.fCleanUpOptionsComposite, 0);
        this.fFormatConfigLink.setText(SaveParticipantMessages.CleanUpSaveParticipantPreferenceConfiguration_ConfigureFormatter_Link);
        GridData gridData2 = new GridData(16384, 128, false, false);
        gridData2.horizontalIndent = LayoutUtil.getIndent();
        gridData2.minimumHeight = heightOneHalf;
        this.fFormatConfigLink.setLayoutData((Object)gridData2);
        this.fOrganizeImportsButton = new Button(this.fCleanUpOptionsComposite, 32);
        this.fOrganizeImportsButton.setText(SaveParticipantMessages.CleanUpSaveParticipantPreferenceConfiguration_SaveActionPreferencePage_OrganizeImports_Checkbox);
        this.fOrganizeImportsButton.setLayoutData((Object)new GridData(4, 128, true, false));
        this.fOrganizeImportsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CleanUpSaveParticipantPreferenceConfiguration.this.changeSettingsValue("cleanup.organize_imports", CleanUpSaveParticipantPreferenceConfiguration.this.fOrganizeImportsButton.getSelection());
            }
        });
        this.fOrganizeImportsConfigLink = new Link(this.fCleanUpOptionsComposite, 0);
        this.fOrganizeImportsConfigLink.setText(SaveParticipantMessages.CleanUpSaveParticipantPreferenceConfiguration_ConfigureImports_Link);
        GridData gridData3 = new GridData(16384, 128, false, false);
        gridData3.horizontalIndent = LayoutUtil.getIndent();
        gridData3.minimumHeight = heightOneHalf;
        this.fOrganizeImportsConfigLink.setLayoutData((Object)gridData3);
        this.fAdditionalActionButton = new Button(this.fCleanUpOptionsComposite, 32);
        this.fAdditionalActionButton.setText(SaveParticipantMessages.CleanUpSaveParticipantPreferenceConfiguration_AdditionalActions_Checkbox);
        this.createAdvancedComposite(this.fCleanUpOptionsComposite);
        this.fAdditionalActionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CleanUpSaveParticipantPreferenceConfiguration.this.changeSettingsValue("cleanup.on_save_use_additional_actions", CleanUpSaveParticipantPreferenceConfiguration.this.fAdditionalActionButton.getSelection());
            }
        });
    }

    private Composite createAdvancedComposite(final Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.horizontalIndent = 10;
        composite.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        this.fSelectedActionsText = new BulletListBlock(composite, 0);
        gridData = new GridData(4, 4, true, true);
        gridData.heightHint = new PixelConverter((Control)composite).convertHeightInCharsToPixels(8);
        this.fSelectedActionsText.setLayoutData(gridData);
        this.fConfigureButton = new Button(composite, 0);
        this.fConfigureButton.setText(SaveParticipantMessages.CleanUpSaveParticipantPreferenceConfiguration_Configure_Button);
        this.fConfigureButton.setLayoutData((Object)new GridData(4, 128, false, false));
        this.fConfigureButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Hashtable<String, String> workingValues = new Hashtable<String, String>(CleanUpSaveParticipantPreferenceConfiguration.this.fSettings);
                SaveActionSelectionDialog dialog = new SaveActionSelectionDialog(parent.getShell(), workingValues);
                if (dialog.open() == 0) {
                    CleanUpSaveParticipantPreferenceConfiguration.this.fSettings = workingValues;
                    CleanUpSaveParticipantPreferenceConfiguration.this.settingsChanged();
                }
            }
        });
        return composite;
    }

    @Override
    public void initialize(IScopeContext context, IAdaptable element) {
        IJavaProject jProject;
        IProject project;
        this.fContext = context;
        this.fSettings = CleanUpPreferenceUtil.loadSaveParticipantOptions(context);
        this.settingsChanged();
        IJavaProject javaProject = null;
        if (element != null && (project = (IProject)element.getAdapter(IProject.class)) != null && (jProject = JavaCore.create((IProject)project)) != null && jProject.exists()) {
            javaProject = jProject;
        }
        this.configurePreferenceLink(this.fFormatConfigLink, javaProject, "org.eclipse.jdt.ui.preferences.CodeFormatterPreferencePage", "org.eclipse.jdt.ui.propertyPages.CodeFormatterPreferencePage");
        this.configurePreferenceLink(this.fOrganizeImportsConfigLink, javaProject, "org.eclipse.jdt.ui.preferences.ImportOrganizePreferencePage", "org.eclipse.jdt.ui.propertyPages.ImportOrganizePreferencePage");
        super.initialize(context, element);
    }

    @Override
    public void performDefaults() {
        if ("project".equals(this.fContext.getName()) && !this.hasSettingsInScope(this.fContext)) {
            return;
        }
        this.enabled(true);
        this.fSettings = "project".equals(this.fContext.getName()) ? CleanUpPreferenceUtil.loadSaveParticipantOptions(InstanceScope.INSTANCE) : JavaPlugin.getDefault().getCleanUpRegistry().getDefaultOptions(2).getMap();
        this.settingsChanged();
        super.performDefaults();
    }

    @Override
    public void performOk() {
        super.performOk();
        if (!"project".equals(this.fContext.getName()) || this.hasSettingsInScope(this.fContext)) {
            CleanUpPreferenceUtil.saveSaveParticipantOptions(this.fContext, this.fSettings);
        }
    }

    @Override
    public void enableProjectSettings() {
        super.enableProjectSettings();
        CleanUpPreferenceUtil.saveSaveParticipantOptions(this.fContext, this.fSettings);
    }

    @Override
    public void disableProjectSettings() {
        super.disableProjectSettings();
        IEclipsePreferences node = this.fContext.getNode("org.eclipse.jdt.ui");
        Set<String> keys = JavaPlugin.getDefault().getCleanUpRegistry().getDefaultOptions(2).getKeys();
        for (String key : keys) {
            node.remove("sp_" + key);
        }
    }

    @Override
    protected String getPostSaveListenerId() {
        return "org.eclipse.jdt.ui.postsavelistener.cleanup";
    }

    @Override
    protected String getPostSaveListenerName() {
        return SaveParticipantMessages.CleanUpSaveParticipantPreferenceConfiguration_CleanUpActionsTopNodeName_Checkbox;
    }

    @Override
    protected void enabled(boolean isEnabled) {
        if (isEnabled) {
            if (this.fControlEnableState == null) {
                return;
            }
            this.fControlEnableState.restore();
            this.fControlEnableState = null;
        } else {
            if (this.fControlEnableState != null) {
                return;
            }
            this.fControlEnableState = ControlEnableState.disable((Control)this.fCleanUpOptionsComposite);
        }
    }

    private void settingsChanged() {
        this.fFormatCodeButton.setSelection("true".equals(this.fSettings.get("cleanup.format_source_code")));
        boolean isFormatting = this.fFormatCodeButton.getSelection();
        this.fFormatChangedOnlyButton.setSelection("true".equals(this.fSettings.get("cleanup.format_source_code_changes_only")));
        this.fFormatAllButton.setSelection("false".equals(this.fSettings.get("cleanup.format_source_code_changes_only")));
        this.fFormatChangedOnlyButton.setEnabled(isFormatting);
        this.fFormatAllButton.setEnabled(isFormatting);
        this.fFormatConfigLink.setEnabled(isFormatting);
        this.fOrganizeImportsButton.setSelection("true".equals(this.fSettings.get("cleanup.organize_imports")));
        this.fOrganizeImportsConfigLink.setEnabled(this.fOrganizeImportsButton.getSelection());
        this.fAdditionalActionButton.setSelection("true".equals(this.fSettings.get("cleanup.on_save_use_additional_actions")));
        boolean additionalEnabled = "true".equals(this.fSettings.get("cleanup.on_save_use_additional_actions"));
        this.fSelectedActionsText.setEnabled(additionalEnabled);
        this.fConfigureButton.setEnabled(additionalEnabled);
        HashMap<String, String> settings = new HashMap<String, String>(this.fSettings);
        settings.put("cleanup.format_source_code", "false");
        settings.put("cleanup.organize_imports", "false");
        MapCleanUpOptions options = new MapCleanUpOptions(settings);
        this.fSelectedActionsText.setText(this.getSelectedCleanUpsText(options));
    }

    private String getSelectedCleanUpsText(CleanUpOptions options) {
        StringBuffer buf = new StringBuffer();
        ICleanUp[] cleanUps = JavaPlugin.getDefault().getCleanUpRegistry().createCleanUps();
        int i = 0;
        while (i < cleanUps.length) {
            cleanUps[i].setOptions(options);
            String[] descriptions = cleanUps[i].getStepDescriptions();
            if (descriptions != null) {
                int j = 0;
                while (j < descriptions.length) {
                    if (buf.length() > 0) {
                        buf.append('\n');
                    }
                    buf.append(descriptions[j]);
                    ++j;
                }
            }
            ++i;
        }
        String string = buf.toString();
        return string;
    }

    private void configurePreferenceLink(Link link, final IJavaProject javaProject, final String preferenceId, final String propertyId) {
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CleanUpSaveParticipantPreferenceConfiguration.this.fContainer instanceof IWorkbenchPreferenceContainer) {
                    IWorkbenchPreferenceContainer container = (IWorkbenchPreferenceContainer)CleanUpSaveParticipantPreferenceConfiguration.this.fContainer;
                    if (javaProject != null) {
                        container.openPage(propertyId, null);
                    } else {
                        container.openPage(preferenceId, null);
                    }
                } else {
                    PreferencesUtil.createPreferenceDialogOn((Shell)CleanUpSaveParticipantPreferenceConfiguration.this.fShell, (String)preferenceId, null, null);
                }
            }
        });
    }

    private void changeSettingsValue(String key, boolean enabled) {
        String value = enabled ? "true" : "false";
        this.fSettings.put(key, value);
        this.settingsChanged();
    }
}

