/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTMatcher;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ArrayAccess;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.AssertStatement;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.BaseCallMessageSend;
import org.eclipse.jdt.core.dom.BaseConstructorInvocation;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BlockComment;
import org.eclipse.jdt.core.dom.BooleanLiteral;
import org.eclipse.jdt.core.dom.BreakStatement;
import org.eclipse.jdt.core.dom.CallinMappingDeclaration;
import org.eclipse.jdt.core.dom.CalloutMappingDeclaration;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.CharacterLiteral;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.ChildPropertyDescriptor;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConditionalExpression;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.ContinueStatement;
import org.eclipse.jdt.core.dom.CreationReference;
import org.eclipse.jdt.core.dom.Dimension;
import org.eclipse.jdt.core.dom.DoStatement;
import org.eclipse.jdt.core.dom.EmptyStatement;
import org.eclipse.jdt.core.dom.EnhancedForStatement;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.ExportsDirective;
import org.eclipse.jdt.core.dom.ExpressionMethodReference;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldAccessSpec;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.GuardPredicateDeclaration;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.InstanceofExpression;
import org.eclipse.jdt.core.dom.IntersectionType;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.LabeledStatement;
import org.eclipse.jdt.core.dom.LambdaExpression;
import org.eclipse.jdt.core.dom.LiftingType;
import org.eclipse.jdt.core.dom.LineComment;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MemberRef;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.MethodBindingOperator;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.MethodRef;
import org.eclipse.jdt.core.dom.MethodRefParameter;
import org.eclipse.jdt.core.dom.MethodSpec;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.ModuleDeclaration;
import org.eclipse.jdt.core.dom.ModuleModifier;
import org.eclipse.jdt.core.dom.NameQualifiedType;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.NullLiteral;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.OpensDirective;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.ParameterMapping;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.PrecedenceDeclaration;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.ProvidesDirective;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.RequiresDirective;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.RoleTypeDeclaration;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimplePropertyDescriptor;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.SuperMethodReference;
import org.eclipse.jdt.core.dom.SwitchCase;
import org.eclipse.jdt.core.dom.SwitchStatement;
import org.eclipse.jdt.core.dom.SynchronizedStatement;
import org.eclipse.jdt.core.dom.TSuperConstructorInvocation;
import org.eclipse.jdt.core.dom.TSuperMessageSend;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.TextElement;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.ThrowStatement;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.TypeAnchor;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclarationStatement;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.jdt.core.dom.TypeMethodReference;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.core.dom.UnionType;
import org.eclipse.jdt.core.dom.UsesDirective;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.WhileStatement;
import org.eclipse.jdt.core.dom.WildcardType;
import org.eclipse.jdt.core.dom.WithinStatement;
import org.eclipse.jdt.internal.core.dom.NaiveASTFlattener;

public abstract class ASTNode {
    public static final int ANONYMOUS_CLASS_DECLARATION = 1;
    public static final int ARRAY_ACCESS = 2;
    public static final int ARRAY_CREATION = 3;
    public static final int ARRAY_INITIALIZER = 4;
    public static final int ARRAY_TYPE = 5;
    public static final int ASSERT_STATEMENT = 6;
    public static final int ASSIGNMENT = 7;
    public static final int BLOCK = 8;
    public static final int BOOLEAN_LITERAL = 9;
    public static final int BREAK_STATEMENT = 10;
    public static final int CAST_EXPRESSION = 11;
    public static final int CATCH_CLAUSE = 12;
    public static final int CHARACTER_LITERAL = 13;
    public static final int CLASS_INSTANCE_CREATION = 14;
    public static final int COMPILATION_UNIT = 15;
    public static final int CONDITIONAL_EXPRESSION = 16;
    public static final int CONSTRUCTOR_INVOCATION = 17;
    public static final int CONTINUE_STATEMENT = 18;
    public static final int DO_STATEMENT = 19;
    public static final int EMPTY_STATEMENT = 20;
    public static final int EXPRESSION_STATEMENT = 21;
    public static final int FIELD_ACCESS = 22;
    public static final int FIELD_DECLARATION = 23;
    public static final int FOR_STATEMENT = 24;
    public static final int IF_STATEMENT = 25;
    public static final int IMPORT_DECLARATION = 26;
    public static final int INFIX_EXPRESSION = 27;
    public static final int INITIALIZER = 28;
    public static final int JAVADOC = 29;
    public static final int LABELED_STATEMENT = 30;
    public static final int METHOD_DECLARATION = 31;
    public static final int METHOD_INVOCATION = 32;
    public static final int NULL_LITERAL = 33;
    public static final int NUMBER_LITERAL = 34;
    public static final int PACKAGE_DECLARATION = 35;
    public static final int PARENTHESIZED_EXPRESSION = 36;
    public static final int POSTFIX_EXPRESSION = 37;
    public static final int PREFIX_EXPRESSION = 38;
    public static final int PRIMITIVE_TYPE = 39;
    public static final int QUALIFIED_NAME = 40;
    public static final int RETURN_STATEMENT = 41;
    public static final int SIMPLE_NAME = 42;
    public static final int SIMPLE_TYPE = 43;
    public static final int SINGLE_VARIABLE_DECLARATION = 44;
    public static final int STRING_LITERAL = 45;
    public static final int SUPER_CONSTRUCTOR_INVOCATION = 46;
    public static final int SUPER_FIELD_ACCESS = 47;
    public static final int SUPER_METHOD_INVOCATION = 48;
    public static final int SWITCH_CASE = 49;
    public static final int SWITCH_STATEMENT = 50;
    public static final int SYNCHRONIZED_STATEMENT = 51;
    public static final int THIS_EXPRESSION = 52;
    public static final int THROW_STATEMENT = 53;
    public static final int TRY_STATEMENT = 54;
    public static final int TYPE_DECLARATION = 55;
    public static final int TYPE_DECLARATION_STATEMENT = 56;
    public static final int TYPE_LITERAL = 57;
    public static final int VARIABLE_DECLARATION_EXPRESSION = 58;
    public static final int VARIABLE_DECLARATION_FRAGMENT = 59;
    public static final int VARIABLE_DECLARATION_STATEMENT = 60;
    public static final int WHILE_STATEMENT = 61;
    public static final int INSTANCEOF_EXPRESSION = 62;
    public static final int LINE_COMMENT = 63;
    public static final int BLOCK_COMMENT = 64;
    public static final int TAG_ELEMENT = 65;
    public static final int TEXT_ELEMENT = 66;
    public static final int MEMBER_REF = 67;
    public static final int METHOD_REF = 68;
    public static final int METHOD_REF_PARAMETER = 69;
    public static final int ENHANCED_FOR_STATEMENT = 70;
    public static final int ENUM_DECLARATION = 71;
    public static final int ENUM_CONSTANT_DECLARATION = 72;
    public static final int TYPE_PARAMETER = 73;
    public static final int PARAMETERIZED_TYPE = 74;
    public static final int QUALIFIED_TYPE = 75;
    public static final int WILDCARD_TYPE = 76;
    public static final int NORMAL_ANNOTATION = 77;
    public static final int MARKER_ANNOTATION = 78;
    public static final int SINGLE_MEMBER_ANNOTATION = 79;
    public static final int MEMBER_VALUE_PAIR = 80;
    public static final int ANNOTATION_TYPE_DECLARATION = 81;
    public static final int ANNOTATION_TYPE_MEMBER_DECLARATION = 82;
    public static final int MODIFIER = 83;
    public static final int UNION_TYPE = 84;
    public static final int DIMENSION = 85;
    public static final int LAMBDA_EXPRESSION = 86;
    public static final int INTERSECTION_TYPE = 87;
    public static final int NAME_QUALIFIED_TYPE = 88;
    public static final int CREATION_REFERENCE = 89;
    public static final int EXPRESSION_METHOD_REFERENCE = 90;
    public static final int SUPER_METHOD_REFERENCE = 91;
    public static final int TYPE_METHOD_REFERENCE = 92;
    public static final int MODULE_DECLARATION = 93;
    public static final int REQUIRES_DIRECTIVE = 94;
    public static final int EXPORTS_DIRECTIVE = 95;
    public static final int OPENS_DIRECTIVE = 96;
    public static final int USES_DIRECTIVE = 97;
    public static final int PROVIDES_DIRECTIVE = 98;
    public static final int MODULE_MODIFIER = 99;
    public static final int METHOD_SPEC = 100;
    public static final int CALLIN_MAPPING_DECLARATION = 101;
    public static final int CALLOUT_MAPPING_DECLARATION = 102;
    public static final int LIFTING_TYPE = 103;
    public static final int WITHIN_STATEMENT = 104;
    public static final int BASE_CONSTRUCTOR_INVOCATION = 105;
    public static final int PARAMETER_MAPPING = 106;
    public static final int BASE_CALL_MESSAGE_SEND = 107;
    public static final int FIELD_ACCESS_SPEC = 108;
    public static final int ROLE_TYPE_DECLARATION = 109;
    public static final int TSUPER_MESSAGE_SEND = 110;
    public static final int TSUPER_CONSTRUCTOR_INVOCATION = 111;
    public static final int TYPE_ANCHOR = 112;
    public static final int PRECEDENCE_DECLARATION = 113;
    public static final int GUARD_PREDICATE_DECLARATION = 114;
    public static final int METHOD_BINDING_OPERATOR = 115;
    final AST ast;
    private ASTNode parent = null;
    private static final Map UNMODIFIABLE_EMPTY_MAP = Collections.unmodifiableMap(new HashMap(1));
    private Object property1 = null;
    private Object property2 = null;
    private int startPosition = -1;
    private int length = 0;
    public static final int MALFORMED = 1;
    public static final int ORIGINAL = 2;
    public static final int PROTECT = 4;
    public static final int RECOVERED = 8;
    int typeAndFlags = 0;
    private StructuralPropertyDescriptor location = null;
    static final boolean CYCLE_RISK = true;
    static final boolean NO_CYCLE_RISK = false;
    static final boolean MANDATORY = true;
    static final boolean OPTIONAL = false;
    static final int HEADERS = 12;
    static final int BASE_NODE_SIZE = 40;

    public static Class nodeClassForType(int nodeType) {
        switch (nodeType) {
            case 81: {
                return AnnotationTypeDeclaration.class;
            }
            case 82: {
                return AnnotationTypeMemberDeclaration.class;
            }
            case 1: {
                return AnonymousClassDeclaration.class;
            }
            case 2: {
                return ArrayAccess.class;
            }
            case 3: {
                return ArrayCreation.class;
            }
            case 4: {
                return ArrayInitializer.class;
            }
            case 5: {
                return ArrayType.class;
            }
            case 6: {
                return AssertStatement.class;
            }
            case 7: {
                return Assignment.class;
            }
            case 8: {
                return Block.class;
            }
            case 64: {
                return BlockComment.class;
            }
            case 9: {
                return BooleanLiteral.class;
            }
            case 10: {
                return BreakStatement.class;
            }
            case 11: {
                return CastExpression.class;
            }
            case 12: {
                return CatchClause.class;
            }
            case 13: {
                return CharacterLiteral.class;
            }
            case 14: {
                return ClassInstanceCreation.class;
            }
            case 15: {
                return CompilationUnit.class;
            }
            case 16: {
                return ConditionalExpression.class;
            }
            case 17: {
                return ConstructorInvocation.class;
            }
            case 18: {
                return ContinueStatement.class;
            }
            case 89: {
                return CreationReference.class;
            }
            case 85: {
                return Dimension.class;
            }
            case 19: {
                return DoStatement.class;
            }
            case 20: {
                return EmptyStatement.class;
            }
            case 70: {
                return EnhancedForStatement.class;
            }
            case 72: {
                return EnumConstantDeclaration.class;
            }
            case 71: {
                return EnumDeclaration.class;
            }
            case 95: {
                return ExportsDirective.class;
            }
            case 90: {
                return ExpressionMethodReference.class;
            }
            case 21: {
                return ExpressionStatement.class;
            }
            case 22: {
                return FieldAccess.class;
            }
            case 23: {
                return FieldDeclaration.class;
            }
            case 24: {
                return ForStatement.class;
            }
            case 25: {
                return IfStatement.class;
            }
            case 26: {
                return ImportDeclaration.class;
            }
            case 27: {
                return InfixExpression.class;
            }
            case 28: {
                return Initializer.class;
            }
            case 62: {
                return InstanceofExpression.class;
            }
            case 87: {
                return IntersectionType.class;
            }
            case 29: {
                return Javadoc.class;
            }
            case 30: {
                return LabeledStatement.class;
            }
            case 86: {
                return LambdaExpression.class;
            }
            case 63: {
                return LineComment.class;
            }
            case 78: {
                return MarkerAnnotation.class;
            }
            case 67: {
                return MemberRef.class;
            }
            case 80: {
                return MemberValuePair.class;
            }
            case 31: {
                return MethodDeclaration.class;
            }
            case 32: {
                return MethodInvocation.class;
            }
            case 68: {
                return MethodRef.class;
            }
            case 69: {
                return MethodRefParameter.class;
            }
            case 83: {
                return Modifier.class;
            }
            case 93: {
                return ModuleDeclaration.class;
            }
            case 99: {
                return ModuleModifier.class;
            }
            case 88: {
                return NameQualifiedType.class;
            }
            case 77: {
                return NormalAnnotation.class;
            }
            case 33: {
                return NullLiteral.class;
            }
            case 34: {
                return NumberLiteral.class;
            }
            case 96: {
                return OpensDirective.class;
            }
            case 35: {
                return PackageDeclaration.class;
            }
            case 74: {
                return ParameterizedType.class;
            }
            case 36: {
                return ParenthesizedExpression.class;
            }
            case 37: {
                return PostfixExpression.class;
            }
            case 38: {
                return PrefixExpression.class;
            }
            case 39: {
                return PrimitiveType.class;
            }
            case 98: {
                return ProvidesDirective.class;
            }
            case 40: {
                return QualifiedName.class;
            }
            case 75: {
                return QualifiedType.class;
            }
            case 94: {
                return RequiresDirective.class;
            }
            case 41: {
                return ReturnStatement.class;
            }
            case 42: {
                return SimpleName.class;
            }
            case 43: {
                return SimpleType.class;
            }
            case 79: {
                return SingleMemberAnnotation.class;
            }
            case 44: {
                return SingleVariableDeclaration.class;
            }
            case 45: {
                return StringLiteral.class;
            }
            case 46: {
                return SuperConstructorInvocation.class;
            }
            case 47: {
                return SuperFieldAccess.class;
            }
            case 48: {
                return SuperMethodInvocation.class;
            }
            case 91: {
                return SuperMethodReference.class;
            }
            case 49: {
                return SwitchCase.class;
            }
            case 50: {
                return SwitchStatement.class;
            }
            case 51: {
                return SynchronizedStatement.class;
            }
            case 65: {
                return TagElement.class;
            }
            case 66: {
                return TextElement.class;
            }
            case 52: {
                return ThisExpression.class;
            }
            case 53: {
                return ThrowStatement.class;
            }
            case 54: {
                return TryStatement.class;
            }
            case 55: {
                return TypeDeclaration.class;
            }
            case 56: {
                return TypeDeclarationStatement.class;
            }
            case 92: {
                return TypeMethodReference.class;
            }
            case 57: {
                return TypeLiteral.class;
            }
            case 73: {
                return TypeParameter.class;
            }
            case 84: {
                return UnionType.class;
            }
            case 97: {
                return UsesDirective.class;
            }
            case 58: {
                return VariableDeclarationExpression.class;
            }
            case 59: {
                return VariableDeclarationFragment.class;
            }
            case 60: {
                return VariableDeclarationStatement.class;
            }
            case 61: {
                return WhileStatement.class;
            }
            case 76: {
                return WildcardType.class;
            }
            case 100: {
                return MethodSpec.class;
            }
            case 101: {
                return CallinMappingDeclaration.class;
            }
            case 102: {
                return CalloutMappingDeclaration.class;
            }
            case 103: {
                return LiftingType.class;
            }
            case 104: {
                return WithinStatement.class;
            }
            case 110: {
                return TSuperMessageSend.class;
            }
            case 111: {
                return TSuperConstructorInvocation.class;
            }
            case 105: {
                return BaseConstructorInvocation.class;
            }
            case 106: {
                return ParameterMapping.class;
            }
            case 107: {
                return BaseCallMessageSend.class;
            }
            case 108: {
                return FieldAccessSpec.class;
            }
            case 109: {
                return RoleTypeDeclaration.class;
            }
            case 112: {
                return TypeAnchor.class;
            }
            case 113: {
                return PrecedenceDeclaration.class;
            }
            case 114: {
                return GuardPredicateDeclaration.class;
            }
            case 115: {
                return MethodBindingOperator.class;
            }
        }
        throw new IllegalArgumentException();
    }

    ASTNode(AST ast) {
        if (ast == null) {
            throw new IllegalArgumentException();
        }
        this.ast = ast;
        this.setNodeType(this.getNodeType0());
        this.setFlags(ast.getDefaultNodeFlag());
    }

    public final AST getAST() {
        return this.ast;
    }

    public final ASTNode getParent() {
        return this.parent;
    }

    public final StructuralPropertyDescriptor getLocationInParent() {
        return this.location;
    }

    public final ASTNode getRoot() {
        ASTNode candidate = this;
        ASTNode p;
        while ((p = candidate.getParent()) != null) {
            candidate = p;
        }
        return candidate;
    }

    public final Object getStructuralProperty(StructuralPropertyDescriptor property) {
        if (property instanceof SimplePropertyDescriptor) {
            SimplePropertyDescriptor p = (SimplePropertyDescriptor)property;
            if (p.getValueType() == Integer.TYPE) {
                int result = this.internalGetSetIntProperty(p, true, 0);
                return result;
            }
            if (p.getValueType() == Boolean.TYPE) {
                boolean result = this.internalGetSetBooleanProperty(p, true, false);
                return result;
            }
            return this.internalGetSetObjectProperty(p, true, null);
        }
        if (property instanceof ChildPropertyDescriptor) {
            return this.internalGetSetChildProperty((ChildPropertyDescriptor)property, true, null);
        }
        if (property instanceof ChildListPropertyDescriptor) {
            return this.internalGetChildListProperty((ChildListPropertyDescriptor)property);
        }
        throw new IllegalArgumentException();
    }

    public final void setStructuralProperty(StructuralPropertyDescriptor property, Object value) {
        if (property instanceof SimplePropertyDescriptor) {
            SimplePropertyDescriptor p = (SimplePropertyDescriptor)property;
            if (p.getValueType() == Integer.TYPE) {
                int arg = (Integer)value;
                this.internalGetSetIntProperty(p, false, arg);
                return;
            }
            if (p.getValueType() == Boolean.TYPE) {
                boolean arg = (Boolean)value;
                this.internalGetSetBooleanProperty(p, false, arg);
                return;
            }
            if (value == null && p.isMandatory()) {
                throw new IllegalArgumentException();
            }
            this.internalGetSetObjectProperty(p, false, value);
            return;
        }
        if (property instanceof ChildPropertyDescriptor) {
            ChildPropertyDescriptor p = (ChildPropertyDescriptor)property;
            ASTNode child = (ASTNode)value;
            if (child == null && p.isMandatory()) {
                throw new IllegalArgumentException();
            }
            this.internalGetSetChildProperty(p, false, child);
            return;
        }
        if (property instanceof ChildListPropertyDescriptor) {
            throw new IllegalArgumentException("Cannot set the list of child list property");
        }
    }

    int internalGetSetIntProperty(SimplePropertyDescriptor property, boolean get, int value) {
        throw new RuntimeException("Node does not have this property");
    }

    boolean internalGetSetBooleanProperty(SimplePropertyDescriptor property, boolean get, boolean value) {
        throw new RuntimeException("Node does not have this property");
    }

    Object internalGetSetObjectProperty(SimplePropertyDescriptor property, boolean get, Object value) {
        throw new RuntimeException("Node does not have this property");
    }

    ASTNode internalGetSetChildProperty(ChildPropertyDescriptor property, boolean get, ASTNode child) {
        throw new RuntimeException("Node does not have this property");
    }

    List internalGetChildListProperty(ChildListPropertyDescriptor property) {
        throw new RuntimeException("Node does not have this property");
    }

    public final List structuralPropertiesForType() {
        return this.internalStructuralPropertiesForType(this.ast.apiLevel);
    }

    abstract List internalStructuralPropertiesForType(int var1);

    static void createPropertyList(Class nodeClass, List propertyList) {
        propertyList.add(nodeClass);
    }

    static void addProperty(StructuralPropertyDescriptor property, List propertyList) {
        Class nodeClass = (Class)propertyList.get(0);
        if (property.getNodeClass() != nodeClass) {
            throw new RuntimeException("Structural property descriptor has wrong node class!");
        }
        propertyList.add(property);
    }

    static List reapPropertyList(List propertyList) {
        propertyList.remove(0);
        ArrayList a = new ArrayList(propertyList.size());
        a.addAll(propertyList);
        return Collections.unmodifiableList(a);
    }

    final void unsupportedIn2() {
        if (this.ast.apiLevel == 2) {
            throw new UnsupportedOperationException("Operation not supported in JLS2 AST");
        }
    }

    final void unsupportedIn2_3() {
        if (this.ast.apiLevel <= 3) {
            throw new UnsupportedOperationException("Operation only supported in JLS4 and later AST");
        }
    }

    final void unsupportedIn2_3_4() {
        if (this.ast.apiLevel < 8) {
            throw new UnsupportedOperationException("Operation only supported in JLS8 and later AST");
        }
    }

    final void unsupportedBelow9() {
        if (this.ast.apiLevel < 9) {
            throw new UnsupportedOperationException("Operation only supported in JLS9 and later AST");
        }
    }

    final void unsupportedBelow10() {
        if (this.ast.apiLevel < 10) {
            throw new UnsupportedOperationException("Operation only supported in ASTs with level JLS10 and above");
        }
    }

    final void supportedOnlyIn2() {
        if (this.ast.apiLevel != 2) {
            throw new UnsupportedOperationException("Operation only supported in JLS2 AST");
        }
    }

    final void supportedOnlyIn2_3_4() {
        if (this.ast.apiLevel >= 8) {
            throw new UnsupportedOperationException("Operation only supported in JLS2, JLS3 and JLS4 ASTs");
        }
    }

    void setParent(ASTNode parent, StructuralPropertyDescriptor property) {
        this.ast.modifying();
        this.parent = parent;
        this.location = property;
    }

    public final void delete() {
        StructuralPropertyDescriptor p = this.getLocationInParent();
        if (p == null) {
            return;
        }
        if (p.isChildProperty()) {
            this.getParent().setStructuralProperty(this.location, null);
            return;
        }
        if (p.isChildListProperty()) {
            List l = (List)this.getParent().getStructuralProperty(this.location);
            l.remove(this);
        }
    }

    static void checkNewChild(ASTNode node, ASTNode newChild, boolean cycleCheck, Class nodeType) {
        if (newChild.ast != node.ast) {
            throw new IllegalArgumentException();
        }
        if (newChild.getParent() != null) {
            throw new IllegalArgumentException();
        }
        if (cycleCheck && newChild == node.getRoot()) {
            throw new IllegalArgumentException();
        }
        Class<?> childClass = newChild.getClass();
        if (nodeType != null && !nodeType.isAssignableFrom(childClass)) {
            throw new ClassCastException();
        }
        if ((newChild.typeAndFlags & 4) != 0) {
            throw new IllegalArgumentException("AST node cannot be modified");
        }
    }

    final void preReplaceChild(ASTNode oldChild, ASTNode newChild, ChildPropertyDescriptor property) {
        if ((this.typeAndFlags & 4) != 0) {
            throw new IllegalArgumentException("AST node cannot be modified");
        }
        if (newChild != null) {
            ASTNode.checkNewChild(this, newChild, property.cycleRisk, null);
        }
        if (oldChild != null) {
            if ((oldChild.typeAndFlags & 4) != 0) {
                throw new IllegalArgumentException("AST node cannot be modified");
            }
            if (newChild != null) {
                this.ast.preReplaceChildEvent(this, oldChild, newChild, property);
            } else {
                this.ast.preRemoveChildEvent(this, oldChild, property);
            }
            oldChild.setParent(null, null);
        } else if (newChild != null) {
            this.ast.preAddChildEvent(this, newChild, property);
        }
        if (newChild != null) {
            newChild.setParent(this, property);
        }
    }

    final void postReplaceChild(ASTNode oldChild, ASTNode newChild, ChildPropertyDescriptor property) {
        if (newChild != null) {
            if (oldChild != null) {
                this.ast.postReplaceChildEvent(this, oldChild, newChild, property);
            } else {
                this.ast.postAddChildEvent(this, newChild, property);
            }
        } else {
            this.ast.postRemoveChildEvent(this, oldChild, property);
        }
    }

    final void preValueChange(SimplePropertyDescriptor property) {
        if ((this.typeAndFlags & 4) != 0) {
            throw new IllegalArgumentException("AST node cannot be modified");
        }
        this.ast.preValueChangeEvent(this, property);
        this.ast.modifying();
    }

    final void postValueChange(SimplePropertyDescriptor property) {
        this.ast.postValueChangeEvent(this, property);
    }

    final void checkModifiable() {
        if ((this.typeAndFlags & 4) != 0) {
            throw new IllegalArgumentException("AST node cannot be modified");
        }
        this.ast.modifying();
    }

    final void preLazyInit() {
        this.ast.disableEvents();
    }

    final void postLazyInit(ASTNode newChild, ChildPropertyDescriptor property) {
        newChild.setParent(this, property);
        this.ast.reenableEvents();
    }

    public final Object getProperty(String propertyName) {
        if (propertyName == null) {
            throw new IllegalArgumentException();
        }
        if (this.property1 == null) {
            return null;
        }
        if (this.property1 instanceof String) {
            if (propertyName.equals(this.property1)) {
                return this.property2;
            }
            return null;
        }
        Map m = (Map)this.property1;
        return m.get(propertyName);
    }

    public final void setProperty(String propertyName, Object data) {
        if (propertyName == null) {
            throw new IllegalArgumentException();
        }
        if (this.property1 == null) {
            if (data == null) {
                return;
            }
            this.property1 = propertyName;
            this.property2 = data;
            return;
        }
        if (this.property1 instanceof String) {
            if (propertyName.equals(this.property1)) {
                if (data == null) {
                    this.property1 = null;
                    this.property2 = null;
                } else {
                    this.property2 = data;
                }
                return;
            }
            if (data == null) {
                return;
            }
            HashMap<Object, Object> m = new HashMap<Object, Object>(3);
            m.put(this.property1, this.property2);
            m.put(propertyName, data);
            this.property1 = m;
            this.property2 = null;
            return;
        }
        Map m = (Map)this.property1;
        if (data == null) {
            m.remove(propertyName);
            if (m.size() == 1) {
                Map.Entry[] entries = m.entrySet().toArray(new Map.Entry[1]);
                this.property1 = entries[0].getKey();
                this.property2 = entries[0].getValue();
            }
            return;
        }
        m.put(propertyName, data);
    }

    public final Map properties() {
        if (this.property1 == null) {
            return UNMODIFIABLE_EMPTY_MAP;
        }
        if (this.property1 instanceof String) {
            return Collections.singletonMap(this.property1, this.property2);
        }
        if (this.property2 == null) {
            this.property2 = Collections.unmodifiableMap((Map)this.property1);
        }
        return (Map)this.property2;
    }

    public final int getFlags() {
        return this.typeAndFlags & 0xFFFF;
    }

    public final void setFlags(int flags) {
        this.ast.modifying();
        int old = this.typeAndFlags & 0xFFFF0000;
        this.typeAndFlags = old | flags & 0xFFFF;
    }

    public final int getNodeType() {
        return this.typeAndFlags >>> 16;
    }

    private void setNodeType(int nodeType) {
        int old = this.typeAndFlags & 0xFFFF0000;
        this.typeAndFlags = old | nodeType << 16;
    }

    abstract int getNodeType0();

    public final boolean equals(Object obj) {
        return this == obj;
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public final boolean subtreeMatch(ASTMatcher matcher, Object other) {
        return this.subtreeMatch0(matcher, other);
    }

    abstract boolean subtreeMatch0(ASTMatcher var1, Object var2);

    public static ASTNode copySubtree(AST target, ASTNode node) {
        if (node == null) {
            return null;
        }
        if (target == null) {
            throw new IllegalArgumentException();
        }
        if (target.apiLevel() != node.getAST().apiLevel()) {
            throw new UnsupportedOperationException();
        }
        ASTNode newNode = node.clone(target);
        return newNode;
    }

    public static List copySubtrees(AST target, List nodes) {
        ArrayList<ASTNode> result = new ArrayList<ASTNode>(nodes.size());
        for (ASTNode oldNode : nodes) {
            ASTNode newNode = oldNode.clone(target);
            result.add(newNode);
        }
        return result;
    }

    final ASTNode clone(AST target) {
        this.ast.preCloneNodeEvent(this);
        ASTNode c = this.clone0(target);
        this.ast.postCloneNodeEvent(this, c);
        return c;
    }

    abstract ASTNode clone0(AST var1);

    public final void accept(ASTVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException();
        }
        if (visitor.preVisit2(this)) {
            this.accept0(visitor);
        }
        visitor.postVisit(this);
    }

    abstract void accept0(ASTVisitor var1);

    final void acceptChild(ASTVisitor visitor, ASTNode child) {
        if (child == null) {
            return;
        }
        child.accept(visitor);
    }

    final void acceptChildren(ASTVisitor visitor, NodeList children) {
        NodeList.Cursor cursor = children.newCursor();
        try {
            while (cursor.hasNext()) {
                ASTNode child = (ASTNode)cursor.next();
                child.accept(visitor);
            }
        }
        finally {
            children.releaseCursor(cursor);
        }
    }

    public final int getStartPosition() {
        return this.startPosition;
    }

    public final int getLength() {
        return this.length;
    }

    public final void setSourceRange(int startPosition, int length) {
        if (startPosition >= 0 && length < 0) {
            throw new IllegalArgumentException();
        }
        if (startPosition < 0 && length != 0) {
            throw new IllegalArgumentException();
        }
        this.checkModifiable();
        this.startPosition = startPosition;
        this.length = length;
    }

    public final String toString() {
        StringBuffer buffer = new StringBuffer();
        int p = buffer.length();
        try {
            this.appendDebugString(buffer);
        }
        catch (RuntimeException runtimeException) {
            buffer.setLength(p);
            buffer.append("!");
            buffer.append(this.standardToString());
        }
        return buffer.toString();
    }

    final String standardToString() {
        return super.toString();
    }

    void appendDebugString(StringBuffer buffer) {
        this.appendPrintString(buffer);
    }

    final void appendPrintString(StringBuffer buffer) {
        NaiveASTFlattener printer = new NaiveASTFlattener();
        this.accept(printer);
        buffer.append(printer.getResult());
    }

    static int stringSize(String string) {
        int size = 0;
        if (string != null) {
            size += 28;
            size += 12 + 2 * string.length();
        }
        return size;
    }

    public final int subtreeBytes() {
        return this.treeSize();
    }

    abstract int treeSize();

    abstract int memSize();

    class NodeList
    extends AbstractList {
        ArrayList store = new ArrayList(0);
        ChildListPropertyDescriptor propertyDescriptor;
        private List cursors = null;

        NodeList(ChildListPropertyDescriptor property) {
            this.propertyDescriptor = property;
        }

        @Override
        public int size() {
            return this.store.size();
        }

        @Override
        public Object get(int index) {
            return this.store.get(index);
        }

        @Override
        public Object set(int index, Object element) {
            if (element == null) {
                throw new IllegalArgumentException();
            }
            if ((ASTNode.this.typeAndFlags & 4) != 0) {
                throw new IllegalArgumentException("AST node cannot be modified");
            }
            ASTNode newChild = (ASTNode)element;
            ASTNode oldChild = (ASTNode)this.store.get(index);
            if (oldChild == newChild) {
                return oldChild;
            }
            if ((oldChild.typeAndFlags & 4) != 0) {
                throw new IllegalArgumentException("AST node cannot be modified");
            }
            ASTNode.checkNewChild(ASTNode.this, newChild, this.propertyDescriptor.cycleRisk, this.propertyDescriptor.elementType);
            ASTNode.this.ast.preReplaceChildEvent(ASTNode.this, oldChild, newChild, this.propertyDescriptor);
            ASTNode result = this.store.set(index, newChild);
            oldChild.setParent(null, null);
            newChild.setParent(ASTNode.this, this.propertyDescriptor);
            ASTNode.this.ast.postReplaceChildEvent(ASTNode.this, oldChild, newChild, this.propertyDescriptor);
            return result;
        }

        @Override
        public void add(int index, Object element) {
            if (element == null) {
                throw new IllegalArgumentException();
            }
            if ((ASTNode.this.typeAndFlags & 4) != 0) {
                throw new IllegalArgumentException("AST node cannot be modified");
            }
            ASTNode newChild = (ASTNode)element;
            ASTNode.checkNewChild(ASTNode.this, newChild, this.propertyDescriptor.cycleRisk, this.propertyDescriptor.elementType);
            ASTNode.this.ast.preAddChildEvent(ASTNode.this, newChild, this.propertyDescriptor);
            this.store.add(index, element);
            this.updateCursors(index, 1);
            newChild.setParent(ASTNode.this, this.propertyDescriptor);
            ASTNode.this.ast.postAddChildEvent(ASTNode.this, newChild, this.propertyDescriptor);
        }

        @Override
        public Object remove(int index) {
            if ((ASTNode.this.typeAndFlags & 4) != 0) {
                throw new IllegalArgumentException("AST node cannot be modified");
            }
            ASTNode oldChild = (ASTNode)this.store.get(index);
            if ((oldChild.typeAndFlags & 4) != 0) {
                throw new IllegalArgumentException("AST node cannot be modified");
            }
            ASTNode.this.ast.preRemoveChildEvent(ASTNode.this, oldChild, this.propertyDescriptor);
            oldChild.setParent(null, null);
            Object result = this.store.remove(index);
            this.updateCursors(index, -1);
            ASTNode.this.ast.postRemoveChildEvent(ASTNode.this, oldChild, this.propertyDescriptor);
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Cursor newCursor() {
            NodeList nodeList = this;
            synchronized (nodeList) {
                if (this.cursors == null) {
                    this.cursors = new ArrayList(1);
                }
                Cursor result = new Cursor();
                this.cursors.add(result);
                return result;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void releaseCursor(Cursor cursor) {
            NodeList nodeList = this;
            synchronized (nodeList) {
                this.cursors.remove(cursor);
                if (this.cursors.isEmpty()) {
                    this.cursors = null;
                }
            }
        }

        private synchronized void updateCursors(int index, int delta) {
            if (this.cursors == null) {
                return;
            }
            for (Cursor c : this.cursors) {
                c.update(index, delta);
            }
        }

        int memSize() {
            int result = 32;
            result += 20;
            return result += 12 + 4 * this.size();
        }

        int listSize() {
            int result = this.memSize();
            for (ASTNode child : this) {
                result += child.treeSize();
            }
            return result;
        }

        class Cursor
        implements Iterator {
            private int position = 0;

            Cursor() {
            }

            @Override
            public boolean hasNext() {
                return this.position < NodeList.this.store.size();
            }

            public Object next() {
                Object result = NodeList.this.store.get(this.position);
                ++this.position;
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            void update(int index, int delta) {
                if (this.position > index) {
                    this.position += delta;
                }
            }
        }
    }
}

