/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.policies;

import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import javafx.geometry.Point2D;
import javafx.scene.transform.Transform;
import org.eclipse.gef.fx.nodes.InfiniteCanvas;
import org.eclipse.gef.geometry.convert.fx.FX2Geometry;
import org.eclipse.gef.geometry.planar.AffineTransform;
import org.eclipse.gef.mvc.fx.operations.ChangeViewportOperation;
import org.eclipse.gef.mvc.fx.operations.ITransactionalOperation;
import org.eclipse.gef.mvc.fx.policies.AbstractPolicy;

public class ViewportPolicy
extends AbstractPolicy {
    private static final double DEFAULT_ZOOM_MIN = 0.0625;
    private static final double DEFAULT_ZOOM_MAX = 16.0;

    @Override
    protected ITransactionalOperation createOperation() {
        InfiniteCanvas canvas = (InfiniteCanvas)this.getHost().getRoot().getViewer().getCanvas();
        return new ChangeViewportOperation(canvas, FX2Geometry.toAffineTransform((Transform)canvas.getContentTransform()));
    }

    public void fitToSize() {
        this.fitToSize(0.0625, 16.0);
    }

    public void fitToSize(double zoomMin) {
        this.fitToSize(zoomMin, 16.0);
    }

    public void fitToSize(double zoomMin, double zoomMax) {
        ChangeViewportOperation viewportOperation = this.getChangeViewportOperation();
        InfiniteCanvas canvas = viewportOperation.getInfiniteCanvas();
        if (canvas.getContentBounds().isEmpty()) {
            return;
        }
        canvas.fitToSize(zoomMin, zoomMax);
        viewportOperation.setNewContentTransform(FX2Geometry.toAffineTransform((Transform)canvas.getContentTransform()));
        viewportOperation.setNewHorizontalScrollOffset(canvas.getHorizontalScrollOffset());
        viewportOperation.setNewVerticalScrollOffset(canvas.getVerticalScrollOffset());
    }

    protected ChangeViewportOperation getChangeViewportOperation() {
        return (ChangeViewportOperation)super.getOperation();
    }

    public void scroll(boolean concatenate, double deltaTranslateX, double deltaTranslateY) {
        this.checkInitialized();
        ChangeViewportOperation operation = this.getChangeViewportOperation();
        operation.setNewHorizontalScrollOffset((concatenate ? operation.getNewHorizontalScrollOffset() : operation.getInitialHorizontalScrollOffset()) + deltaTranslateX);
        operation.setNewVerticalScrollOffset((concatenate ? operation.getNewVerticalScrollOffset() : operation.getInitialVerticalScrollOffset()) + deltaTranslateY);
        this.locallyExecuteOperation();
    }

    public void setScroll(double tx, double ty) {
        this.checkInitialized();
        AffineTransform newTransform = this.getChangeViewportOperation().getNewContentTransform();
        this.getChangeViewportOperation().setNewContentTransform(new AffineTransform(newTransform.getM00(), newTransform.getM10(), newTransform.getM01(), newTransform.getM11(), tx, ty));
        this.locallyExecuteOperation();
    }

    public void setZoom(double zoom) {
        this.checkInitialized();
        AffineTransform newTransform = this.getChangeViewportOperation().getNewContentTransform();
        this.getChangeViewportOperation().setNewContentTransform(new AffineTransform(zoom, newTransform.getM10(), newTransform.getM01(), zoom, newTransform.getTranslateX(), newTransform.getTranslateY()));
        this.locallyExecuteOperation();
    }

    public void zoom(boolean concatenate, boolean discretize, double relativeZoom, double sceneX, double sceneY) {
        double newZoomLevel;
        this.checkInitialized();
        double discreteZoomLevel = 0.0;
        if (discretize) {
            double oldZoomLevel = this.getChangeViewportOperation().getNewContentTransform().getScaleX();
            discreteZoomLevel = oldZoomLevel * relativeZoom;
            DecimalFormat df = new DecimalFormat("#.######");
            df.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ENGLISH));
            df.setRoundingMode(RoundingMode.HALF_EVEN);
            discreteZoomLevel = Double.parseDouble(df.format(discreteZoomLevel));
            int ozli = (int)oldZoomLevel;
            int nzli = (int)discreteZoomLevel;
            if (ozli != nzli && (double)nzli != discreteZoomLevel && (double)ozli != oldZoomLevel) {
                discreteZoomLevel = ozli < nzli ? nzli : ozli;
            }
        }
        Point2D contentGroupPivot = ((InfiniteCanvas)this.getHost().getRoot().getViewer().getCanvas()).getContentGroup().sceneToLocal(sceneX, sceneY);
        AffineTransform zoomTx = new AffineTransform().translate(contentGroupPivot.getX(), contentGroupPivot.getY()).scale(relativeZoom, relativeZoom).translate(-contentGroupPivot.getX(), -contentGroupPivot.getY());
        if (concatenate) {
            this.getChangeViewportOperation().concatenateToNewContentTransform(zoomTx);
        } else {
            AffineTransform newTx = this.getChangeViewportOperation().getInitialContentTransform().getCopy().concatenate(zoomTx);
            this.getChangeViewportOperation().setNewContentTransform(newTx);
        }
        if (discretize && Math.abs((newZoomLevel = this.getChangeViewportOperation().getNewContentTransform().getScaleX()) - discreteZoomLevel) < 0.01) {
            this.setZoom(discreteZoomLevel);
        }
        this.locallyExecuteOperation();
    }
}

