/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.handlers;

import javafx.geometry.Bounds;
import javafx.geometry.HPos;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import org.eclipse.gef.fx.nodes.InfiniteCanvas;
import org.eclipse.gef.geometry.convert.fx.FX2Geometry;
import org.eclipse.gef.geometry.planar.Rectangle;
import org.eclipse.gef.mvc.fx.parts.IVisualPart;
import org.eclipse.gef.mvc.fx.policies.ViewportPolicy;

public class PanningSupport {
    public void removeFreeSpace(ViewportPolicy viewportPolicy, Pos orientation, boolean alignIfContentsFit) {
        InfiniteCanvas canvas = (InfiniteCanvas)((IVisualPart)viewportPolicy.getAdaptable()).getRoot().getViewer().getCanvas();
        Rectangle viewportBoundsInCanvasLocal = new Rectangle(0.0, 0.0, canvas.getWidth(), canvas.getHeight());
        Rectangle contentBoundsInCanvasLocal = FX2Geometry.toRectangle((Bounds)canvas.getContentBounds());
        HPos hpos = orientation.getHpos();
        double deltaTx = 0.0;
        if (hpos != null) {
            if (HPos.RIGHT.equals((Object)hpos)) {
                double freeSpaceRight = viewportBoundsInCanvasLocal.getRight().x - contentBoundsInCanvasLocal.getRight().x;
                deltaTx = alignIfContentsFit && contentBoundsInCanvasLocal.getWidth() <= viewportBoundsInCanvasLocal.getWidth() || contentBoundsInCanvasLocal.getWidth() > viewportBoundsInCanvasLocal.getWidth() && freeSpaceRight > 0.0 ? freeSpaceRight : 0.0;
            } else if (HPos.LEFT.equals((Object)hpos)) {
                double freeSpaceLeft = contentBoundsInCanvasLocal.getLeft().x - viewportBoundsInCanvasLocal.getLeft().x;
                deltaTx = alignIfContentsFit && contentBoundsInCanvasLocal.getWidth() <= viewportBoundsInCanvasLocal.getWidth() || contentBoundsInCanvasLocal.getWidth() > viewportBoundsInCanvasLocal.getWidth() && freeSpaceLeft > 0.0 ? -freeSpaceLeft : 0.0;
            }
        }
        VPos vpos = orientation.getVpos();
        double deltaTy = 0.0;
        if (vpos != null) {
            if (VPos.BOTTOM.equals((Object)vpos)) {
                double freeSpaceBottom = viewportBoundsInCanvasLocal.getBottom().y - contentBoundsInCanvasLocal.getBottom().y;
                deltaTy = alignIfContentsFit && contentBoundsInCanvasLocal.getHeight() <= viewportBoundsInCanvasLocal.getHeight() || contentBoundsInCanvasLocal.getHeight() > viewportBoundsInCanvasLocal.getHeight() && freeSpaceBottom > 0.0 ? freeSpaceBottom : 0.0;
            } else if (VPos.TOP.equals((Object)vpos)) {
                double freeSpaceTop = contentBoundsInCanvasLocal.getTop().y - viewportBoundsInCanvasLocal.getTop().y;
                double d = deltaTy = alignIfContentsFit && contentBoundsInCanvasLocal.getHeight() <= viewportBoundsInCanvasLocal.getHeight() || contentBoundsInCanvasLocal.getHeight() > viewportBoundsInCanvasLocal.getHeight() && freeSpaceTop > 0.0 ? -freeSpaceTop : 0.0;
            }
        }
        if (deltaTx != 0.0 || deltaTy != 0.0) {
            viewportPolicy.scroll(true, deltaTx, deltaTy);
        }
    }
}

