/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ide.processors;

import javax.inject.Inject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.epp.internal.logging.aeri.ide.IProcessorDescriptor;
import org.eclipse.epp.logging.aeri.core.IReport;
import org.eclipse.epp.logging.aeri.core.IReportProcessor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class StepsToReproduceProcessor
implements IReportProcessor {
    private final IProcessorDescriptor descriptor;

    @Inject
    public StepsToReproduceProcessor(IProcessorDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public boolean wantsToContribute(IStatus status, IEclipseContext context) {
        return false;
    }

    public boolean canContribute(IStatus status, IEclipseContext context) {
        return true;
    }

    public void process(IReport report, IStatus status, IEclipseContext context) {
        Shell activeShell = (Shell)context.get("activeShell");
        if (activeShell == null) {
            return;
        }
        Boolean shown = (Boolean)context.get(this.getContextKey());
        if (shown == null || !shown.booleanValue()) {
            MessageDialog.openInformation((Shell)activeShell, (String)"Steps to Reproduce", (String)"Please provide detailed steps to reproduce this error into the 'Comment' section. This will help developers fix this problem.");
            context.set(this.getContextKey(), (Object)Boolean.TRUE);
        }
    }

    private String getContextKey() {
        return "processor." + this.descriptor.getDirective() + ".value";
    }
}

