/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.server.core.subinterfaces;

import com.google.common.base.Optional;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.emfstore.internal.common.model.util.FileUtil;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.internal.server.core.subinterfaces.Messages;
import org.eclipse.emf.emfstore.internal.server.model.versioning.ChangePackage;
import org.eclipse.emf.emfstore.internal.server.model.versioning.FileBasedChangePackage;
import org.eclipse.emf.emfstore.internal.server.model.versioning.VersioningFactory;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.AbstractOperation;
import org.eclipse.emf.emfstore.server.ESCloseableIterable;
import org.eclipse.emf.emfstore.server.exceptions.ESException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangePackageFragmentUploadAdapter
extends AdapterImpl {
    private final Map<String, File> proxyIdToChangePackageFragments = new LinkedHashMap<String, File>();
    private final Map<String, File> proxyIdToCompletedChangePackages = new LinkedHashMap<String, File>();

    public void addFragment(String proxyId, List<String> fragment) throws ESException {
        File file = this.proxyIdToChangePackageFragments.get(proxyId);
        if (file == null) {
            file = new File(String.valueOf(FileUtil.createLocationForTemporaryChangePackage()) + ".temp");
            this.proxyIdToChangePackageFragments.put(proxyId, file);
        }
        FileWriter writer = null;
        try {
            try {
                writer = new FileWriter(file, true);
                for (String str : fragment) {
                    writer.write(String.valueOf(str) + System.getProperty("line.separator"));
                }
            }
            catch (IOException ex) {
                throw new ESException(Messages.ChangePackageFragmentUploadAdapter_SplittingFailed, ex);
            }
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException ex) {
                    throw new ESException(Messages.ChangePackageFragmentAdapter_SaveChangePackageFailed, ex);
                }
            }
        }
    }

    public void markAsComplete(String proxyId) throws ESException {
        File possiblyCompletedChangePackage = this.proxyIdToCompletedChangePackages.get(proxyId);
        File fileBasedChangePackage = this.proxyIdToChangePackageFragments.get(proxyId);
        if (possiblyCompletedChangePackage != null) {
            throw new ESException(Messages.ChangePackageFragmentUploadAdapter_ChangePackageAlreadyComplete);
        }
        if (fileBasedChangePackage == null) {
            throw new ESException(MessageFormat.format(Messages.ChangePackageFragmentUploadAdapter_NoChangePackageFragmentsFound, proxyId));
        }
        this.proxyIdToCompletedChangePackages.put(proxyId, fileBasedChangePackage);
        this.proxyIdToChangePackageFragments.remove(proxyId);
    }

    public Optional<ChangePackage> convertFileBasedToInMemoryChangePackage(String proxyId) {
        File file = this.proxyIdToCompletedChangePackages.get(proxyId);
        if (file == null) {
            return Optional.absent();
        }
        FileBasedChangePackage cp = VersioningFactory.eINSTANCE.createFileBasedChangePackage();
        String path = file.getAbsolutePath().substring(0, file.getAbsolutePath().length() - ".temp".length());
        cp.setFilePath(path);
        ESCloseableIterable operationsHandle = cp.operations();
        ChangePackage changePackage = VersioningFactory.eINSTANCE.createChangePackage();
        try {
            for (AbstractOperation operation : operationsHandle.iterable()) {
                changePackage.add((AbstractOperation)ModelUtil.clone((EObject)operation));
            }
        }
        finally {
            operationsHandle.close();
        }
        return Optional.of((Object)changePackage);
    }

    public Optional<FileBasedChangePackage> getFileBasedChangePackage(String proxyId) {
        File file = this.proxyIdToCompletedChangePackages.get(proxyId);
        if (file == null) {
            return Optional.absent();
        }
        FileBasedChangePackage cp = VersioningFactory.eINSTANCE.createFileBasedChangePackage();
        String path = file.getAbsolutePath().substring(0, file.getAbsolutePath().length() - ".temp".length());
        cp.setFilePath(path);
        try {
            cp.save();
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
        return Optional.of((Object)cp);
    }

    public void clearCompleted(String proxyId) {
        this.proxyIdToCompletedChangePackages.remove(proxyId);
    }
}

