/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.ui.decorators;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.emfstore.client.ESLocalProject;
import org.eclipse.emf.emfstore.client.observer.ESCommitObserver;
import org.eclipse.emf.emfstore.client.observer.ESUpdateObserver;
import org.eclipse.emf.emfstore.common.ESObserver;
import org.eclipse.emf.emfstore.internal.client.model.ESWorkspaceProviderImpl;
import org.eclipse.emf.emfstore.internal.client.model.ProjectSpace;
import org.eclipse.emf.emfstore.server.model.ESChangePackage;
import org.eclipse.emf.emfstore.server.model.versionspec.ESPrimaryVersionSpec;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionDecorator
extends AdapterImpl
implements ILightweightLabelDecorator,
ESUpdateObserver,
ESCommitObserver {
    private final ArrayList<ILabelProviderListener> listeners = new ArrayList();

    public VersionDecorator() {
        ESWorkspaceProviderImpl.getObserverBus().register((ESObserver)this);
    }

    public void decorate(Object element, IDecoration decoration) {
        if (element instanceof ProjectSpace) {
            ProjectSpace projectSpace = (ProjectSpace)element;
            StringBuilder stringBuilder = new StringBuilder();
            if (projectSpace.getBaseVersion() != null) {
                stringBuilder.append("@");
                stringBuilder.append(projectSpace.getBaseVersion().getIdentifier());
                stringBuilder.append(" [" + projectSpace.getBaseVersion().getBranch() + "]");
            } else {
                stringBuilder.append("(Not shared)");
            }
            String string = stringBuilder.toString();
            decoration.addSuffix(string);
        }
    }

    public void addListener(ILabelProviderListener listener) {
        this.listeners.add(listener);
    }

    public void dispose() {
        this.listeners.removeAll(this.listeners);
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
        this.listeners.remove(listener);
    }

    public void notifyChanged(Notification msg) {
        for (ILabelProviderListener listener : this.listeners) {
            listener.labelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)this));
        }
    }

    public boolean inspectChanges(ESLocalProject project, ESChangePackage changePackage, IProgressMonitor monitor) {
        return false;
    }

    public void commitCompleted(ESLocalProject project, ESPrimaryVersionSpec newRevision, IProgressMonitor monitor) {
        this.update();
    }

    public boolean inspectChanges(ESLocalProject project, List<ESChangePackage> changePackages, IProgressMonitor monitor) {
        return true;
    }

    public void updateCompleted(ESLocalProject project, IProgressMonitor monitor) {
        this.update();
    }

    private void update() {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                PlatformUI.getWorkbench().getDecoratorManager().update("org.eclipse.emf.emfstore.client.ui.decorators.VersionDecorator");
            }
        });
    }
}

