/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.ui.diffuidata.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.diffmerge.api.IMatch;
import org.eclipse.emf.diffmerge.api.Role;
import org.eclipse.emf.diffmerge.api.diff.IDifference;
import org.eclipse.emf.diffmerge.api.diff.IElementRelativePresence;
import org.eclipse.emf.diffmerge.api.diff.IReferenceValuePresence;
import org.eclipse.emf.diffmerge.diffdata.EMatch;
import org.eclipse.emf.diffmerge.diffdata.EMergeableDifference;
import org.eclipse.emf.diffmerge.diffdata.EValuePresence;
import org.eclipse.emf.diffmerge.ui.EMFDiffMergeUIPlugin;
import org.eclipse.emf.diffmerge.ui.diffuidata.ComparisonSelection;
import org.eclipse.emf.diffmerge.ui.diffuidata.DiffuidataPackage;
import org.eclipse.emf.diffmerge.ui.diffuidata.MatchAndFeature;
import org.eclipse.emf.diffmerge.util.structures.FArrayList;
import org.eclipse.emf.diffmerge.util.structures.FOrderedSet;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.jface.viewers.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComparisonSelectionImpl
extends EObjectImpl
implements ComparisonSelection {
    protected EList<EMatch> selectedMatches;
    private EList<EMergeableDifference> _differences;
    private EList<EObject> _concernedElements;
    private Role _preferredSide;
    protected MatchAndFeature selectedMatchAndFeature;
    protected EList<EMatch> selectedTreePath;
    protected EList<EValuePresence> selectedValuePresences;

    protected ComparisonSelectionImpl() {
    }

    public ComparisonSelectionImpl(Object selected_p, Role preferredSide_p) {
        Collection collection;
        this._preferredSide = preferredSide_p;
        if (selected_p instanceof EMatch) {
            this.getSelectedMatches().add((Object)((EMatch)selected_p));
        } else if (selected_p instanceof MatchAndFeature) {
            this.selectedMatchAndFeature = (MatchAndFeature)selected_p;
        } else if (selected_p instanceof TreePath) {
            TreePath path = (TreePath)selected_p;
            int i = 0;
            while (i < path.getSegmentCount()) {
                this.getSelectedTreePath().add((Object)((EMatch)path.getSegment(i)));
                ++i;
            }
        } else if (selected_p instanceof EValuePresence) {
            this.getSelectedValuePresences().add((Object)((EValuePresence)selected_p));
        } else if (selected_p instanceof Collection && !(collection = (Collection)selected_p).isEmpty()) {
            ArrayList<EMatch> matches = new ArrayList<EMatch>();
            ArrayList<EValuePresence> presences = new ArrayList<EValuePresence>();
            for (Object current : collection) {
                if (current instanceof EValuePresence) {
                    presences.add((EValuePresence)current);
                    continue;
                }
                if (!(current instanceof EMatch)) continue;
                matches.add((EMatch)current);
            }
            if (!presences.isEmpty()) {
                this.getSelectedValuePresences().addAll(presences);
            } else {
                this.getSelectedMatches().addAll(matches);
            }
        }
    }

    protected EClass eStaticClass() {
        return DiffuidataPackage.Literals.COMPARISON_SELECTION;
    }

    @Override
    public EList<EMatch> getSelectedMatches() {
        if (this.selectedMatches == null) {
            this.selectedMatches = new EObjectResolvingEList(EMatch.class, (InternalEObject)this, 0);
        }
        return this.selectedMatches;
    }

    @Override
    public MatchAndFeature getSelectedMatchAndFeature() {
        return this.selectedMatchAndFeature;
    }

    public NotificationChain basicSetSelectedMatchAndFeature(MatchAndFeature newSelectedMatchAndFeature, NotificationChain msgs_p) {
        NotificationChain msgs = msgs_p;
        MatchAndFeature oldSelectedMatchAndFeature = this.selectedMatchAndFeature;
        this.selectedMatchAndFeature = newSelectedMatchAndFeature;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldSelectedMatchAndFeature, (Object)newSelectedMatchAndFeature);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public EList<EMatch> getSelectedTreePath() {
        if (this.selectedTreePath == null) {
            this.selectedTreePath = new EObjectResolvingEList(EMatch.class, (InternalEObject)this, 2);
        }
        return this.selectedTreePath;
    }

    @Override
    public EList<EValuePresence> getSelectedValuePresences() {
        if (this.selectedValuePresences == null) {
            this.selectedValuePresences = new EObjectResolvingEList(EValuePresence.class, (InternalEObject)this, 3);
        }
        return this.selectedValuePresences;
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 1: {
                return this.basicSetSelectedMatchAndFeature(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getSelectedMatches();
            }
            case 1: {
                return this.getSelectedMatchAndFeature();
            }
            case 2: {
                return this.getSelectedTreePath();
            }
            case 3: {
                return this.getSelectedValuePresences();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.selectedMatches != null && !this.selectedMatches.isEmpty();
            }
            case 1: {
                return this.selectedMatchAndFeature != null;
            }
            case 2: {
                return this.selectedTreePath != null && !this.selectedTreePath.isEmpty();
            }
            case 3: {
                return this.selectedValuePresences != null && !this.selectedValuePresences.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public EList<EMergeableDifference> asDifferencesToMerge() {
        if (this._differences == null) {
            this._differences = this.getDifferencesToMerge();
        }
        return ECollections.unmodifiableEList(this._differences);
    }

    @Override
    public EStructuralFeature asFeature() {
        Object result = null;
        if (this.getSelectedMatchAndFeature() != null) {
            result = this.getSelectedMatchAndFeature().getFeature();
        } else {
            EValuePresence presence = this.asValuePresence();
            if (presence != null) {
                result = this.representAsOwnership((IDifference)presence) ? EMFDiffMergeUIPlugin.getDefault().getOwnershipFeature() : presence.getFeature();
            }
        }
        return result;
    }

    @Override
    public EMatch asMatch() {
        EMatch result = null;
        if (!this.getSelectedMatches().isEmpty()) {
            result = (EMatch)this.getSelectedMatches().get(0);
        } else if (!this.getSelectedTreePath().isEmpty()) {
            result = (EMatch)this.getSelectedTreePath().get(this.getSelectedTreePath().size() - 1);
        } else if (this.getSelectedMatchAndFeature() != null) {
            result = this.getSelectedMatchAndFeature().getMatch();
        } else if (!this.getSelectedValuePresences().isEmpty()) {
            EValuePresence presence = this.asValuePresence();
            result = this.representAsOwnership((IDifference)presence) ? (EMatch)((IReferenceValuePresence)presence).getValueMatch() : presence.getElementMatch();
        }
        return result;
    }

    @Override
    public EList<EMatch> asMatches() {
        FOrderedSet result = ECollections.emptyEList();
        if (!this.getSelectedMatches().isEmpty()) {
            result = this.getSelectedMatches();
        } else if (!this.getSelectedValuePresences().isEmpty()) {
            result = new FOrderedSet();
            for (EValuePresence valuePresence : this.getSelectedValuePresences()) {
                EMatch match = valuePresence.getElementMatch();
                if (match == null) continue;
                result.add((Object)match);
            }
        } else if (this.getSelectedMatchAndFeature() != null || this.getSelectedTreePath() != null) {
            result = new BasicEList(1);
            EMatch match = this.asMatch();
            if (match != null) {
                result.add((Object)match);
            }
        }
        return ECollections.unmodifiableEList(result);
    }

    @Override
    public TreePath asMatchPath() {
        TreePath result = null;
        if (!this.getSelectedTreePath().isEmpty()) {
            result = new TreePath(this.getSelectedTreePath().toArray());
        }
        return result;
    }

    @Override
    public EList<EValuePresence> asValuePresences() {
        return this.getSelectedValuePresences();
    }

    @Override
    public EValuePresence asValuePresence() {
        EValuePresence result = null;
        if (!this.getSelectedValuePresences().isEmpty()) {
            result = (EValuePresence)this.getSelectedValuePresences().get(0);
        }
        return result;
    }

    @Override
    public void dispose() {
        if (this._concernedElements != null) {
            this._concernedElements.clear();
        }
        if (this._differences != null) {
            this._differences.clear();
        }
        this.selectedMatchAndFeature = null;
        if (this.selectedMatches != null) {
            this.selectedMatches.clear();
        }
        if (this.selectedTreePath != null) {
            this.selectedTreePath.clear();
        }
        if (this.selectedValuePresences != null) {
            this.selectedValuePresences.clear();
        }
    }

    private EList<EObject> getConcernedElements() {
        FOrderedSet result;
        block4: {
            EObject element;
            EList<EMatch> matches;
            block3: {
                result = new FOrderedSet();
                matches = this.asMatches();
                if (!matches.isEmpty() && this._preferredSide != null) break block3;
                for (EMergeableDifference difference : this.asDifferencesToMerge()) {
                    IElementRelativePresence elementDifference;
                    IMatch match;
                    if (!(difference instanceof IElementRelativePresence) || (match = (elementDifference = (IElementRelativePresence)difference).getElementMatch()) == null) continue;
                    EObject element2 = match.get(elementDifference.getPresenceRole());
                    result.add((Object)element2);
                }
                break block4;
            }
            for (EMatch match : matches) {
                element = match.get(this._preferredSide);
                if (element == null) continue;
                result.add((Object)element);
            }
            if (!result.isEmpty()) break block4;
            for (EMatch match : matches) {
                element = match.get(this._preferredSide.opposite());
                if (element == null) continue;
                result.add((Object)element);
            }
        }
        return result;
    }

    private EList<EMergeableDifference> getDifferencesToMerge() {
        FArrayList result = new FArrayList();
        if (!this.asValuePresences().isEmpty()) {
            result.addAll(this.asValuePresences());
        } else if (!this.getSelectedMatches().isEmpty()) {
            for (EMatch match : this.getSelectedMatches()) {
                result.addAll((Collection)match.getAllDifferences());
            }
        } else {
            EValuePresence presence = this.asValuePresence();
            if (presence != null) {
                result.add((Object)presence);
            } else {
                EMatch match = this.asMatch();
                EStructuralFeature feature = this.asFeature();
                if (match != null && feature != null) {
                    if (feature instanceof EAttribute) {
                        result.addAll(match.getAttributeDifferences((EAttribute)feature));
                    } else {
                        result.addAll(match.getReferenceDifferences((EReference)feature));
                    }
                } else if (match != null) {
                    result.addAll((Collection)match.getAllDifferences());
                }
            }
        }
        return result;
    }

    public EObject getFirstElement() {
        List<EObject> list = this.toList();
        return list.isEmpty() ? null : list.get(0);
    }

    public boolean isEmpty() {
        return this.getSelectedMatches().isEmpty() && this.getSelectedMatchAndFeature() == null && this.getSelectedTreePath().isEmpty() && this.getSelectedValuePresences().isEmpty();
    }

    public Iterator<EObject> iterator() {
        return this.toList().iterator();
    }

    private boolean representAsOwnership(IDifference difference_p) {
        boolean result = false;
        if (difference_p instanceof IReferenceValuePresence) {
            IReferenceValuePresence presence = (IReferenceValuePresence)difference_p;
            EReference ref = presence.getFeature();
            result = !presence.isOrder() && ref != null && ref.isContainment();
        }
        return result;
    }

    public int size() {
        return this.toList().size();
    }

    public Object[] toArray() {
        return this.toList().toArray();
    }

    public List<EObject> toList() {
        if (this._concernedElements == null) {
            this._concernedElements = this.getConcernedElements();
        }
        return ECollections.unmodifiableEList(this._concernedElements);
    }
}

