/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.internal.externalfile;

import java.io.InputStream;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.datatools.sqltools.editor.core.connection.ISQLEditorConnectionInfo;
import org.eclipse.datatools.sqltools.sqleditor.ISQLEditorInput;
import org.eclipse.datatools.sqltools.sqleditor.SQLEditorConnectionInfo;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.editors.text.ILocationProvider;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class ExternalSQLFileEditorInput
implements IPathEditorInput,
IStorageEditorInput,
ILocationProvider,
ISQLEditorInput {
    private IFileStore fFileStore;
    private WorkbenchAdapter fWorkbenchAdapter = new WorkbenchAdapter();
    private IStorage fStorage;
    private IPath fPath;
    private ISQLEditorConnectionInfo fConnInfo;

    public ExternalSQLFileEditorInput(IFileStore fileStore) {
        Assert.isNotNull((Object)fileStore);
        Assert.isTrue((boolean)"file".equals(fileStore.getFileSystem().getScheme()));
        this.fFileStore = fileStore;
        this.fWorkbenchAdapter = new WorkbenchAdapter();
        this.setConnectionInfo(SQLEditorConnectionInfo.DEFAULT_SQLEDITOR_CONNECTION_INFO);
    }

    public boolean exists() {
        return this.fFileStore.fetchInfo().exists();
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getName() {
        return this.fFileStore.getName();
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        return this.fFileStore.toString();
    }

    public Object getAdapter(Class adapter) {
        if (ILocationProvider.class.equals((Object)adapter)) {
            return this;
        }
        if (IWorkbenchAdapter.class.equals((Object)adapter)) {
            return this.fWorkbenchAdapter;
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public IPath getPath(Object element) {
        if (element instanceof ExternalSQLFileEditorInput) {
            return ((ExternalSQLFileEditorInput)element).getPath();
        }
        return null;
    }

    public IPath getPath() {
        if (this.fPath == null) {
            this.fPath = new Path(this.fFileStore.toURI().getPath());
        }
        return this.fPath;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ExternalSQLFileEditorInput) {
            ExternalSQLFileEditorInput input = (ExternalSQLFileEditorInput)o;
            return this.fFileStore.equals(input.fFileStore);
        }
        if (o instanceof IPathEditorInput) {
            IPathEditorInput input = (IPathEditorInput)o;
            return this.getPath().equals((Object)input.getPath());
        }
        return false;
    }

    public int hashCode() {
        return this.fFileStore.hashCode();
    }

    public IStorage getStorage() throws CoreException {
        if (this.fStorage == null) {
            this.fStorage = new SQLEditorStorage(this.fFileStore);
        }
        return this.fStorage;
    }

    public ISQLEditorConnectionInfo getConnectionInfo() {
        return this.fConnInfo;
    }

    public String getFactoryId() {
        return "org.eclipse.datatools.sqltools.sqleditor.SQLEditorInputFactory";
    }

    public void setConnectionInfo(ISQLEditorConnectionInfo connInfo) {
        this.fConnInfo = connInfo == null ? SQLEditorConnectionInfo.DEFAULT_SQLEDITOR_CONNECTION_INFO : connInfo;
    }

    public boolean isConnectionRequired() {
        return false;
    }

    public String getId() {
        return String.valueOf(this.getClass().getName()) + "(" + this.getPath().toString() + ")";
    }

    private class SQLEditorStorage
    implements IStorage {
        private IFileStore fFileStore;
        private IPath fFullPath;

        public SQLEditorStorage(IFileStore fileStore) {
            Assert.isNotNull((Object)fileStore);
            Assert.isTrue((boolean)"file".equals(fileStore.getFileSystem().getScheme()));
            this.fFileStore = fileStore;
        }

        public InputStream getContents() throws CoreException {
            return this.fFileStore.openInputStream(0, null);
        }

        public IPath getFullPath() {
            if (this.fFullPath == null) {
                this.fFullPath = new Path(this.fFileStore.toURI().getPath());
            }
            return this.fFullPath;
        }

        public String getName() {
            return this.fFileStore.getName();
        }

        public boolean isReadOnly() {
            return this.fFileStore.fetchInfo().getAttribute(2);
        }

        public Object getAdapter(Class adapter) {
            return null;
        }
    }

    private class WorkbenchAdapter
    implements IWorkbenchAdapter {
        private WorkbenchAdapter() {
        }

        public Object[] getChildren(Object o) {
            return null;
        }

        public ImageDescriptor getImageDescriptor(Object object) {
            return null;
        }

        public String getLabel(Object o) {
            return ((ExternalSQLFileEditorInput)o).getName();
        }

        public Object getParent(Object o) {
            return null;
        }
    }
}

