/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.result.internal.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.eclipse.datatools.sqltools.result.OperationCommand;
import org.eclipse.datatools.sqltools.result.ResultsViewPlugin;
import org.eclipse.datatools.sqltools.result.internal.index.IResultHistoryIndex;
import org.eclipse.datatools.sqltools.result.internal.utils.ILogger;
import org.eclipse.datatools.sqltools.result.model.IResultInstance;

public class ResultHistoryLuceneIndex
implements IResultHistoryIndex {
    private static ILogger _log = ResultsViewPlugin.getLogger(null);
    private static final String FIELD_OPERATION = "operation";
    private static final String FIELD_ACTION = "action";
    private static final String FIELD_CONSUMER = "consumer";
    private static final String FIELD_FREQ = "frequency";
    private static final String FIELD_IDENTIFIER = "identifier";
    private static int ID = 10000;
    private Map _id2result;
    private Map _result2id;
    private Directory _ramDir = new RAMDirectory();
    private IndexWriter _writer;
    private Analyzer _analyzer = new StandardAnalyzer();
    private List _instances;

    public ResultHistoryLuceneIndex() {
        this._id2result = new HashMap();
        this._result2id = new HashMap();
        this._instances = new ArrayList();
        try {
            IndexWriterConfig conf = new IndexWriterConfig(this._analyzer);
            conf.setOpenMode(IndexWriterConfig.OpenMode.CREATE);
            this._writer = new IndexWriter(this._ramDir, conf);
            this._writer.close();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    @Override
    public void addResult(IResultInstance instance) {
        this.addResults(new IResultInstance[]{instance});
    }

    private String getCombinedDisplayString(IResultInstance instance) {
        StringBuffer sb = new StringBuffer("");
        sb.append(instance.getOperationCommand().getDisplayString()).append(" ");
        for (IResultInstance ins : instance.getSubResults()) {
            sb.append(this.getCombinedDisplayString(ins));
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addResults(IResultInstance[] instances) {
        ResultHistoryLuceneIndex resultHistoryLuceneIndex = this;
        synchronized (resultHistoryLuceneIndex) {
            if (instances != null) {
                try {
                    IndexWriterConfig conf = new IndexWriterConfig(this._analyzer);
                    conf.setOpenMode(IndexWriterConfig.OpenMode.APPEND);
                    this._writer = new IndexWriter(this._ramDir, conf);
                    int i = 0;
                    while (i < instances.length) {
                        IResultInstance instance = instances[i];
                        if (!this._instances.contains(instance) && instance != null) {
                            this._instances.add(instance);
                            Document doc = new Document();
                            doc.add((IndexableField)new TextField(FIELD_OPERATION, this.getCombinedDisplayString(instance), Field.Store.YES));
                            doc.add((IndexableField)new TextField(FIELD_ACTION, OperationCommand.getActionString(instance.getOperationCommand().getActionType()), Field.Store.YES));
                            doc.add((IndexableField)new TextField(FIELD_CONSUMER, instance.getOperationCommand().getConsumerName(), Field.Store.YES));
                            doc.add((IndexableField)new TextField(FIELD_FREQ, Integer.toString(instance.getFrequency()), Field.Store.YES));
                            doc.add((IndexableField)new StringField(FIELD_IDENTIFIER, Integer.toString(ID), Field.Store.YES));
                            this._id2result.put(Integer.toString(ID), instance);
                            this._result2id.put(instance, Integer.toString(ID));
                            ++ID;
                            try {
                                this._writer.addDocument((Iterable)doc);
                            }
                            catch (IOException ioe) {
                                _log.error("ResultHistoryLuceneIndex_io_error", (Throwable)ioe);
                            }
                        }
                        ++i;
                    }
                    this._writer.close();
                }
                catch (IOException ioe) {
                    _log.error("ResultHistoryLuceneIndex_io_error", (Throwable)ioe);
                }
            }
        }
    }

    @Override
    public void removeResult(IResultInstance instance) {
        this.removeResults(new IResultInstance[]{instance});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeResults(IResultInstance[] instances) {
        ResultHistoryLuceneIndex resultHistoryLuceneIndex = this;
        synchronized (resultHistoryLuceneIndex) {
            block10: {
                try {
                    if (instances == null) break block10;
                    IndexWriterConfig conf = new IndexWriterConfig(this._analyzer);
                    conf.setOpenMode(IndexWriterConfig.OpenMode.APPEND);
                    this._writer = new IndexWriter(this._ramDir, conf);
                    IResultInstance instance = null;
                    int i = 0;
                    while (i < instances.length) {
                        instance = instances[i];
                        if (instance != null) {
                            String id = (String)this._result2id.get(instance);
                            this._result2id.remove(instance);
                            this._id2result.remove(id);
                            if (id != null) {
                                try {
                                    this._writer.deleteDocuments(new Term[]{new Term(FIELD_IDENTIFIER, id)});
                                }
                                catch (IOException ioe) {
                                    _log.error("ResultHistoryLuceneIndex_io_error", (Throwable)ioe);
                                }
                            }
                        }
                        ++i;
                    }
                    this._writer.close();
                }
                catch (IOException ioe) {
                    _log.error("ResultHistoryLuceneIndex_io_error", (Throwable)ioe);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IResultInstance[] search(String expression) {
        if (expression == null) {
            return new IResultInstance[0];
        }
        ResultHistoryLuceneIndex resultHistoryLuceneIndex = this;
        synchronized (resultHistoryLuceneIndex) {
            QueryParser parser = new QueryParser(FIELD_OPERATION, this._analyzer);
            try {
                DirectoryReader reader = DirectoryReader.open((Directory)this._ramDir);
                Query query = parser.parse(expression);
                IndexSearcher searcher = new IndexSearcher((IndexReader)reader);
                TopDocs hits = searcher.search(query, reader.maxDoc());
                int count = hits.totalHits;
                IResultInstance[] instances = new IResultInstance[count];
                int i = 0;
                while (i < count) {
                    int docID = hits.scoreDocs[i].doc;
                    Document doc = searcher.doc(docID);
                    instances[i] = (IResultInstance)this._id2result.get(doc.getField(FIELD_IDENTIFIER).stringValue());
                    ++i;
                }
                reader.close();
                return instances;
            }
            catch (ParseException parseException) {
            }
            catch (IOException ioe) {
                _log.error("ResultHistoryLuceneIndex_io_error", (Throwable)ioe);
            }
            return new IResultInstance[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshResult(IResultInstance instance) {
        IResultInstance iResultInstance = instance;
        synchronized (iResultInstance) {
            this.removeResult(instance);
            this.addResult(instance);
        }
    }
}

