/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.property.value;

import java.util.AbstractSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.IStaleListener;
import org.eclipse.core.databinding.observable.ObservableTracker;
import org.eclipse.core.databinding.observable.StaleEvent;
import org.eclipse.core.databinding.observable.map.AbstractObservableMap;
import org.eclipse.core.databinding.observable.map.IMapChangeListener;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.map.MapChangeEvent;
import org.eclipse.core.databinding.observable.map.MapDiff;
import org.eclipse.core.databinding.property.IPropertyObservable;
import org.eclipse.core.databinding.property.value.DelegatingValueProperty;
import org.eclipse.core.internal.databinding.property.Util;
import org.eclipse.core.internal.databinding.property.value.DelegatingCache;

public class MapDelegatingValueObservableMap<S, K, I extends S, V>
extends AbstractObservableMap<K, V>
implements IPropertyObservable<DelegatingValueProperty<S, V>> {
    private IObservableMap<K, I> masterMap;
    private DelegatingValueProperty<S, V> detailProperty;
    private DelegatingCache<S, I, V> cache;
    private Set<Map.Entry<K, V>> entrySet;
    private IMapChangeListener<K, I> masterListener = new IMapChangeListener<K, I>(){

        public void handleMapChange(MapChangeEvent<? extends K, ? extends I> event) {
            if (MapDelegatingValueObservableMap.this.isDisposed()) {
                return;
            }
            MapDelegatingValueObservableMap.this.cache.addAll(MapDelegatingValueObservableMap.this.masterMap.values());
            MapDiff diff = this.convertDiff(event.diff);
            MapDelegatingValueObservableMap.this.cache.retainAll(MapDelegatingValueObservableMap.this.masterMap.values());
            MapDelegatingValueObservableMap.this.fireMapChange(diff);
        }

        private MapDiff<K, V> convertDiff(MapDiff<? extends K, ? extends I> diff) {
            HashMap oldValues = new HashMap();
            HashMap newValues = new HashMap();
            Set addedKeys = diff.getAddedKeys();
            for (Object key : addedKeys) {
                Object masterValue = diff.getNewValue(key);
                Object newValue = MapDelegatingValueObservableMap.this.cache.get(masterValue);
                newValues.put(key, newValue);
            }
            Set removedKeys = diff.getRemovedKeys();
            for (Object key : removedKeys) {
                Object masterValue = diff.getOldValue(key);
                Object oldValue = MapDelegatingValueObservableMap.this.cache.get(masterValue);
                oldValues.put(key, oldValue);
            }
            HashSet changedKeys = new HashSet(diff.getChangedKeys());
            Iterator it = changedKeys.iterator();
            while (it.hasNext()) {
                Object newValue;
                Object key = it.next();
                Object oldMasterValue = diff.getOldValue(key);
                Object newMasterValue = diff.getNewValue(key);
                Object oldValue = MapDelegatingValueObservableMap.this.cache.get(oldMasterValue);
                if (Util.equals(oldValue, newValue = MapDelegatingValueObservableMap.this.cache.get(newMasterValue))) {
                    it.remove();
                    continue;
                }
                oldValues.put(key, oldValue);
                newValues.put(key, newValue);
            }
            return Diffs.createMapDiff((Set)addedKeys, (Set)removedKeys, changedKeys, oldValues, newValues);
        }
    };
    private IStaleListener staleListener = new IStaleListener(){

        public void handleStale(StaleEvent staleEvent) {
            MapDelegatingValueObservableMap.this.fireStale();
        }
    };

    public MapDelegatingValueObservableMap(IObservableMap<K, I> map, DelegatingValueProperty<S, V> valueProperty) {
        super(map.getRealm());
        this.masterMap = map;
        this.detailProperty = valueProperty;
        this.cache = new DelegatingCache<S, I, V>(this.getRealm(), valueProperty){

            @Override
            void handleValueChange(I masterElement, V oldValue, V newValue) {
                MapDelegatingValueObservableMap.this.fireMapChange(MapDelegatingValueObservableMap.this.keysFor(masterElement), oldValue, newValue);
            }
        };
        this.cache.addAll(this.masterMap.values());
        this.masterMap.addMapChangeListener(this.masterListener);
        this.masterMap.addStaleListener(this.staleListener);
    }

    public Set<Map.Entry<K, V>> entrySet() {
        this.getterCalled();
        if (this.entrySet == null) {
            this.entrySet = new EntrySet();
        }
        return this.entrySet;
    }

    private void getterCalled() {
        ObservableTracker.getterCalled((IObservable)this);
    }

    public V get(Object key) {
        this.getterCalled();
        Object masterValue = this.masterMap.get(key);
        return this.cache.get(masterValue);
    }

    public V put(K key, V value) {
        if (!this.masterMap.containsKey(key)) {
            return null;
        }
        Object masterValue = this.masterMap.get(key);
        return this.cache.put(masterValue, value);
    }

    public boolean isStale() {
        this.getterCalled();
        return this.masterMap.isStale();
    }

    public Object getObserved() {
        return this.masterMap;
    }

    @Override
    public DelegatingValueProperty<S, V> getProperty() {
        return this.detailProperty;
    }

    public Object getKeyType() {
        return this.masterMap.getKeyType();
    }

    public Object getValueType() {
        return this.detailProperty.getValueType();
    }

    private Set<K> keysFor(I masterValue) {
        HashSet keys = new HashSet();
        for (Map.Entry entry : this.masterMap.entrySet()) {
            if (entry.getValue() != masterValue) continue;
            keys.add(entry.getKey());
        }
        return keys;
    }

    private void fireMapChange(final Set<K> changedKeys, final V oldValue, final V newValue) {
        this.fireMapChange(new MapDiff<K, V>(){

            public Set<K> getAddedKeys() {
                return Collections.emptySet();
            }

            public Set<K> getRemovedKeys() {
                return Collections.emptySet();
            }

            public Set<K> getChangedKeys() {
                return Collections.unmodifiableSet(changedKeys);
            }

            public V getOldValue(Object key) {
                if (changedKeys.contains(key)) {
                    return oldValue;
                }
                return null;
            }

            public V getNewValue(Object key) {
                if (changedKeys.contains(key)) {
                    return newValue;
                }
                return null;
            }
        });
    }

    public synchronized void dispose() {
        if (this.masterMap != null) {
            this.masterMap.removeMapChangeListener(this.masterListener);
            this.masterMap.removeStaleListener(this.staleListener);
            this.masterMap = null;
        }
        if (this.cache != null) {
            this.cache.dispose();
            this.cache = null;
        }
        this.masterListener = null;
        this.detailProperty = null;
        super.dispose();
    }

    class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new Iterator<Map.Entry<K, V>>(){
                Iterator<Map.Entry<K, I>> it;
                {
                    this.it = MapDelegatingValueObservableMap.this.masterMap.entrySet().iterator();
                }

                @Override
                public boolean hasNext() {
                    MapDelegatingValueObservableMap.this.getterCalled();
                    return this.it.hasNext();
                }

                @Override
                public Map.Entry<K, V> next() {
                    MapDelegatingValueObservableMap.this.getterCalled();
                    Map.Entry next = this.it.next();
                    return new MapEntry(next.getKey());
                }

                @Override
                public void remove() {
                    this.it.remove();
                }
            };
        }

        @Override
        public int size() {
            return MapDelegatingValueObservableMap.this.masterMap.size();
        }
    }

    class MapEntry
    implements Map.Entry<K, V> {
        private K key;

        MapEntry(K key) {
            this.key = key;
        }

        @Override
        public K getKey() {
            MapDelegatingValueObservableMap.this.getterCalled();
            return this.key;
        }

        @Override
        public V getValue() {
            MapDelegatingValueObservableMap.this.getterCalled();
            if (!MapDelegatingValueObservableMap.this.masterMap.containsKey(this.key)) {
                return null;
            }
            Object masterValue = MapDelegatingValueObservableMap.this.masterMap.get(this.key);
            return MapDelegatingValueObservableMap.this.cache.get(masterValue);
        }

        @Override
        public V setValue(V value) {
            MapDelegatingValueObservableMap.this.checkRealm();
            if (!MapDelegatingValueObservableMap.this.masterMap.containsKey(this.key)) {
                return null;
            }
            Object masterValue = MapDelegatingValueObservableMap.this.masterMap.get(this.key);
            return MapDelegatingValueObservableMap.this.cache.put(masterValue, value);
        }

        @Override
        public boolean equals(Object o) {
            MapDelegatingValueObservableMap.this.getterCalled();
            if (o == this) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry that = (Map.Entry)o;
            return Util.equals(this.getKey(), that.getKey()) && Util.equals(this.getValue(), that.getValue());
        }

        @Override
        public int hashCode() {
            MapDelegatingValueObservableMap.this.getterCalled();
            Object value = this.getValue();
            return (this.key == null ? 0 : this.key.hashCode()) ^ (value == null ? 0 : value.hashCode());
        }
    }
}

