/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.dom.parser.upc;

import org.eclipse.cdt.core.dom.lrparser.c99.C99Language;
import org.eclipse.cdt.core.model.ICLanguageKeywords;
import org.eclipse.cdt.core.parser.util.CharArrayMap;

public enum UPCKeyword {
    MYTHREAD(19),
    THREADS(20),
    UPC_MAX_BLOCKSIZE(21),
    relaxed(46),
    shared(47),
    strict(48),
    upc_barrier(38),
    upc_localsizeof(22),
    upc_blocksizeof(23),
    upc_elemsizeof(24),
    upc_notify(39),
    upc_fence(40),
    upc_wait(41),
    upc_forall(42);

    private final int tokenKind;
    private static final CharArrayMap<Integer> tokenMap;
    private static final String[] upcKeywords;
    private static final String[] allKeywords;

    static {
        tokenMap = new CharArrayMap();
        UPCKeyword[] keywords = UPCKeyword.values();
        upcKeywords = new String[keywords.length];
        int i = 0;
        while (i < keywords.length) {
            String name;
            UPCKeyword keyword = keywords[i];
            UPCKeyword.upcKeywords[i] = name = keyword.name();
            tokenMap.put(name.toCharArray(), (Object)keyword.tokenKind);
            ++i;
        }
        ICLanguageKeywords c99Keywords = (ICLanguageKeywords)C99Language.getDefault().getAdapter(ICLanguageKeywords.class);
        String[] c99ks = c99Keywords.getKeywords();
        allKeywords = new String[upcKeywords.length + c99ks.length];
        System.arraycopy(c99ks, 0, allKeywords, 0, c99ks.length);
        System.arraycopy(upcKeywords, 0, allKeywords, c99ks.length, upcKeywords.length);
    }

    private UPCKeyword(int tokenKind) {
        this.tokenKind = tokenKind;
    }

    public int getTokenKind() {
        return this.tokenKind;
    }

    public static String[] getUPCOnlyKeywords() {
        return upcKeywords;
    }

    public static String[] getAllKeywords() {
        return allKeywords;
    }

    public static Integer getTokenKind(char[] image) {
        if (image == null) {
            return null;
        }
        return (Integer)tokenMap.get(image);
    }
}

