/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.features.activity.subprocess;

import java.util.Collection;
import java.util.List;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.FlowElementsContainer;
import org.eclipse.bpmn2.Participant;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.eclipse.bpmn2.modeler.core.di.DIUtils;
import org.eclipse.bpmn2.modeler.core.features.choreography.ChoreographyUtil;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.bpmn2.modeler.core.utils.GraphicsUtil;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.bpmn2.modeler.ui.ImageProvider;
import org.eclipse.bpmn2.modeler.ui.features.activity.subprocess.AbstractPushPullFeature;
import org.eclipse.bpmn2.modeler.ui.features.activity.subprocess.ExpandFlowNodeFeature;
import org.eclipse.bpmn2.modeler.ui.features.activity.subprocess.Messages;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.mm.algorithms.styles.Point;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.platform.IDiagramBehavior;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.osgi.util.NLS;

public class PullupFeature
extends AbstractPushPullFeature {
    public PullupFeature(IFeatureProvider fp) {
        super(fp);
    }

    public String getName() {
        return Messages.PullupFeature_Name;
    }

    public String getDescription() {
        if (this.description == null) {
            this.description = Messages.PullupFeature_Description;
        }
        return this.description;
    }

    public String getImageId() {
        return ImageProvider.IMG_16_PULLUP;
    }

    public boolean isAvailable(IContext context) {
        PictogramElement pe;
        PictogramElement[] pes;
        return context instanceof ICustomContext && (pes = ((ICustomContext)context).getPictogramElements()) != null && pes.length == 1 && !ChoreographyUtil.isChoreographyParticipantBand((PictogramElement)(pe = pes[0]));
    }

    public boolean canExecute(ICustomContext context) {
        PictogramElement[] pes = context.getPictogramElements();
        if (pes != null && pes.length == 1 && pes[0] instanceof ContainerShape) {
            this.containerShape = (ContainerShape)pes[0];
            if (ChoreographyUtil.isChoreographyParticipantBand((PictogramElement)this.containerShape)) {
                return false;
            }
            Object bo = this.getBusinessObjectForPictogramElement((PictogramElement)this.containerShape);
            this.description = NLS.bind((String)Messages.PullupFeature_Description_1, (Object)ModelUtil.getLabel((Object)bo));
            if (bo instanceof Participant) {
                Diagram diagram = Graphiti.getPeService().getDiagramForShape((Shape)this.containerShape);
                if (FeatureSupport.isParticipantReference((Diagram)diagram, (Participant)((Participant)bo))) {
                    return false;
                }
                bo = ((Participant)bo).getProcessRef();
            }
            if (bo instanceof FlowElementsContainer) {
                return FeatureSupport.hasBpmnDiagram((BaseElement)((FlowElementsContainer)bo));
            }
        }
        return false;
    }

    public void execute(ICustomContext context) {
        this.containerShape = (ContainerShape)context.getPictogramElements()[0];
        this.newBpmnDiagram = DIUtils.findBPMNDiagram((PictogramElement)this.containerShape);
        this.newDiagram = Graphiti.getPeService().getDiagramForShape((Shape)this.containerShape);
        this.bpmnShape = null;
        Object bo = this.getBusinessObjectForPictogramElement((PictogramElement)this.containerShape);
        if (bo instanceof Participant) {
            this.bpmnShape = DIUtils.findBPMNShape((BPMNDiagram)this.newBpmnDiagram, (BaseElement)((Participant)bo));
            this.businessObject = ((Participant)bo).getProcessRef();
        } else if (bo instanceof FlowElementsContainer) {
            this.bpmnShape = DIUtils.findBPMNShape((BPMNDiagram)this.newBpmnDiagram, (BaseElement)((FlowElementsContainer)bo));
            this.businessObject = (FlowElementsContainer)bo;
        }
        this.oldBpmnDiagram = DIUtils.findBPMNDiagram((BaseElement)this.businessObject);
        this.oldDiagram = DIUtils.findDiagram((IDiagramBehavior)this.getDiagramBehavior(), (BPMNDiagram)this.oldBpmnDiagram);
        this.collectDiagramElements(this.businessObject, this.oldBpmnDiagram);
        this.collectShapes((ContainerShape)this.oldDiagram);
        this.collectConnections((ContainerShape)this.oldDiagram);
        this.boundingRectangle = this.calculateBoundingRectangle(this.containerShape, this.childShapes);
        this.moveShapes((ContainerShape)this.oldDiagram, this.containerShape, this.boundingRectangle.x, this.boundingRectangle.y);
        this.moveConnections((ContainerShape)this.oldDiagram, this.containerShape);
        this.moveDiagramElements(this.oldBpmnDiagram, this.newBpmnDiagram);
        this.moveGraphitiData(this.oldDiagram, this.newDiagram);
        DIUtils.deleteDiagram((IDiagramBehavior)this.getDiagramBehavior(), (BPMNDiagram)this.oldBpmnDiagram);
        this.getFeatureProvider().getDiagramTypeProvider().resourceReloaded(this.newDiagram);
        FeatureSupport.updateConnections((IFeatureProvider)this.getFeatureProvider(), (List)this.internalConnections, (boolean)true);
        if (FeatureSupport.isExpandableElement((BaseElement)this.businessObject)) {
            this.bpmnShape.setIsExpanded(false);
            ExpandFlowNodeFeature expandFeature = new ExpandFlowNodeFeature(this.getFeatureProvider());
            expandFeature.execute(context);
        }
    }

    @Override
    protected void collectDiagramElements(FlowElementsContainer businessObject, BPMNDiagram source) {
        this.diagramElements.addAll(source.getPlane().getPlaneElement());
    }

    @Override
    protected void collectShapes(ContainerShape source) {
        this.childShapes.addAll(source.getChildren());
    }

    @Override
    protected void moveGraphitiData(Diagram source, Diagram target) {
        target.getPictogramLinks().addAll((Collection)source.getPictogramLinks());
        target.getColors().addAll((Collection)source.getColors());
        target.getFonts().addAll((Collection)source.getFonts());
        target.getStyles().addAll((Collection)source.getStyles());
    }

    @Override
    protected Rectangle calculateBoundingRectangle(ContainerShape containerShape, List<Shape> childShapes) {
        Rectangle rect = GraphicsUtil.getBoundingRectangle(childShapes);
        Point offset = this.getChildOffset(containerShape);
        rect.x -= 20 + offset.getX();
        rect.y -= 20 + offset.getY();
        rect.width += 40 + offset.getX();
        rect.height += 40 + offset.getY();
        return rect;
    }
}

