/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.internal.ui.views.provider;

import org.eclipse.birt.report.designer.internal.ui.views.DefaultNodeProvider;
import org.eclipse.birt.report.item.crosstab.core.de.MeasureViewHandle;
import org.eclipse.birt.report.item.crosstab.internal.ui.util.CrosstabUIHelper;
import org.eclipse.birt.report.item.crosstab.internal.ui.views.provider.CrosstabPropertyHandleWrapper;
import org.eclipse.birt.report.item.crosstab.ui.i18n.Messages;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.extension.ExtendedElementException;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Image;

public class MeasureSubNodeProvider
extends DefaultNodeProvider {
    public void createContextMenu(TreeViewer sourceViewer, Object object, IMenuManager menu) {
    }

    public Object[] getChildren(Object model) {
        PropertyHandle handle = ((CrosstabPropertyHandleWrapper)model).getModel();
        ExtendedItemHandle element = (ExtendedItemHandle)handle.getElementHandle();
        try {
            MeasureViewHandle measure = (MeasureViewHandle)element.getReportItem();
            String propertyName = handle.getPropertyDefn().getName();
            Object value = handle.getValue();
            if (value == null) {
                return new Object[0];
            }
            if (propertyName.equals("header")) {
                return new Object[]{measure.getHeader().getModelHandle()};
            }
            if (propertyName.equals("detail")) {
                return new Object[]{measure.getCell().getModelHandle()};
            }
            if (propertyName.equals("aggregations")) {
                int count = measure.getAggregationCount();
                Object[] aggs = new Object[count];
                int i = 0;
                while (i < count) {
                    aggs[i] = measure.getAggregationCell(i).getModelHandle();
                    ++i;
                }
                return aggs;
            }
        }
        catch (ExtendedElementException extendedElementException) {}
        return new Object[0];
    }

    public Object getParent(Object model) {
        PropertyHandle handle = ((CrosstabPropertyHandleWrapper)model).getModel();
        return handle.getElementHandle();
    }

    public boolean hasChildren(Object model) {
        return this.getChildren(model).length != 0;
    }

    public String getNodeDisplayName(Object element) {
        PropertyHandle handle = ((CrosstabPropertyHandleWrapper)element).getModel();
        String propertyName = handle.getPropertyDefn().getName();
        if (propertyName.equals("header")) {
            return Messages.getString("MeasureSubNodeProvider.Header");
        }
        if (propertyName.equals("detail")) {
            return Messages.getString("MeasureSubNodeProvider.Detail");
        }
        if (propertyName.equals("aggregations")) {
            return Messages.getString("MeasureSubNodeProvider.Aggregation");
        }
        return super.getNodeDisplayName(element);
    }

    public Image getNodeIcon(Object element) {
        PropertyHandle handle = ((CrosstabPropertyHandleWrapper)element).getModel();
        String propertyName = handle.getPropertyDefn().getName();
        if (propertyName.equals("header")) {
            return CrosstabUIHelper.getImage("icons/pal/header.gif");
        }
        if (propertyName.equals("detail")) {
            return CrosstabUIHelper.getImage("icons/pal/details.gif");
        }
        if (propertyName.equals("aggregations")) {
            return CrosstabUIHelper.getImage("icons/pal/aggregation.gif");
        }
        return super.getNodeIcon(element);
    }
}

