/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter;

import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.content.IAutoTextContent;
import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IContainerContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IContentVisitor;
import org.eclipse.birt.report.engine.content.IDataContent;
import org.eclipse.birt.report.engine.content.IForeignContent;
import org.eclipse.birt.report.engine.content.IGroupContent;
import org.eclipse.birt.report.engine.content.IImageContent;
import org.eclipse.birt.report.engine.content.ILabelContent;
import org.eclipse.birt.report.engine.content.IListBandContent;
import org.eclipse.birt.report.engine.content.IListContent;
import org.eclipse.birt.report.engine.content.IListGroupContent;
import org.eclipse.birt.report.engine.content.IPageContent;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.content.ITableBandContent;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.content.ITableGroupContent;
import org.eclipse.birt.report.engine.content.ITextContent;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;

public class ContentEmitterUtil {
    static IContentVisitor starter = new StartContentVisitor();
    static IContentVisitor ender = new EndContentVisitor();

    public static void startContent(IContent content, IContentEmitter emitter) throws BirtException {
        switch (content.getContentType()) {
            case 7: {
                emitter.startPage((IPageContent)content);
                break;
            }
            case 10: {
                emitter.startTable((ITableContent)content);
                break;
            }
            case 9: {
                emitter.startTableBand((ITableBandContent)content);
                break;
            }
            case 8: {
                emitter.startRow((IRowContent)content);
                break;
            }
            case 1: {
                emitter.startCell((ICellContent)content);
                break;
            }
            case 11: {
                emitter.startText((ITextContent)content);
                break;
            }
            case 6: {
                emitter.startLabel((ILabelContent)content);
                break;
            }
            case 12: {
                emitter.startAutoText((IAutoTextContent)content);
                break;
            }
            case 3: {
                emitter.startData((IDataContent)content);
                break;
            }
            case 5: {
                emitter.startImage((IImageContent)content);
                break;
            }
            case 4: {
                emitter.startForeign((IForeignContent)content);
                break;
            }
            case 13: {
                emitter.startList((IListContent)content);
                break;
            }
            case 14: {
                emitter.startListBand((IListBandContent)content);
                break;
            }
            case 16: {
                emitter.startListGroup((IListGroupContent)content);
                break;
            }
            case 17: {
                emitter.startTableGroup((ITableGroupContent)content);
                break;
            }
            default: {
                starter.visit(content, emitter);
            }
        }
    }

    public static void endContent(IContent content, IContentEmitter emitter) throws BirtException {
        switch (content.getContentType()) {
            case 7: {
                emitter.endPage((IPageContent)content);
                break;
            }
            case 10: {
                emitter.endTable((ITableContent)content);
                break;
            }
            case 9: {
                emitter.endTableBand((ITableBandContent)content);
                break;
            }
            case 8: {
                emitter.endRow((IRowContent)content);
                break;
            }
            case 1: {
                emitter.endCell((ICellContent)content);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 11: 
            case 12: {
                break;
            }
            case 13: {
                emitter.endList((IListContent)content);
                break;
            }
            case 14: {
                emitter.endListBand((IListBandContent)content);
                break;
            }
            case 16: {
                emitter.endListGroup((IListGroupContent)content);
                break;
            }
            case 17: {
                emitter.endTableGroup((ITableGroupContent)content);
                break;
            }
            default: {
                ender.visit(content, emitter);
            }
        }
    }

    private static class EndContentVisitor
    implements IContentVisitor {
        private EndContentVisitor() {
        }

        @Override
        public Object visit(IContent content, Object value) throws BirtException {
            return content.accept(this, value);
        }

        @Override
        public Object visitContent(IContent content, Object value) throws BirtException {
            IContentEmitter emitter = (IContentEmitter)value;
            emitter.endContent(content);
            return value;
        }

        @Override
        public Object visitPage(IPageContent page, Object value) throws BirtException {
            IContentEmitter emitter = (IContentEmitter)value;
            emitter.endPage(page);
            return value;
        }

        @Override
        public Object visitContainer(IContainerContent container, Object value) throws BirtException {
            IContentEmitter emitter = (IContentEmitter)value;
            emitter.endContainer(container);
            return value;
        }

        @Override
        public Object visitTable(ITableContent table, Object value) throws BirtException {
            IContentEmitter emitter = (IContentEmitter)value;
            emitter.endTable(table);
            return value;
        }

        @Override
        public Object visitTableBand(ITableBandContent tableBand, Object value) throws BirtException {
            IContentEmitter emitter = (IContentEmitter)value;
            emitter.endTableBand(tableBand);
            return value;
        }

        @Override
        public Object visitRow(IRowContent row, Object value) throws BirtException {
            IContentEmitter emitter = (IContentEmitter)value;
            emitter.endRow(row);
            return value;
        }

        @Override
        public Object visitCell(ICellContent cell, Object value) throws BirtException {
            IContentEmitter emitter = (IContentEmitter)value;
            emitter.endCell(cell);
            return value;
        }

        @Override
        public Object visitText(ITextContent text, Object value) {
            return value;
        }

        @Override
        public Object visitLabel(ILabelContent label, Object value) {
            return value;
        }

        @Override
        public Object visitAutoText(IAutoTextContent autoText, Object value) {
            return value;
        }

        @Override
        public Object visitData(IDataContent data, Object value) {
            return value;
        }

        @Override
        public Object visitImage(IImageContent image, Object value) {
            return value;
        }

        @Override
        public Object visitForeign(IForeignContent content, Object value) {
            return value;
        }

        @Override
        public Object visitList(IListContent list, Object value) throws BirtException {
            IContentEmitter emitter = (IContentEmitter)value;
            emitter.endList(list);
            return value;
        }

        @Override
        public Object visitListBand(IListBandContent listBand, Object value) throws BirtException {
            IContentEmitter emitter = (IContentEmitter)value;
            emitter.endListBand(listBand);
            return value;
        }

        @Override
        public Object visitGroup(IGroupContent group, Object value) throws BirtException {
            IContentEmitter emitter = (IContentEmitter)value;
            emitter.endGroup(group);
            return value;
        }

        @Override
        public Object visitListGroup(IListGroupContent group, Object value) throws BirtException {
            IContentEmitter emitter = (IContentEmitter)value;
            emitter.endListGroup(group);
            return value;
        }

        @Override
        public Object visitTableGroup(ITableGroupContent group, Object value) throws BirtException {
            IContentEmitter emitter = (IContentEmitter)value;
            emitter.endTableGroup(group);
            return value;
        }
    }

    private static class StartContentVisitor
    implements IContentVisitor {
        private StartContentVisitor() {
        }

        @Override
        public Object visit(IContent content, Object value) throws BirtException {
            return content.accept(this, value);
        }

        @Override
        public Object visitContent(IContent content, Object value) throws BirtException {
            IContentEmitter emitter = (IContentEmitter)value;
            emitter.startContent(content);
            return value;
        }

        @Override
        public Object visitPage(IPageContent page, Object value) throws BirtException {
            IContentEmitter emitter = (IContentEmitter)value;
            emitter.startPage(page);
            return value;
        }

        @Override
        public Object visitContainer(IContainerContent container, Object value) throws BirtException {
            IContentEmitter emitter = (IContentEmitter)value;
            emitter.startContainer(container);
            return value;
        }

        @Override
        public Object visitTable(ITableContent table, Object value) throws BirtException {
            IContentEmitter emitter = (IContentEmitter)value;
            emitter.startTable(table);
            return value;
        }

        @Override
        public Object visitTableBand(ITableBandContent tableBand, Object value) throws BirtException {
            IContentEmitter emitter = (IContentEmitter)value;
            emitter.startTableBand(tableBand);
            return value;
        }

        @Override
        public Object visitRow(IRowContent row, Object value) throws BirtException {
            IContentEmitter emitter = (IContentEmitter)value;
            emitter.startRow(row);
            return value;
        }

        @Override
        public Object visitCell(ICellContent cell, Object value) throws BirtException {
            IContentEmitter emitter = (IContentEmitter)value;
            emitter.startCell(cell);
            return value;
        }

        @Override
        public Object visitText(ITextContent text, Object value) throws BirtException {
            IContentEmitter emitter = (IContentEmitter)value;
            emitter.startText(text);
            return value;
        }

        @Override
        public Object visitLabel(ILabelContent label, Object value) throws BirtException {
            IContentEmitter emitter = (IContentEmitter)value;
            emitter.startLabel(label);
            return value;
        }

        @Override
        public Object visitAutoText(IAutoTextContent autoText, Object value) throws BirtException {
            IContentEmitter emitter = (IContentEmitter)value;
            emitter.startAutoText(autoText);
            return value;
        }

        @Override
        public Object visitData(IDataContent data, Object value) throws BirtException {
            IContentEmitter emitter = (IContentEmitter)value;
            emitter.startData(data);
            return value;
        }

        @Override
        public Object visitImage(IImageContent image, Object value) throws BirtException {
            IContentEmitter emitter = (IContentEmitter)value;
            emitter.startImage(image);
            return value;
        }

        @Override
        public Object visitForeign(IForeignContent content, Object value) throws BirtException {
            IContentEmitter emitter = (IContentEmitter)value;
            emitter.startForeign(content);
            return value;
        }

        @Override
        public Object visitList(IListContent list, Object value) throws BirtException {
            IContentEmitter emitter = (IContentEmitter)value;
            emitter.startList(list);
            return value;
        }

        @Override
        public Object visitListBand(IListBandContent listBand, Object value) throws BirtException {
            IContentEmitter emitter = (IContentEmitter)value;
            emitter.startListBand(listBand);
            return value;
        }

        @Override
        public Object visitGroup(IGroupContent group, Object value) throws BirtException {
            IContentEmitter emitter = (IContentEmitter)value;
            emitter.startGroup(group);
            return value;
        }

        @Override
        public Object visitListGroup(IListGroupContent group, Object value) throws BirtException {
            IContentEmitter emitter = (IContentEmitter)value;
            emitter.startListGroup(group);
            return value;
        }

        @Override
        public Object visitTableGroup(ITableGroupContent group, Object value) throws BirtException {
            IContentEmitter emitter = (IContentEmitter)value;
            emitter.startTableGroup(group);
            return value;
        }
    }
}

