/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.editor.outline;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.ant.internal.ui.AntUIPlugin;
import org.eclipse.ant.internal.ui.model.IAntModel;
import org.eclipse.ant.internal.ui.model.IProblem;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.ui.texteditor.MarkerUtilities;

public class AntEditorMarkerUpdater {
    private IAntModel fModel = null;
    private List<IProblem> fCollectedProblems = new ArrayList<IProblem>();
    public static final String BUILDFILE_PROBLEM_MARKER = "org.eclipse.ant.ui.buildFileProblem";
    private IFile fFile = null;

    public synchronized void acceptProblem(IProblem problem) {
        if (this.fCollectedProblems.contains(problem)) {
            return;
        }
        this.fCollectedProblems.add(problem);
    }

    public synchronized void beginReporting() {
        this.fCollectedProblems.clear();
    }

    private void removeProblems() {
        IFile file = this.getFile();
        if (file == null || !file.exists()) {
            return;
        }
        try {
            file.deleteMarkers(BUILDFILE_PROBLEM_MARKER, false, 2);
        }
        catch (CoreException e) {
            AntUIPlugin.log(e);
        }
    }

    private void createMarker(IProblem problem) {
        IFile file = this.getFile();
        Map<String, Object> attributes = this.getMarkerAttributes(problem);
        try {
            MarkerUtilities.createMarker((IResource)file, attributes, (String)BUILDFILE_PROBLEM_MARKER);
        }
        catch (CoreException e) {
            AntUIPlugin.log(e);
        }
    }

    public void setModel(IAntModel model) {
        this.fModel = model;
    }

    public synchronized void updateMarkers() {
        IFile file = this.getFile();
        if (file != null) {
            ArrayList<IProblem> problems = new ArrayList<IProblem>(this.fCollectedProblems.size());
            Iterator<IProblem> e = this.fCollectedProblems.iterator();
            while (e.hasNext()) {
                problems.add(e.next());
            }
            this.fCollectedProblems.clear();
            AntEditorMarkerUpdaterJob job = new AntEditorMarkerUpdaterJob(problems);
            job.setRule(ResourcesPlugin.getWorkspace().getRuleFactory().markerRule((IResource)file));
            job.schedule();
        }
    }

    private void updateMarkers0(List<IProblem> problems) {
        this.removeProblems();
        if (!this.shouldAddMarkers()) {
            return;
        }
        if (problems.size() > 0) {
            for (IProblem problem : problems) {
                this.createMarker(problem);
            }
        }
    }

    private IFile getFile() {
        if (this.fFile == null) {
            this.fFile = this.fModel.getFile();
        }
        return this.fFile;
    }

    private Map<String, Object> getMarkerAttributes(IProblem problem) {
        HashMap<String, Object> attributes = new HashMap<String, Object>(11);
        int severity = 2;
        if (problem.isWarning()) {
            severity = 1;
        }
        MarkerUtilities.setMessage(attributes, (String)problem.getUnmodifiedMessage());
        MarkerUtilities.setLineNumber(attributes, (int)problem.getLineNumber());
        MarkerUtilities.setCharStart(attributes, (int)problem.getOffset());
        MarkerUtilities.setCharEnd(attributes, (int)(problem.getOffset() + problem.getLength()));
        attributes.put("severity", new Integer(severity));
        return attributes;
    }

    private boolean shouldAddMarkers() {
        IContentDescription description;
        IFile file = this.getFile();
        if (file == null || !file.exists()) {
            return false;
        }
        try {
            description = file.getContentDescription();
        }
        catch (CoreException coreException) {
            return false;
        }
        if (description != null) {
            IContentType type = description.getContentType();
            return type != null && "org.eclipse.ant.core.antBuildFile".equals(type.getId());
        }
        return false;
    }

    class AntEditorMarkerUpdaterJob
    extends WorkspaceJob {
        private final List<IProblem> fProblems;

        public AntEditorMarkerUpdaterJob(List<IProblem> problems) {
            super("Ant editor marker updater job");
            this.fProblems = problems;
            this.setSystem(true);
        }

        public IStatus runInWorkspace(IProgressMonitor monitor) {
            AntEditorMarkerUpdater.this.updateMarkers0(this.fProblems);
            return new Status(0, AntUIPlugin.getUniqueIdentifier(), 0, "", null);
        }
    }
}

