/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amalgam.explorer.activity.ui.api.dialog;

import org.eclipse.amalgam.explorer.activity.ui.api.dialog.Messages;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class SelectionDialog
extends PopupDialog {
    private Point _anchor;
    private Composite _composite;
    private FormToolkit _toolkit;
    protected String _title;
    private Object _content;
    private Object selected;
    private ViewerFilter _filter;
    private ILabelProvider _labelProvider;
    private IContentProvider _contentProvider;
    private static Window.IExceptionHandler exceptionHandler = new DefaultExceptionHandler();

    public SelectionDialog(Shell parent, Object content, ILabelProvider labelProvider, IContentProvider contentProvider) {
        this(parent, content, labelProvider, contentProvider, null, null);
    }

    public SelectionDialog(Shell parent, Object content, ILabelProvider labelProvider, IContentProvider contentProvider, ViewerFilter filter, String title) {
        super(parent, 0, true, false, false, false, false, null, null);
        this._anchor = parent.getDisplay().getCursorLocation();
        this._toolkit = new FormToolkit(parent.getDisplay());
        this._content = content;
        this._filter = filter;
        this._labelProvider = labelProvider;
        this._contentProvider = contentProvider;
        this._title = title;
    }

    public boolean close() {
        if (this._toolkit != null) {
            this._toolkit.dispose();
            this._toolkit = null;
        }
        return super.close();
    }

    protected Control createContents(Composite parent) {
        this.getShell().setBackground(this.getShell().getDisplay().getSystemColor(16));
        this.initializeBounds();
        return this.createDialogArea(parent);
    }

    protected Control createDialogArea(Composite parent) {
        this._composite = (Composite)super.createDialogArea(parent);
        ScrolledForm form = this._toolkit.createScrolledForm(this._composite);
        this._toolkit.decorateFormHeading(form.getForm());
        form.setMessage(this.getTitle(), 0);
        form.getToolBarManager().add((IAction)new CloseAction());
        form.getToolBarManager().update(true);
        GridLayout layout = new GridLayout();
        layout.marginLeft = 10;
        layout.marginRight = 10;
        layout.marginTop = 10;
        layout.verticalSpacing = 10;
        form.getBody().setLayout((Layout)layout);
        TreeSelectionPatternFilter patternFilter = new TreeSelectionPatternFilter(this._filter);
        FilteredTree filteredTree = new FilteredTree(form.getBody(), 2052, (PatternFilter)patternFilter, true);
        this._toolkit.adapt((Composite)filteredTree);
        final TreeViewer treeViewer = filteredTree.getViewer();
        treeViewer.setContentProvider(this._contentProvider);
        treeViewer.setLabelProvider((IBaseLabelProvider)this._labelProvider);
        treeViewer.setInput(this._content);
        if (this._filter != null) {
            treeViewer.addFilter(this._filter);
        }
        form.setMinSize(this.getMinWidth(), this.getMinHeight());
        Composite container = new Composite(form.getBody(), 0);
        container.setLayoutData((Object)new GridData(128));
        container.setLayout((Layout)new GridLayout(2, true));
        container.setBackground(this._toolkit.getColors().getBackground());
        GridDataFactory factory = GridDataFactory.fillDefaults().grab(true, false);
        Button finish = this._toolkit.createButton(container, Messages.SelectionDialog_0, form.getStyle());
        finish.setLayoutData((Object)factory.create());
        finish.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                ISelection selection = treeViewer.getSelection();
                if (selection instanceof IStructuredSelection) {
                    SelectionDialog.this.selected = ((IStructuredSelection)selection).getFirstElement();
                    SelectionDialog.this.setReturnCode(0);
                    SelectionDialog.this.close();
                }
            }
        });
        Button cancel = this._toolkit.createButton(container, Messages.SelectionDialog_1, form.getStyle());
        cancel.setLayoutData((Object)factory.create());
        cancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                SelectionDialog.this.setReturnCode(1);
                SelectionDialog.this.close();
            }
        });
        return this._composite;
    }

    private int getMinWidth() {
        return 400;
    }

    protected int getMinHeight() {
        return 400;
    }

    protected String getTitle() {
        return this._title;
    }

    protected Control getFocusControl() {
        return this._composite;
    }

    protected Point getInitialLocation(Point size) {
        if (this._anchor == null) {
            return super.getInitialLocation(size);
        }
        Point point = this._anchor;
        Rectangle monitor = this.getShell().getMonitor().getClientArea();
        if (monitor.width < point.x + size.x) {
            point.x = Math.max(0, point.x - size.x);
        }
        if (monitor.height < point.y + size.y) {
            point.y = Math.max(0, point.y - size.y);
        }
        return point;
    }

    public Object getSelection() {
        return this.selected;
    }

    public int open() {
        if (this.getShell() == null || this.getShell().isDisposed()) {
            this.create();
        }
        this.constrainShellSize();
        this.getShell().open();
        this.runEventLoop(this.getShell());
        return this.getReturnCode();
    }

    private void runEventLoop(Shell loopShell) {
        Display display = this.getShell() == null ? Display.getCurrent() : loopShell.getDisplay();
        while (loopShell != null && !loopShell.isDisposed()) {
            try {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
            catch (Throwable e) {
                exceptionHandler.handleException(e);
            }
        }
        if (!display.isDisposed()) {
            display.update();
        }
    }

    private class CloseAction
    extends Action {
        private CloseAction() {
        }

        public ImageDescriptor getImageDescriptor() {
            return PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE");
        }

        public String getToolTipText() {
            return Messages.DescriptionDialog_CloseAction_Title;
        }

        public void run() {
            SelectionDialog.this.setReturnCode(1);
            SelectionDialog.this.close();
        }
    }

    private static class DefaultExceptionHandler
    implements Window.IExceptionHandler {
        private DefaultExceptionHandler() {
        }

        public void handleException(Throwable t) {
            if (t instanceof ThreadDeath) {
                throw (ThreadDeath)t;
            }
            t.printStackTrace();
        }
    }

    private class TreeSelectionPatternFilter
    extends PatternFilter {
        private ViewerFilter filter;

        public TreeSelectionPatternFilter(ViewerFilter filter) {
            this.filter = filter;
        }

        protected boolean isParentMatch(Viewer viewer, Object element) {
            Object[] children = ((ITreeContentProvider)((AbstractTreeViewer)viewer).getContentProvider()).getChildren(element);
            if (this.filter != null && children != null) {
                Object[] objectArray = children;
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    Object child = objectArray[n2];
                    if (this.filter.select(viewer, null, child)) {
                        return super.isParentMatch(viewer, element);
                    }
                    ++n2;
                }
                return false;
            }
            return super.isParentMatch(viewer, element);
        }

        protected boolean isLeafMatch(Viewer viewer, Object element) {
            String labelText;
            if (element instanceof EObject && (labelText = ((EObject)element).toString()) != null) {
                return this.wordMatches(labelText);
            }
            return false;
        }
    }
}

