/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.lowvision.color;

import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import org.eclipse.actf.visualization.internal.engines.lowvision.color.ColorException;
import org.eclipse.actf.visualization.internal.engines.lowvision.color.ColorIRGB;
import org.eclipse.actf.visualization.internal.engines.lowvision.color.ColorLAB;
import org.eclipse.actf.visualization.internal.engines.lowvision.color.ColorSRGB;
import org.eclipse.actf.visualization.internal.engines.lowvision.color.ColorYXY;

public class ColorXYZ {
    ICC_ColorSpace cs = (ICC_ColorSpace)ColorSpace.getInstance(1000);
    private float[] xyz = new float[3];

    public ColorXYZ() {
    }

    public ColorXYZ(float[] fArray) throws ColorException {
        this(fArray, false);
    }

    public ColorXYZ(float[] fArray, boolean bl) throws ColorException {
        this(fArray[0], fArray[1], fArray[2], bl);
    }

    public ColorXYZ(float f, float f2, float f3) throws ColorException {
        this(f, f2, f3, false);
    }

    public ColorXYZ(float f, float f2, float f3, boolean bl) throws ColorException {
        this.setX(f, bl);
        this.setY(f2, bl);
        this.setZ(f3, bl);
    }

    public float getX() {
        return this.xyz[0];
    }

    public float getY() {
        return this.xyz[1];
    }

    public float getZ() {
        return this.xyz[2];
    }

    public void setX(float f) throws ColorException {
        this.setX(f, false);
    }

    public void setX(float f, boolean bl) throws ColorException {
        if (f < 0.0f) {
            if (bl) {
                throw new ColorException("Smaller than minimum.");
            }
            this.xyz[0] = 0.0f;
        } else if (1.0f < f) {
            if (bl) {
                throw new ColorException("Larger than maximum.");
            }
            this.xyz[0] = 1.0f;
        } else {
            this.xyz[0] = f;
        }
    }

    public void setY(float f) throws ColorException {
        this.setY(f, false);
    }

    public void setY(float f, boolean bl) throws ColorException {
        if (f < 0.0f) {
            if (bl) {
                throw new ColorException("Smaller than minimum.");
            }
            this.xyz[1] = 0.0f;
        } else if (1.0f < f) {
            if (bl) {
                throw new ColorException("Larger than maximum.");
            }
            this.xyz[1] = 1.0f;
        } else {
            this.xyz[1] = f;
        }
    }

    public void setZ(float f) throws ColorException {
        this.setZ(f, false);
    }

    public void setZ(float f, boolean bl) throws ColorException {
        if (f < 0.0f) {
            if (bl) {
                throw new ColorException("Smaller than minimum.");
            }
            this.xyz[2] = 0.0f;
        } else if (1.0f < f) {
            if (bl) {
                throw new ColorException("Larger than maximum.");
            }
            this.xyz[2] = 1.0f;
        } else {
            this.xyz[2] = f;
        }
    }

    public ColorSRGB toSRGB() throws ColorException {
        return this.toSRGB(false);
    }

    public ColorSRGB toSRGB(boolean bl) throws ColorException {
        float[] fArray = this.cs.fromCIEXYZ(this.xyz);
        ColorSRGB colorSRGB = new ColorSRGB(fArray[0], fArray[1], fArray[2], bl);
        return colorSRGB;
    }

    public ColorYXY toYXY() throws ColorException {
        return this.toYXY(false);
    }

    public ColorYXY toYXY(boolean bl) throws ColorException {
        float f = this.xyz[0] + this.xyz[1] + this.xyz[2];
        ColorYXY colorYXY = new ColorYXY();
        if (f == 0.0f) {
            colorYXY.setYY(0.0f);
            colorYXY.setX(0.0f);
            colorYXY.setY(0.0f);
        } else {
            colorYXY.setYY(this.xyz[1], bl);
            colorYXY.setX(this.xyz[0] / f, bl);
            colorYXY.setY(this.xyz[1] / f, bl);
        }
        return colorYXY;
    }

    public ColorIRGB toIRGB() throws ColorException {
        return this.toIRGB(false);
    }

    public ColorIRGB toIRGB(boolean bl) throws ColorException {
        return this.toSRGB(bl).toIRGB(bl);
    }

    public ColorLAB toLAB() {
        return new ColorLAB(this);
    }
}

