/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.lowvision.character;

import org.eclipse.actf.visualization.engines.lowvision.image.IPageImage;
import org.eclipse.actf.visualization.engines.lowvision.image.ImageException;
import org.eclipse.actf.visualization.internal.engines.lowvision.character.CandidateCharacter;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.ConnectedComponent;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.Container;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.IInt2D;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.Int2D;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.PageComponent;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.Topology;

public class CharacterSM
extends PageComponent {
    private int foregroundColor = -1;
    private Topology topology = null;
    private int[][] image = null;

    public CharacterSM(CandidateCharacter candidateCharacter, int[][] nArray) throws ImageException {
        super((short)6, candidateCharacter.getPageImage());
        this.cc = candidateCharacter.cc;
        this.container = candidateCharacter.container;
        this.foregroundColor = candidateCharacter.getForegroundColor();
        this.topology = new Topology(this.cc.thinning());
        if (nArray != null) {
            int n = this.cc.getShape().getWidth();
            int n2 = this.cc.getShape().getHeight();
            int n3 = this.cc.getLeft();
            int n4 = this.cc.getTop();
            this.image = new int[n2][n];
            int n5 = 0;
            while (n5 < n2) {
                int n6 = 0;
                while (n6 < n) {
                    this.image[n5][n6] = nArray[n5 + n4][n6 + n3];
                    ++n6;
                }
                ++n5;
            }
        }
    }

    public CharacterSM(CandidateCharacter candidateCharacter, IInt2D iInt2D) throws ImageException {
        this(candidateCharacter, iInt2D.getData());
    }

    public CharacterSM(IPageImage iPageImage, ConnectedComponent connectedComponent, Container container, int n, int[][] nArray) throws ImageException {
        super((short)6, iPageImage);
        this.cc = connectedComponent;
        this.container = container;
        this.foregroundColor = n;
        this.topology = new Topology(this.cc.thinning());
        if (nArray != null) {
            int n2 = this.cc.getShape().getWidth();
            int n3 = this.cc.getShape().getHeight();
            int n4 = this.cc.getLeft();
            int n5 = this.cc.getTop();
            this.image = new int[n3][n2];
            int n6 = 0;
            while (n6 < n3) {
                int n7 = 0;
                while (n7 < n2) {
                    this.image[n6][n7] = nArray[n6 + n5][n7 + n4];
                    ++n7;
                }
                ++n6;
            }
        }
    }

    public CharacterSM(IPageImage iPageImage, ConnectedComponent connectedComponent, Container container, int n, IInt2D iInt2D) throws ImageException {
        this(iPageImage, connectedComponent, container, n, iInt2D.getData());
    }

    public int getForegroundColor() {
        return this.foregroundColor;
    }

    public int[][] getImage() {
        return this.image;
    }

    public IInt2D getInt2D() throws ImageException {
        return new Int2D(this.cc.getShape().getWidth(), this.cc.getShape().getHeight(), this.image);
    }

    public IInt2D makeMarginedImage(int n) throws ImageException {
        int n2;
        if (n == 0) {
            return this.getInt2D();
        }
        if (n < 0) {
            throw new ImageException("The margin must be non-negative.");
        }
        int n3 = this.cc.getShape().getWidth();
        int n4 = this.cc.getShape().getHeight();
        int n5 = n3 + 2 * n;
        int n6 = n4 + 2 * n;
        Int2D int2D = new Int2D(n5, n6);
        int n7 = 0;
        while (n7 < n4) {
            n2 = 0;
            while (n2 < n3) {
                int2D.getData()[n7 + n][n2 + n] = this.image[n7][n2];
                ++n2;
            }
            n2 = 0;
            while (n2 < n) {
                int2D.getData()[n7 + n][n2] = this.image[n7][0];
                int2D.getData()[n7 + n][n5 - 1 - n2] = this.image[n7][n3 - 1];
                ++n2;
            }
            ++n7;
        }
        n7 = 0;
        while (n7 < n3) {
            n2 = 0;
            while (n2 < n) {
                int2D.getData()[n2][n7 + n] = this.image[0][n7];
                int2D.getData()[n6 - 1 - n2][n7 + n] = this.image[n4 - 1][n7];
                ++n2;
            }
            ++n7;
        }
        n7 = 0;
        while (n7 < n) {
            n2 = 0;
            while (n2 < n) {
                int2D.getData()[n7][n2] = this.image[0][0];
                int2D.getData()[n7][n5 - 1 - n2] = this.image[0][n3 - 1];
                int2D.getData()[n6 - 1 - n7][n2] = this.image[n4 - 1][0];
                int2D.getData()[n6 - 1 - n7][n5 - 1 - n2] = this.image[n4 - 1][n3 - 1];
                ++n2;
            }
            ++n7;
        }
        return int2D;
    }

    public Topology getTopology() {
        return this.topology;
    }
}

