/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.internal.httpproxy.core;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.actf.util.httpproxy.util.Logger;
import org.eclipse.actf.util.internal.httpproxy.core.ChunkDecoder;

public class ChunkEncoder
extends FilterOutputStream {
    static final Logger LOGGER = Logger.getLogger(ChunkEncoder.class);
    public static final int DEFAULT_CHUNK_SIZE = 1024;
    private int fMaxChunkSize;
    private byte[] fChunkBuffer;
    private int fChunkSize;

    public ChunkEncoder(OutputStream outputStream) {
        this(outputStream, 1024);
    }

    public ChunkEncoder(OutputStream outputStream, int n) {
        super(outputStream);
        this.fMaxChunkSize = n;
        this.fChunkSize = 0;
        this.fChunkBuffer = new byte[n];
    }

    public void setMaxChunkSize(int n) throws IOException {
        if (this.fMaxChunkSize == n) {
            return;
        }
        if (this.fChunkSize > 0) {
            this.flushChunk();
        }
        this.fMaxChunkSize = n;
        this.fChunkBuffer = new byte[n];
    }

    public void write(int n) throws IOException {
        this.fChunkBuffer[this.fChunkSize++] = (byte)n;
        if (this.fChunkSize == this.fMaxChunkSize) {
            this.flushChunk();
        }
    }

    public void flush() throws IOException {
        this.flushChunk();
        this.out.flush();
    }

    public void close() throws IOException {
        this.flushChunk();
        this.out.write(48);
        this.out.write(13);
        this.out.write(10);
        this.out.write(13);
        this.out.write(10);
        this.out.close();
    }

    private void flushChunk() throws IOException {
        if (this.fChunkSize > 0) {
            byte[] byArray = Integer.toHexString(this.fChunkSize).getBytes();
            this.out.write(byArray);
            this.out.write(13);
            this.out.write(10);
            this.out.write(this.fChunkBuffer, 0, this.fChunkSize);
            this.out.write(13);
            this.out.write(10);
            this.fChunkSize = 0;
        }
    }

    public static void main(String[] stringArray) throws Exception {
        int n;
        CharSequence charSequence;
        int n2;
        int n3;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ChunkEncoder chunkEncoder = new ChunkEncoder(byteArrayOutputStream, 10);
        int n4 = 0;
        while (n4 < 39) {
            n3 = n4 & 0xFF;
            chunkEncoder.write(n3);
            ++n4;
        }
        chunkEncoder.close();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        n3 = 0;
        while (n3 < byArray.length) {
            n2 = byArray[n3];
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append('[');
            stringBuffer.append(Integer.toString(n3));
            stringBuffer.append("] ");
            stringBuffer.append(Integer.toString(n2));
            if (Character.isLetterOrDigit((char)n2)) {
                stringBuffer.append(" '").append((char)n2).append('\'');
            }
            charSequence = stringBuffer.toString();
            System.out.println((String)charSequence);
            ++n3;
        }
        System.out.println();
        ChunkDecoder chunkDecoder = new ChunkDecoder(new ByteArrayInputStream(byArray));
        n2 = 0;
        while ((n = chunkDecoder.read()) >= 0) {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append('[');
            ((StringBuffer)charSequence).append(Integer.toString(n2));
            ((StringBuffer)charSequence).append("] ");
            ((StringBuffer)charSequence).append(Integer.toString(n));
            String string = ((StringBuffer)charSequence).toString();
            System.out.println(string);
            ++n2;
        }
        chunkDecoder.close();
    }
}

