/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.editors.template.actions.refactor;

import org.eclipse.acceleo.ide.ui.AcceleoUIActivator;
import org.eclipse.acceleo.internal.ide.ui.AcceleoUIMessages;
import org.eclipse.acceleo.internal.ide.ui.editors.template.AcceleoEditor;
import org.eclipse.acceleo.internal.ide.ui.editors.template.actions.refactor.AcceleoRefactoringUtils;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractRefactoringAction
implements IWorkbenchWindowActionDelegate {
    protected String name;
    protected IWorkbenchWindow fWindow;
    protected AcceleoEditor editor;
    protected boolean tolerateError;

    public AbstractRefactoringAction() {
        this.tolerateError = false;
    }

    public AbstractRefactoringAction(boolean withError) {
        this.tolerateError = withError;
    }

    public void init(IWorkbenchWindow window) {
        this.fWindow = window;
    }

    public void run(IAction action) {
        if (PlatformUI.getWorkbench().getActiveWorkbenchWindow() == null || PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage() == null || !(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor() instanceof AcceleoEditor)) {
            return;
        }
        this.editor = (AcceleoEditor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        MessageBox box = null;
        if (this.editor.getFile() == null) {
            box = new MessageBox(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
            box.setMessage(AcceleoUIMessages.getString("AcceleoEditorRenameRefactoring.NotInWorkspace"));
        } else if (!this.tolerateError && AcceleoRefactoringUtils.containsAcceleoError(this.editor.getFile())) {
            box = new MessageBox(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
            box.setMessage(AcceleoUIMessages.getString("AcceleoEditorRenameRefactoring.ErrorInFile", this.editor.getFile().getName()));
        }
        if (box != null) {
            box.open();
            return;
        }
        this.launchRefactoring();
    }

    protected abstract void launchRefactoring();

    public void runWizard(RefactoringWizard wizard, Shell parent, String dialogTitle) {
        try {
            RefactoringWizardOpenOperation operation = new RefactoringWizardOpenOperation(wizard);
            operation.run(parent, dialogTitle);
        }
        catch (InterruptedException exception) {
            AcceleoUIActivator.log(exception, true);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void dispose() {
    }
}

