/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.common.utils;

import java.io.IOException;
import java.util.Collection;
import org.eclipse.acceleo.common.AcceleoCommonMessages;
import org.eclipse.acceleo.common.internal.utils.AcceleoLogger;
import org.eclipse.acceleo.common.utils.ModelUtils;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ocl.ecore.internal.OCLStandardLibraryImpl;

public final class AcceleoNonStandardLibrary {
    public static final String OPERATION_COLLECTION_LASTINDEXOF = "lastIndexOf";
    public static final String OPERATION_COLLECTION_REVERSE = "reverse";
    public static final String OPERATION_COLLECTION_FILTER = "filter";
    public static final String OPERATION_COLLECTION_SEP = "sep";
    public static final String OPERATION_COLLECTION_ADD_ALL = "addAll";
    public static final String OPERATION_COLLECTION_REMOVE_ALL = "removeAll";
    public static final String OPERATION_COLLECTION_DROP = "drop";
    public static final String OPERATION_COLLECTION_DROP_RIGHT = "dropRight";
    public static final String OPERATION_COLLECTION_STARTS_WITH = "startsWith";
    public static final String OPERATION_COLLECTION_ENDS_WITH = "endsWith";
    public static final String OPERATION_COLLECTION_INDEX_OF_SLICE = "indexOfSlice";
    public static final String OPERATION_COLLECTION_LAST_INDEX_OF_SLICE = "lastIndexOfSlice";
    public static final String OPERATION_EOBJECT_ANCESTORS = "ancestors";
    public static final String OPERATION_EOBJECT_SIBLINGS = "siblings";
    public static final String OPERATION_EOBJECT_EALLCONTENTS = "eAllContents";
    public static final String OPERATION_EOBJECT_ECONTAINER = "eContainer";
    public static final String OPERATION_EOBJECT_ECONTENTS = "eContents";
    public static final String OPERATION_EOBJECT_EGET = "eGet";
    public static final String OPERATION_EOBJECT_EINVERSE = "eInverse";
    public static final String OPERATION_EOBJECT_FOLLOWINGSIBLINGS = "followingSiblings";
    public static final String OPERATION_EOBJECT_PRECEDINGSIBLINGS = "precedingSiblings";
    public static final String OPERATION_OCLANY_INVOKE = "invoke";
    public static final String OPERATION_OCLANY_CURRENT = "current";
    public static final String OPERATION_OCLANY_GETPROPERTY = "getProperty";
    public static final String OPERATION_OCLANY_PLUS = "+";
    public static final String OPERATION_OCLANY_TOSTRING = "toString";
    public static final String OPERATION_OCLANY_LINE_SEPARATOR = "lineSeparator";
    public static final String OPERATION_STRING_CONTAINS = "contains";
    public static final String OPERATION_STRING_ENDSWITH = "endsWith";
    public static final String OPERATION_STRING_EQUALSIGNORECASE = "equalsIgnoreCase";
    public static final String OPERATION_STRING_LASTINDEX = "lastIndex";
    public static final String OPERATION_STRING_MATCHES = "matches";
    public static final String OPERATION_STRING_PLUS = "+";
    public static final String OPERATION_STRING_REPLACE = "replace";
    public static final String OPERATION_STRING_REPLACEALL = "replaceAll";
    public static final String OPERATION_STRING_STARTSWITH = "startsWith";
    public static final String OPERATION_STRING_SUBSTITUTEALL = "substituteAll";
    public static final String OPERATION_STRING_SUBSTRING = "substring";
    public static final String OPERATION_STRING_TOKENIZE = "tokenize";
    public static final String OPERATION_STRING_TRIM = "trim";
    public static final String OPERATION_STRING_INDEX = "index";
    public static final String OPERATION_STRING_TOKENIZE_LINE = "tokenizeLine";
    public static final String OPERATION_STRING_PREFIX = "prefix";
    public static final String PRIMITIVE_STRING_NAME = "String";
    public static final String TYPE_COLLECTION_NAME = "Collection(T)";
    public static final String TYPE_EOBJECT_NAME = "EObject";
    public static final String TYPE_OCLANY_NAME = "OclAny";
    public static final String TYPE_ORDEREDSET_NAME = "OrderedSet(T)";
    public static final String TYPE_SEQUENCE_NAME = "Sequence(T)";
    private static EPackage nonStdLibPackage;
    private static final String NS_URI = "http://www.eclipse.org/acceleo/mtl/3.0/mtlnonstdlib.ecore";
    private static EClass collectionType;
    private static EClass eObjectType;
    private static EClass oclAnyType;
    private static EClass orderedSetType;
    private static EClass sequenceType;
    private static EClass stringType;

    public AcceleoNonStandardLibrary() {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResources().add((Object)OCLStandardLibraryImpl.INSTANCE.getString().eResource());
        try {
            if (nonStdLibPackage == null) {
                nonStdLibPackage = (EPackage)ModelUtils.load(URI.createURI((String)NS_URI), (ResourceSet)resourceSet);
                collectionType = (EClass)nonStdLibPackage.getEClassifier(TYPE_COLLECTION_NAME);
                eObjectType = (EClass)nonStdLibPackage.getEClassifier(TYPE_EOBJECT_NAME);
                oclAnyType = (EClass)nonStdLibPackage.getEClassifier(TYPE_OCLANY_NAME);
                orderedSetType = (EClass)nonStdLibPackage.getEClassifier(TYPE_ORDEREDSET_NAME);
                sequenceType = (EClass)nonStdLibPackage.getEClassifier(TYPE_SEQUENCE_NAME);
                stringType = (EClass)nonStdLibPackage.getEClassifier(PRIMITIVE_STRING_NAME);
            }
        }
        catch (IOException iOException) {
            AcceleoLogger.log(AcceleoCommonMessages.getString("AcceleoNonStandardLibrary.LoadFailure"), false);
        }
    }

    public EList<EOperation> getExistingOperations(EClassifier type) {
        return this.getExistingOperations(type.getName());
    }

    public synchronized EList<EOperation> getExistingOperations(String classifierName) {
        BasicEList result = new BasicEList();
        if (PRIMITIVE_STRING_NAME.equals(classifierName)) {
            result.addAll(EcoreUtil.copyAll((Collection)stringType.getEOperations()));
        } else if (TYPE_OCLANY_NAME.equals(classifierName)) {
            result.addAll(EcoreUtil.copyAll((Collection)oclAnyType.getEOperations()));
        } else if (TYPE_EOBJECT_NAME.equals(classifierName)) {
            result.addAll(EcoreUtil.copyAll((Collection)eObjectType.getEOperations()));
        } else if (TYPE_COLLECTION_NAME.equals(classifierName)) {
            result.addAll(EcoreUtil.copyAll((Collection)collectionType.getEOperations()));
        } else if (TYPE_ORDEREDSET_NAME.equals(classifierName)) {
            result.addAll(EcoreUtil.copyAll((Collection)orderedSetType.getEOperations()));
        } else if (TYPE_SEQUENCE_NAME.equals(classifierName)) {
            result.addAll(EcoreUtil.copyAll((Collection)sequenceType.getEOperations()));
        }
        return result;
    }
}

