/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.WeakHashMap;

class ObjectPool<T> {
    private final Map<Object, Reference<T>> objects = new WeakHashMap<Object, Reference<T>>(256);

    ObjectPool() {
    }

    public synchronized T intern(T object) {
        T pooled;
        Reference<T> pooledRef = this.objects.get(object);
        if (pooledRef != null && (pooled = pooledRef.get()) != null) {
            return pooled;
        }
        this.objects.put(object, new WeakReference<T>(object));
        return object;
    }
}

