/*
 * Decompiled with CFR 0.152.
 */
package com.naef.jnlua.script;

import com.naef.jnlua.LuaException;
import com.naef.jnlua.LuaState;
import com.naef.jnlua.script.CompiledLuaScript;
import com.naef.jnlua.script.LuaBindings;
import com.naef.jnlua.script.LuaScriptEngineFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.script.AbstractScriptEngine;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.Invocable;
import javax.script.ScriptContext;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;

class LuaScriptEngine
extends AbstractScriptEngine
implements Compilable,
Invocable {
    private static final String READER = "reader";
    private static final String WRITER = "writer";
    private static final String ERROR_WRITER = "errorWriter";
    private static final Pattern LUA_ERROR_MESSAGE = Pattern.compile("^(.+):(\\d+):");
    private LuaScriptEngineFactory factory;
    private LuaState luaState;

    LuaScriptEngine(LuaScriptEngineFactory factory) {
        this.factory = factory;
        this.luaState = new LuaState();
        this.context.setBindings(this.createBindings(), 100);
        this.luaState.openLibs();
        this.luaState.load("io.stdout:setvbuf(\"no\")", "setvbuf");
        this.luaState.call(0, 0);
        this.luaState.load("io.stderr:setvbuf(\"no\")", "setvbuf");
        this.luaState.call(0, 0);
    }

    @Override
    public Bindings createBindings() {
        return new LuaBindings(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object eval(String script, ScriptContext context) throws ScriptException {
        LuaState luaState = this.luaState;
        synchronized (luaState) {
            this.loadChunk(script, context);
            return this.callChunk(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object eval(Reader reader, ScriptContext context) throws ScriptException {
        LuaState luaState = this.luaState;
        synchronized (luaState) {
            this.loadChunk(reader, context);
            return this.callChunk(context);
        }
    }

    @Override
    public ScriptEngineFactory getFactory() {
        return this.factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompiledScript compile(String script) throws ScriptException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        LuaState luaState = this.luaState;
        synchronized (luaState) {
            this.loadChunk(script, null);
            try {
                this.dumpChunk(out);
            }
            finally {
                this.luaState.pop(1);
            }
        }
        return new CompiledLuaScript(this, out.toByteArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompiledScript compile(Reader script) throws ScriptException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        LuaState luaState = this.luaState;
        synchronized (luaState) {
            this.loadChunk(script, null);
            try {
                this.dumpChunk(out);
            }
            finally {
                this.luaState.pop(1);
            }
        }
        return new CompiledLuaScript(this, out.toByteArray());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T getInterface(Class<T> clasz) {
        LuaState luaState = this.luaState;
        synchronized (luaState) {
            this.luaState.pushValue(-10002);
            T t = this.luaState.getProxy(-1, clasz);
            return t;
            finally {
                this.luaState.pop(1);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T getInterface(Object thiz, Class<T> clasz) {
        LuaState luaState = this.luaState;
        synchronized (luaState) {
            this.luaState.pushJavaObject(thiz);
            if (!this.luaState.isTable(-1)) {
                throw new IllegalArgumentException("object is not a table");
            }
            T t = this.luaState.getProxy(-1, clasz);
            return t;
            finally {
                this.luaState.pop(1);
            }
        }
    }

    @Override
    public Object invokeFunction(String name, Object ... args) throws ScriptException, NoSuchMethodException {
        LuaState luaState = this.luaState;
        synchronized (luaState) {
            Object object;
            this.luaState.getGlobal(name);
            if (!this.luaState.isFunction(-1)) {
                this.luaState.pop(1);
                throw new NoSuchMethodException(String.format("function '%s' is undefined", name));
            }
            int i = 0;
            while (i < args.length) {
                this.luaState.pushJavaObject(args[i]);
                ++i;
            }
            this.luaState.call(args.length, 1);
            try {
                object = this.luaState.toJavaObject(-1, Object.class);
                this.luaState.pop(1);
            }
            catch (Throwable throwable) {
                this.luaState.pop(1);
                throw throwable;
            }
            return object;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object invokeMethod(Object thiz, String name, Object ... args) throws ScriptException, NoSuchMethodException {
        LuaState luaState = this.luaState;
        synchronized (luaState) {
            this.luaState.pushJavaObject(thiz);
            try {
                Object object;
                if (!this.luaState.isTable(-1)) {
                    throw new IllegalArgumentException("object is not a table");
                }
                this.luaState.getField(-1, name);
                if (!this.luaState.isFunction(-1)) {
                    this.luaState.pop(1);
                    throw new NoSuchMethodException(String.format("method '%s' is undefined", name));
                }
                this.luaState.pushValue(-2);
                int i = 0;
                while (i < args.length) {
                    this.luaState.pushJavaObject(args[i]);
                    ++i;
                }
                this.luaState.call(args.length + 1, 1);
                try {
                    object = this.luaState.toJavaObject(-1, Object.class);
                    this.luaState.pop(1);
                }
                catch (Throwable throwable) {
                    this.luaState.pop(1);
                    throw throwable;
                }
                return object;
            }
            finally {
                this.luaState.pop(1);
            }
        }
    }

    LuaState getLuaState() {
        return this.luaState;
    }

    void loadChunk(String string, ScriptContext scriptContext) throws ScriptException {
        try {
            this.luaState.load(string, this.getChunkName(scriptContext));
        }
        catch (LuaException e) {
            throw this.getScriptException(e);
        }
    }

    void loadChunk(Reader reader, ScriptContext scriptContext) throws ScriptException {
        this.loadChunk(new ReaderInputStream(reader), scriptContext);
    }

    void loadChunk(InputStream inputStream, ScriptContext scriptContext) throws ScriptException {
        try {
            this.luaState.load(inputStream, this.getChunkName(scriptContext));
        }
        catch (LuaException e) {
            throw this.getScriptException(e);
        }
        catch (IOException e) {
            throw new ScriptException(e);
        }
    }

    Object callChunk(ScriptContext context) throws ScriptException {
        Object[] argv;
        if (context != null) {
            Bindings bindings = context.getBindings(200);
            if (bindings != null) {
                this.applyBindings(bindings);
            }
            if (!((bindings = context.getBindings(100)) == null || bindings instanceof LuaBindings && ((LuaBindings)bindings).getScriptEngine() == this)) {
                this.applyBindings(bindings);
            }
            this.put(READER, context.getReader());
            this.put(WRITER, context.getWriter());
            this.put(ERROR_WRITER, context.getErrorWriter());
            argv = (Object[])context.getAttribute("javax.script.argv");
        } else {
            argv = null;
        }
        int argCount = argv != null ? argv.length : 0;
        int i = 0;
        while (i < argCount) {
            this.luaState.pushJavaObject(argv[i]);
            ++i;
        }
        this.luaState.call(argCount, 1);
        try {
            Object object = this.luaState.toJavaObject(1, Object.class);
            this.luaState.pop(1);
            return object;
        }
        catch (Throwable throwable) {
            try {
                this.luaState.pop(1);
                throw throwable;
            }
            catch (LuaException e) {
                throw this.getScriptException(e);
            }
        }
    }

    void dumpChunk(OutputStream out) throws ScriptException {
        try {
            this.luaState.dump(out);
        }
        catch (LuaException e) {
            throw new ScriptException(e);
        }
        catch (IOException e) {
            throw new ScriptException(e);
        }
    }

    private void applyBindings(Bindings bindings) {
        for (Map.Entry binding : bindings.entrySet()) {
            this.luaState.pushJavaObject(binding.getValue());
            String variableName = (String)binding.getKey();
            int lastDotIndex = variableName.lastIndexOf(46);
            if (lastDotIndex >= 0) {
                variableName = variableName.substring(lastDotIndex + 1);
            }
            this.luaState.setGlobal(variableName);
        }
    }

    private String getChunkName(ScriptContext context) {
        Object fileName;
        if (context != null && (fileName = context.getAttribute("javax.script.filename")) != null) {
            return fileName.toString();
        }
        return "null";
    }

    private ScriptException getScriptException(LuaException e) {
        Matcher matcher = LUA_ERROR_MESSAGE.matcher(e.getMessage());
        if (matcher.find()) {
            String fileName = matcher.group(1);
            int lineNumber = Integer.parseInt(matcher.group(2));
            return new ScriptException(e.getMessage(), fileName, lineNumber);
        }
        return new ScriptException(e);
    }

    private static class ReaderInputStream
    extends InputStream {
        private static final Charset UTF8 = Charset.forName("UTF-8");
        private Reader reader;
        private CharsetEncoder encoder;
        private boolean flushed;
        private CharBuffer charBuffer = CharBuffer.allocate(1024);
        private ByteBuffer byteBuffer = ByteBuffer.allocate(1024);

        public ReaderInputStream(Reader reader) {
            this.reader = reader;
            this.encoder = UTF8.newEncoder();
            this.charBuffer.limit(0);
            this.byteBuffer.limit(0);
        }

        @Override
        public int read() throws IOException {
            if (!this.byteBuffer.hasRemaining()) {
                if (!this.charBuffer.hasRemaining()) {
                    this.charBuffer.clear();
                    this.reader.read(this.charBuffer);
                    this.charBuffer.flip();
                }
                this.byteBuffer.clear();
                if (this.charBuffer.hasRemaining()) {
                    if (this.encoder.encode(this.charBuffer, this.byteBuffer, false).isError()) {
                        throw new IOException("Encoding error");
                    }
                } else if (!this.flushed) {
                    if (this.encoder.encode(this.charBuffer, this.byteBuffer, true).isError()) {
                        throw new IOException("Encoding error");
                    }
                    if (this.encoder.flush(this.byteBuffer).isError()) {
                        throw new IOException("Encoding error");
                    }
                    this.flushed = true;
                }
                this.byteBuffer.flip();
                if (!this.byteBuffer.hasRemaining()) {
                    return -1;
                }
            }
            return this.byteBuffer.get();
        }
    }
}

