/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.utils.dialogfields;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.wb.internal.core.utils.dialogfields.DialogField;
import org.eclipse.wb.internal.core.utils.dialogfields.StringDialogField;
import org.eclipse.wb.internal.core.utils.ui.GridDataFactory;

public class StringItemDialogField
extends StringDialogField {
    private final IStringItemAdapter m_adapter;
    private Image m_itemImage;
    private String m_itemToolTip;

    public StringItemDialogField(IStringItemAdapter adapter) {
        this.m_adapter = adapter;
    }

    public int getNumberOfControls() {
        return 3;
    }

    public Control[] doFillIntoGrid(Composite parent, int nColumns) {
        if (nColumns < this.getNumberOfControls()) {
            throw new IllegalArgumentException("given number of columns is too small");
        }
        Label label = this.getLabelControl(parent);
        GridDataFactory.create((Control)label).fillH();
        Text text = this.getTextControl(parent);
        GridDataFactory.create((Control)text).grabH().spanH(nColumns - 2).fillH();
        ToolBar toolBar = new ToolBar(parent, 0x820000);
        GridDataFactory.create((Control)toolBar).alignVM();
        ToolItem clearItem = new ToolItem(toolBar, 0);
        clearItem.setImage(this.m_itemImage);
        clearItem.setToolTipText(this.m_itemToolTip);
        clearItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StringItemDialogField.this.m_adapter.itemPressed(StringItemDialogField.this);
            }
        });
        return new Control[]{label, text, toolBar};
    }

    public void setItemImage(Image clearImage) {
        this.m_itemImage = clearImage;
    }

    public void setItemToolTip(String clearToolTip) {
        this.m_itemToolTip = clearToolTip;
    }

    public static interface IStringItemAdapter {
        public void itemPressed(DialogField var1);
    }
}

