/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.transformation.evm.specific.resolver.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.eclipse.viatra.transformation.evm.api.Activation;
import org.eclipse.viatra.transformation.evm.api.resolver.ChangeableConflictSet;

public abstract class RandomAccessConflictSetImpl
implements ChangeableConflictSet {
    protected List<Activation<?>> activationList = new ArrayList();
    protected Map<Activation<?>, Integer> activationToPosition = new HashMap();

    @Override
    public Set<Activation<?>> getConflictingActivations() {
        return Collections.unmodifiableSet(this.activationToPosition.keySet());
    }

    @Override
    public boolean addActivation(Activation<?> activation) {
        if (this.activationToPosition.containsKey(activation)) {
            return false;
        }
        this.activationToPosition.put(activation, this.activationList.size());
        this.activationList.add(activation);
        return true;
    }

    @Override
    public boolean removeActivation(Activation<?> activation) {
        Integer position = this.activationToPosition.remove(activation);
        if (position == null) {
            throw new NoSuchElementException();
        }
        int lastPos = this.activationList.size() - 1;
        if (position != lastPos) {
            Activation<?> lastElement = this.activationList.get(lastPos);
            this.activationList.set(position, lastElement);
            this.activationToPosition.put(lastElement, position);
        }
        this.activationList.remove(lastPos);
        return true;
    }

    @Override
    public Set<Activation<?>> getNextActivations() {
        return this.getConflictingActivations();
    }
}

