/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.tooling.ui.queryexplorer.content.matcher;

import java.util.List;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.viatra.addon.databinding.runtime.api.ViatraObservables;
import org.eclipse.viatra.query.runtime.api.IPatternMatch;
import org.eclipse.viatra.query.runtime.emf.helper.ViatraQueryRuntimeHelper;
import org.eclipse.viatra.query.tooling.ui.queryexplorer.content.matcher.BaseContent;
import org.eclipse.viatra.query.tooling.ui.queryexplorer.content.matcher.PatternMatcherContent;
import org.eclipse.viatra.query.tooling.ui.queryexplorer.util.DisplayUtil;

public class PatternMatchContent
extends BaseContent<PatternMatcherContent> {
    private IPatternMatch match;
    private String message;
    private ParameterValueChangedListener listener;
    private List<IObservableValue> affectedValues;

    public PatternMatchContent(PatternMatcherContent parent, IPatternMatch match) {
        super(parent);
        this.match = match;
        this.message = DisplayUtil.getMessage(match);
        this.listener = new ParameterValueChangedListener();
        if (this.message != null) {
            this.setText(ViatraQueryRuntimeHelper.getMessage((IPatternMatch)match, (String)this.message));
        } else {
            this.text = match.toString();
        }
    }

    protected void initialize() {
        this.affectedValues = ViatraObservables.observeFeatures((IPatternMatch)this.match, (IValueChangeListener)this.listener, (String)this.message);
    }

    @Override
    public void dispose() {
        if (this.affectedValues != null) {
            for (IObservableValue val : this.affectedValues) {
                val.removeValueChangeListener((IValueChangeListener)this.listener);
            }
        }
        this.match = null;
        this.listener = null;
    }

    public IPatternMatch getPatternMatch() {
        return this.match;
    }

    public Object[] getLocationObjects() {
        return this.match.toArray();
    }

    private class ParameterValueChangedListener
    implements IValueChangeListener {
        private ParameterValueChangedListener() {
        }

        public void handleValueChange(ValueChangeEvent event) {
            PatternMatchContent.this.setText(ViatraQueryRuntimeHelper.getMessage((IPatternMatch)PatternMatchContent.this.match, (String)PatternMatchContent.this.message));
        }
    }
}

