/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.analysis.xml.core.module;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.tree.TmfTreeDataModel;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.xy.ITmfTreeXYDataProvider;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.xy.TmfTreeXYCompositeDataProvider;
import org.eclipse.tracecompass.tmf.analysis.xml.core.module.TmfXmlUtils;
import org.eclipse.tracecompass.tmf.analysis.xml.core.module.XmlXYDataProvider;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceClosedSignal;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.w3c.dom.Element;

public class XmlDataProviderManager {
    private static @Nullable XmlDataProviderManager INSTANCE;
    private static final String ID_ATTRIBUTE = "id";
    private final Table<ITmfTrace, String, ITmfTreeXYDataProvider<@NonNull TmfTreeDataModel>> fXyProviders = HashBasedTable.create();

    public static synchronized XmlDataProviderManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new XmlDataProviderManager();
        }
        return INSTANCE;
    }

    public static synchronized void dispose() {
        XmlDataProviderManager manager = INSTANCE;
        if (manager != null) {
            TmfSignalManager.deregister((Object)manager);
            manager.fXyProviders.clear();
        }
        INSTANCE = null;
    }

    private XmlDataProviderManager() {
        TmfSignalManager.register((Object)this);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public synchronized ITmfTreeXYDataProvider<@NonNull TmfTreeDataModel> getXyProvider(@NonNull ITmfTrace trace, @NonNull Element viewElement) {
        if (!viewElement.hasAttribute(ID_ATTRIBUTE)) {
            return null;
        }
        String viewId = viewElement.getAttribute(ID_ATTRIBUTE);
        @NonNull XmlXYDataProvider provider = (XmlXYDataProvider)((Object)this.fXyProviders.get((Object)trace, (Object)viewId));
        if (provider != null) {
            return provider;
        }
        for (ITmfTrace opened : TmfTraceManager.getInstance().getOpenedTraces()) {
            if (!TmfTraceManager.getTraceSetWithExperiment((ITmfTrace)opened).contains(trace)) continue;
            Collection traces = TmfTraceManager.getTraceSet((ITmfTrace)trace);
            if (traces.size() == 1) {
                Set<@NonNull String> analysisIds = TmfXmlUtils.getViewAnalysisIds(viewElement);
                Element entry = TmfXmlUtils.getChildElements(viewElement, "entry").get(0);
                provider = XmlXYDataProvider.create(trace, analysisIds, entry);
            } else {
                provider = XmlDataProviderManager.generateExperimentProvider(traces, viewElement);
            }
            if (provider != null) {
                this.fXyProviders.put((Object)trace, (Object)viewId, provider);
            }
            return provider;
        }
        return null;
    }

    private static ITmfTreeXYDataProvider<@NonNull TmfTreeDataModel> generateExperimentProvider(Collection<ITmfTrace> traces, Element viewElement) {
        ArrayList<ITmfTreeXYDataProvider<@NonNull TmfTreeDataModel>> providers = new ArrayList<ITmfTreeXYDataProvider<TmfTreeDataModel>>();
        for (ITmfTrace child : traces) {
            ITmfTreeXYDataProvider<@NonNull TmfTreeDataModel> childProvider = XmlDataProviderManager.getInstance().getXyProvider(child, viewElement);
            if (childProvider == null) continue;
            providers.add(childProvider);
        }
        if (providers.isEmpty()) {
            return null;
        }
        if (providers.size() == 1) {
            return (ITmfTreeXYDataProvider)providers.get(0);
        }
        return new TmfTreeXYCompositeDataProvider(providers, "org.eclipse.tracecompass.tmf.analysis.xml.core.module.XmlXYDataProvider", "org.eclipse.tracecompass.tmf.analysis.xml.core.module.XmlXYDataProvider");
    }

    @TmfSignalHandler
    public synchronized void traceClosed(TmfTraceClosedSignal signal) {
        for (ITmfTrace trace : TmfTraceManager.getTraceSetWithExperiment((ITmfTrace)signal.getTrace())) {
            this.fXyProviders.row((Object)trace).clear();
        }
    }
}

