/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.os.linux.core.kernel.handlers;

import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.os.linux.core.model.ProcessStatus;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelAnalysisEventLayout;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.kernel.Attributes;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.kernel.handlers.KernelEventHandler;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.kernel.handlers.KernelEventHandlerUtils;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.TmfStateValue;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;

public class StateDumpHandler
extends KernelEventHandler {
    public StateDumpHandler(IKernelAnalysisEventLayout layout) {
        super(layout);
    }

    @Override
    public void handleEvent(ITmfStateSystemBuilder ss, ITmfEvent event) throws AttributeNotFoundException {
        ITmfEventField content = event.getContent();
        Integer eventCpu = KernelEventHandlerUtils.getCpu(event);
        int tid = ((Long)content.getField(new String[]{"tid"}).getValue()).intValue();
        int pid = ((Long)content.getField(new String[]{"pid"}).getValue()).intValue();
        int ppid = ((Long)content.getField(new String[]{"ppid"}).getValue()).intValue();
        long status = (Long)content.getField(new String[]{"status"}).getValue();
        String name = (String)NonNullUtils.checkNotNull((Object)((String)content.getField(new String[]{"name"}).getValue()));
        @Nullable Long cpuField = (Long)content.getFieldValue(Long.class, new String[]{"cpu"});
        String threadAttributeName = Attributes.buildThreadAttributeName(tid, eventCpu);
        if (threadAttributeName == null) {
            return;
        }
        int curThreadNode = ss.getQuarkRelativeAndAdd(KernelEventHandlerUtils.getNodeThreads(ss), new String[]{threadAttributeName});
        long timestamp = KernelEventHandlerUtils.getTimestamp(event);
        StateDumpHandler.setProcessName(ss, name, curThreadNode, timestamp);
        StateDumpHandler.setPpid(ss, ppid, curThreadNode, timestamp);
        StateDumpHandler.setPid(ss, tid, pid, curThreadNode, timestamp);
        StateDumpHandler.setStatus(ss, status, curThreadNode, cpuField, timestamp);
    }

    private static void setPid(ITmfStateSystemBuilder ss, int tid, int pid, int curThreadNode, long timestamp) {
        if (tid == pid) {
            return;
        }
        int quark = ss.getQuarkRelativeAndAdd(curThreadNode, new String[]{"PID"});
        if (ss.queryOngoingState(quark).isNull()) {
            ss.modifyAttribute(timestamp, (Object)pid, quark);
        }
    }

    private static void setStatus(ITmfStateSystemBuilder ss, long status, int curThreadNode, @Nullable Long cpu, long timestamp) {
        if (ss.queryOngoingState(curThreadNode).isNull()) {
            ITmfStateValue value = ProcessStatus.getStatusFromStatedump(status).getStateValue();
            ss.modifyAttribute(timestamp, value, curThreadNode);
            if (status == 2L) {
                StateDumpHandler.setRunQueue(ss, curThreadNode, cpu, timestamp);
            }
        }
    }

    private static void setRunQueue(ITmfStateSystemBuilder ss, int curThreadNode, @Nullable Long cpu, long timestamp) {
        if (cpu != null) {
            int quark = ss.getQuarkRelativeAndAdd(curThreadNode, new String[]{"Current_cpu_rq"});
            TmfStateValue value = TmfStateValue.newValueInt((int)cpu.intValue());
            ss.modifyAttribute(timestamp, (ITmfStateValue)value, quark);
        }
    }

    private static void setPpid(ITmfStateSystemBuilder ss, int ppid, int curThreadNode, long timestamp) {
        int quark = ss.getQuarkRelativeAndAdd(curThreadNode, new String[]{"PPID"});
        if (ss.queryOngoingState(quark).isNull()) {
            ss.modifyAttribute(timestamp, (Object)ppid, quark);
        }
    }

    private static void setProcessName(ITmfStateSystemBuilder ss, String name, int curThreadNode, long timestamp) {
        int quark = ss.getQuarkRelativeAndAdd(curThreadNode, new String[]{"Exec_name"});
        if (ss.queryOngoingState(quark).isNull()) {
            TmfStateValue value = TmfStateValue.newValueString((String)name);
            ss.modifyAttribute(timestamp, (ITmfStateValue)value, quark);
        }
    }
}

