/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.workspace.ui;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.sapphire.ImageData;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.def.ActionHandlerDef;
import org.eclipse.sapphire.ui.forms.swt.RelativePathBrowseActionHandler;
import org.eclipse.sapphire.util.ListFactory;

public final class WorkspaceRelativePathBrowseActionHandler
extends RelativePathBrowseActionHandler {
    @Text(value="&workspace relative path")
    private static LocalizableText label;

    static {
        LocalizableText.init(WorkspaceRelativePathBrowseActionHandler.class);
    }

    public void init(SapphireAction action, ActionHandlerDef def) {
        super.init(action, def);
        this.setLabel(label.text());
        this.addImage((ImageData)ImageData.readFromClassLoader(WorkspaceRelativePathBrowseActionHandler.class, (String)"Project.png").required());
    }

    public List<Path> getBasePaths() {
        ListFactory paths = ListFactory.start();
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.isAccessible()) {
                paths.add((Object)new Path(project.getLocation().toPortableString()));
            }
            ++n2;
        }
        return paths.result();
    }

    public Path convertToRelative(Path path) {
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Path location;
            IProject project = iProjectArray[n2];
            if (project.isAccessible() && (location = new Path(project.getLocation().toPortableString())).isPrefixOf(path)) {
                return new Path(project.getName()).append(path.makeRelativeTo(location));
            }
            ++n2;
        }
        return null;
    }

    public Path convertToAbsolute(Path path) {
        if (path != null && path.segmentCount() > 0) {
            String projectName = path.segment(0);
            IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int n = iProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                if (project.isAccessible() && projectName.equals(project.getName())) {
                    return new Path(project.getLocation().toPortableString()).append(path.removeFirstSegments(1));
                }
                ++n2;
            }
        }
        return null;
    }
}

