/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.internal.proxy.core;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.eclipse.remote.core.IRemoteProcess;
import org.eclipse.remote.core.IRemoteProcessControlService;
import org.eclipse.remote.core.IRemoteProcessSignalService;
import org.eclipse.remote.core.IRemoteProcessTerminalService;
import org.eclipse.remote.internal.proxy.core.ProxyProcessBuilder;
import org.eclipse.remote.proxy.protocol.core.StreamChannel;

public class ProxyProcess
implements IRemoteProcessControlService,
IRemoteProcessTerminalService {
    private IRemoteProcess remoteProcess;
    private final StreamChannel stdIOChan;
    private final StreamChannel stdErrChan;
    private final StreamChannel controlChan;
    private final DataOutputStream cmdStream;
    private final DataInputStream resultStream;
    private final Thread cmdThread;
    private volatile int exitValue;
    private volatile boolean isCompleted;

    protected ProxyProcess(IRemoteProcess process) {
        this.remoteProcess = process;
        ProxyProcessBuilder builder = (ProxyProcessBuilder)process.getProcessBuilder();
        List<StreamChannel> streams = builder.getStreams();
        this.controlChan = streams.get(0);
        this.stdIOChan = streams.get(1);
        this.stdErrChan = streams.size() > 2 ? streams.get(2) : null;
        this.cmdStream = new DataOutputStream(this.controlChan.getOutputStream());
        this.resultStream = new DataInputStream(this.controlChan.getInputStream());
        this.isCompleted = false;
        this.exitValue = 0;
        this.cmdThread = new Thread("process result reader"){

            @Override
            public void run() {
                try {
                    ProxyProcess.this.exitValue = ProxyProcess.this.resultStream.readInt();
                }
                catch (IOException iOException) {}
                ProxyProcess.this.isCompleted = true;
                try {
                    ProxyProcess.this.stdIOChan.close();
                }
                catch (IOException iOException) {}
                try {
                    if (ProxyProcess.this.stdErrChan != null) {
                        ProxyProcess.this.stdErrChan.close();
                    }
                }
                catch (IOException iOException) {}
                try {
                    ProxyProcess.this.controlChan.close();
                }
                catch (IOException iOException) {}
            }
        };
        this.cmdThread.start();
    }

    public void destroy() {
        try {
            this.cmdStream.writeByte(0);
            this.cmdStream.flush();
        }
        catch (IOException iOException) {
            this.isCompleted = true;
        }
    }

    public int exitValue() {
        if (!this.isCompleted) {
            throw new IllegalThreadStateException();
        }
        return this.exitValue;
    }

    public InputStream getErrorStream() {
        if (this.stdErrChan == null) {
            return new InputStream(){

                @Override
                public int read() throws IOException {
                    return -1;
                }

                @Override
                public int available() {
                    return 0;
                }
            };
        }
        return this.stdErrChan.getInputStream();
    }

    public InputStream getInputStream() {
        return this.stdIOChan.getInputStream();
    }

    public OutputStream getOutputStream() {
        return this.stdIOChan.getOutputStream();
    }

    public int waitFor() throws InterruptedException {
        this.cmdThread.join();
        return this.exitValue;
    }

    public boolean isCompleted() {
        return this.isCompleted;
    }

    public IRemoteProcess getRemoteProcess() {
        return this.remoteProcess;
    }

    public void setTerminalSize(int cols, int rows, int pwidth, int pheight) {
        try {
            this.cmdStream.writeByte(1);
            this.cmdStream.writeInt(cols);
            this.cmdStream.writeInt(rows);
            this.cmdStream.writeInt(pwidth);
            this.cmdStream.writeInt(pheight);
            this.cmdStream.flush();
        }
        catch (IOException iOException) {}
    }

    public static class Factory
    implements IRemoteProcess.Service.Factory {
        public <T extends IRemoteProcess.Service> T getService(IRemoteProcess remoteProcess, Class<T> service) {
            if (ProxyProcess.class.equals(service)) {
                return (T)new ProxyProcess(remoteProcess);
            }
            if (IRemoteProcessControlService.class.equals(service) || IRemoteProcessSignalService.class.equals(service) || IRemoteProcessTerminalService.class.equals(service)) {
                return (T)remoteProcess.getService(ProxyProcess.class);
            }
            return null;
        }
    }
}

