/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.internal.core.services.local;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteConnectionHostService;

public class LocalConnectionHostService
implements IRemoteConnectionHostService {
    private final IRemoteConnection connection;

    public LocalConnectionHostService(IRemoteConnection connection) {
        this.connection = connection;
    }

    @Override
    public IRemoteConnection getRemoteConnection() {
        return this.connection;
    }

    @Override
    public String getHostname() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            return "unknown";
        }
    }

    @Override
    public String getPassphrase() {
        return "";
    }

    @Override
    public String getPassword() {
        return "";
    }

    @Override
    public int getPort() {
        return 0;
    }

    @Override
    public int getTimeout() {
        return 0;
    }

    @Override
    public boolean useLoginShell() {
        return true;
    }

    @Override
    public String getUsername() {
        return System.getProperty("user.name");
    }

    @Override
    public void setHostname(String hostname) {
    }

    @Override
    public void setPassphrase(String passphrase) {
    }

    @Override
    public void setPassword(String password) {
    }

    @Override
    public void setPort(int port) {
    }

    @Override
    public void setTimeout(int timeout) {
    }

    @Override
    public void setUseLoginShell(boolean useLogingShell) {
    }

    @Override
    public void setUsePassword(boolean usePassword) {
    }

    @Override
    public void setUsername(String username) {
    }

    @Override
    public boolean usePassword() {
        return false;
    }

    public static class Factory
    implements IRemoteConnection.Service.Factory {
        @Override
        public <T extends IRemoteConnection.Service> T getService(IRemoteConnection remoteConnection, Class<T> service) {
            if (service.equals(IRemoteConnectionHostService.class)) {
                return (T)new LocalConnectionHostService(remoteConnection);
            }
            return null;
        }
    }
}

