/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler;

import java.io.IOException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.qvtd.compiler.AbstractCompilerChain;
import org.eclipse.qvtd.compiler.CompilerChain;
import org.eclipse.qvtd.compiler.CompilerChainException;
import org.eclipse.qvtd.compiler.CompilerProblem;
import org.eclipse.qvtd.compiler.CompilerProblems;
import org.eclipse.qvtd.compiler.CompilerStep;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseEnvironmentFactory;

public abstract class AbstractCompilerStep
implements CompilerStep {
    protected final @NonNull CompilerChain compilerChain;
    protected final @NonNull QVTbaseEnvironmentFactory environmentFactory;
    protected final @NonNull String name;
    protected final @NonNull String defaultExtension;
    private CompilerProblems compilerProblems = null;

    protected AbstractCompilerStep(@NonNull CompilerChain compilerChain, @NonNull String stepName) {
        this.compilerChain = compilerChain;
        this.environmentFactory = compilerChain.getEnvironmentFactory();
        this.name = stepName;
        this.defaultExtension = (String)ClassUtil.nonNullState((Object)AbstractCompilerChain.getDefaultExtension(stepName));
    }

    @Override
    public void addProblem(@NonNull CompilerProblem problem) {
        CompilerProblems compilerProblems2 = this.compilerProblems;
        if (compilerProblems2 == null) {
            this.compilerProblems = compilerProblems2 = new CompilerProblems();
        }
        compilerProblems2.addProblem(problem);
    }

    protected void compiled(@NonNull Object object) {
        this.compiled(this.name, object);
    }

    @Deprecated
    protected void compiled(@NonNull String stepKey, @NonNull Object object) {
        this.compilerChain.compiled(stepKey, object);
    }

    protected @NonNull Resource createResource() throws IOException {
        return this.compilerChain.createResource(this.getURI());
    }

    @Deprecated
    protected @NonNull Resource createResource(@NonNull URI uri) throws IOException {
        return this.compilerChain.createResource(uri);
    }

    @Override
    public @NonNull String getDefaultExtension() {
        return this.defaultExtension;
    }

    @Override
    public @NonNull String getName() {
        return this.name;
    }

    public <T> @Nullable T getOption(@NonNull CompilerChain.Key<T> optionKey) {
        return this.compilerChain.getOption(this.name, optionKey);
    }

    protected @NonNull URI getURI() {
        return this.compilerChain.getURI(this.name, CompilerChain.URI_KEY);
    }

    protected @NonNull Resource saveResource(@NonNull Resource asResource) throws IOException {
        this.compilerChain.saveResource(asResource, this.name);
        this.compiled(asResource);
        return asResource;
    }

    @Deprecated
    protected @NonNull Resource saveResource(@NonNull Resource asResource, @NonNull String stepKey) throws IOException {
        this.compilerChain.saveResource(asResource, stepKey);
        this.compiled(stepKey, asResource);
        return asResource;
    }

    public void throwCompilerChainExceptionForErrors() throws CompilerChainException {
        if (this.compilerProblems != null) {
            this.compilerProblems.throwCompilerChainExceptionForErrors();
        }
    }
}

