/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.category;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.pde.internal.core.isite.ISite;
import org.eclipse.pde.internal.core.isite.ISiteBundle;
import org.eclipse.pde.internal.core.isite.ISiteCategory;
import org.eclipse.pde.internal.core.isite.ISiteCategoryDefinition;
import org.eclipse.pde.internal.core.isite.ISiteFeature;
import org.eclipse.pde.internal.core.isite.ISiteModel;
import org.eclipse.pde.internal.ui.editor.FormOutlinePage;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.category.CategoryLabelProvider;
import org.eclipse.pde.internal.ui.editor.category.SiteBundleAdapter;
import org.eclipse.pde.internal.ui.editor.category.SiteFeatureAdapter;

public class CategoryOutlinePage
extends FormOutlinePage {
    private LabelProvider fLabelProvider;

    public CategoryOutlinePage(PDEFormEditor editor) {
        super(editor);
    }

    @Override
    protected Object[] getChildren(Object parent) {
        ISiteCategoryDefinition catDef;
        ISite site;
        PDEFormPage page;
        ISiteModel model;
        if (parent instanceof PDEFormPage && (model = (ISiteModel)(page = (PDEFormPage)((Object)parent)).getModel()).isValid()) {
            site = model.getSite();
            if (page.getId().equals("ius")) {
                ISiteBundle[] bundles2;
                ISiteFeature[] features;
                ISiteCategoryDefinition[] catDefs;
                ArrayList<Object> result = new ArrayList<Object>();
                ISiteCategoryDefinition[] iSiteCategoryDefinitionArray = catDefs = site.getCategoryDefinitions();
                int n = catDefs.length;
                int n2 = 0;
                while (n2 < n) {
                    ISiteCategoryDefinition catDef2 = iSiteCategoryDefinitionArray[n2];
                    result.add(catDef2);
                    ++n2;
                }
                ISiteFeature[] iSiteFeatureArray = features = site.getFeatures();
                int n3 = features.length;
                n = 0;
                while (n < n3) {
                    ISiteFeature feature = iSiteFeatureArray[n];
                    if (feature.getCategories().length == 0) {
                        result.add(new SiteFeatureAdapter(null, feature));
                    }
                    ++n;
                }
                ISiteBundle[] iSiteBundleArray = bundles2 = site.getBundles();
                int n4 = bundles2.length;
                n3 = 0;
                while (n3 < n4) {
                    ISiteBundle bundle = iSiteBundleArray[n3];
                    if (bundle.getCategories().length == 0) {
                        result.add(new SiteBundleAdapter(null, bundle));
                    }
                    ++n3;
                }
                return result.toArray();
            }
        }
        if (parent instanceof ISiteCategoryDefinition && (model = (catDef = (ISiteCategoryDefinition)parent).getModel()).isValid()) {
            ISiteBundle[] bundles;
            int n;
            site = model.getSite();
            ISiteFeature[] features = site.getFeatures();
            HashSet<Serializable> result = new HashSet<Serializable>();
            ISiteFeature[] iSiteFeatureArray = features;
            int n5 = features.length;
            int bundles2 = 0;
            while (bundles2 < n5) {
                ISiteCategory[] cats;
                ISiteFeature feature = iSiteFeatureArray[bundles2];
                ISiteCategory[] iSiteCategoryArray = cats = feature.getCategories();
                n = cats.length;
                int n6 = 0;
                while (n6 < n) {
                    ISiteCategory cat = iSiteCategoryArray[n6];
                    if (cat.getDefinition() != null && cat.getDefinition().equals(catDef)) {
                        result.add(new SiteFeatureAdapter(cat.getName(), feature));
                    }
                    ++n6;
                }
                ++bundles2;
            }
            ISiteBundle[] iSiteBundleArray = bundles = site.getBundles();
            int n7 = bundles.length;
            n5 = 0;
            while (n5 < n7) {
                ISiteCategory[] cats;
                ISiteBundle bundle = iSiteBundleArray[n5];
                ISiteCategory[] iSiteCategoryArray = cats = bundle.getCategories();
                int n8 = cats.length;
                n = 0;
                while (n < n8) {
                    ISiteCategory cat = iSiteCategoryArray[n];
                    if (cat.getDefinition() != null && cat.getDefinition().equals(catDef)) {
                        result.add(new SiteBundleAdapter(cat.getName(), bundle));
                    }
                    ++n;
                }
                ++n5;
            }
            return result.toArray();
        }
        return new Object[0];
    }

    @Override
    protected String getParentPageId(Object item) {
        String pageId = null;
        if (item instanceof ISiteCategoryDefinition || item instanceof SiteFeatureAdapter || item instanceof SiteBundleAdapter) {
            pageId = "ius";
        }
        if (pageId != null) {
            return pageId;
        }
        return super.getParentPageId(item);
    }

    @Override
    public ILabelProvider createLabelProvider() {
        this.fLabelProvider = new CategoryLabelProvider();
        return this.fLabelProvider;
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.fLabelProvider != null) {
            this.fLabelProvider.dispose();
        }
    }
}

