/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.profile.types.generator;

import java.util.ArrayList;
import java.util.Arrays;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.papyrus.infra.types.ElementTypeConfiguration;
import org.eclipse.papyrus.infra.types.ElementTypeSetConfiguration;
import org.eclipse.papyrus.infra.types.SpecializationTypeConfiguration;
import org.eclipse.papyrus.uml.profile.types.generator.ImpliedExtension;
import org.eclipse.papyrus.uml.profile.types.generator.UMLElementTypes;
import org.eclipse.uml2.common.util.UML2Util;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.StringExtensions;

@Singleton
public class Identifiers {
    @Inject
    @Extension
    private UMLElementTypes _uMLElementTypes;
    @Accessors
    private String prefix;
    @Accessors
    private final String umlElementTypesSet = "org.eclipse.papyrus.uml.service.types.UMLElementTypeSet";
    @Accessors
    private final String contextId = "org.eclipse.papyrus.infra.services.edit.TypeContext";
    @Accessors
    private String baseElementTypesSet = "org.eclipse.papyrus.uml.service.types.UMLElementTypeSet";
    @Accessors
    private ElementTypeSetConfiguration baseElementTypesSetConfiguration;
    @Accessors
    private boolean suppressSemanticSuperElementTypes;
    @Accessors
    private AdapterFactory adapterFactory;
    private String identifierBase;

    public String setIdentifierBase(Package umlPackage) {
        this.identifierBase = this.prefix;
        return this.identifierBase;
    }

    public String getQualified(String id) {
        return String.valueOf(this.identifierBase) + "." + id;
    }

    public String toElementTypeID(ImpliedExtension umlExtension, ElementTypeConfiguration supertype) {
        boolean _lessEqualsThan;
        String _xblockexpression = null;
        Stereotype stereo = umlExtension.getStereotype();
        String _xifexpression = null;
        int _size = stereo.getAllExtendedMetaclasses().size();
        boolean bl = _lessEqualsThan = _size <= 1;
        if (_lessEqualsThan) {
            _xifexpression = stereo.getName();
        } else {
            String _name = stereo.getName();
            String _plus = String.valueOf(_name) + "_";
            String _name_1 = umlExtension.getMetaclass().getName();
            _xifexpression = String.valueOf(_plus) + _name_1;
        }
        String name = _xifexpression;
        String _qualified = this.getQualified(UML2Util.getValidJavaIdentifier((String)name));
        String _hintSuffix = this.hintSuffix(supertype);
        _xblockexpression = String.valueOf(_qualified) + _hintSuffix;
        return _xblockexpression;
    }

    public String toElementTypeName(final ImpliedExtension umlExtension, final ElementTypeConfiguration supertype) {
        String _xblockexpression = null;
        final Stereotype stereo = umlExtension.getStereotype();
        ArrayList _newArrayList = CollectionLiterals.newArrayList((Object[])new Object[0]);
        Procedures.Procedure1<ArrayList<Object>> _function = new Procedures.Procedure1<ArrayList<Object>>(){

            public void apply(ArrayList<Object> it) {
                boolean _greaterThan;
                int _size = stereo.getExtensions().size();
                boolean bl = _greaterThan = _size > 1;
                if (_greaterThan) {
                    it.add(umlExtension.getMetaclass().getName());
                }
                if (!StringExtensions.isNullOrEmpty((String)supertype.getHint()) && IterableExtensions.size(Identifiers.this._uMLElementTypes.getDiagramSpecificElementTypes(umlExtension.getMetaclass())) > 1) {
                    it.add(supertype.getHint());
                }
            }
        };
        ArrayList discriminators = (ArrayList)ObjectExtensions.operator_doubleArrow((Object)_newArrayList, (Procedures.Procedure1)_function);
        String _xifexpression = null;
        boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty((Iterable)discriminators);
        if (_isNullOrEmpty) {
            boolean _lessEqualsThan;
            String _xifexpression_1 = null;
            int _size = stereo.getAllExtendedMetaclasses().size();
            boolean bl = _lessEqualsThan = _size <= 1;
            if (_lessEqualsThan) {
                _xifexpression_1 = stereo.getName();
            } else {
                String _name = stereo.getName();
                String _plus = String.valueOf(_name) + " ";
                String _name_1 = umlExtension.getMetaclass().getName();
                _xifexpression_1 = String.valueOf(_plus) + _name_1;
            }
            _xifexpression = _xifexpression_1;
        } else {
            String _name_2 = stereo.getName();
            Functions.Function1<Object, CharSequence> _function_1 = new Functions.Function1<Object, CharSequence>(){

                public CharSequence apply(Object it) {
                    return it.toString();
                }
            };
            String _join = IterableExtensions.join((Iterable)discriminators, (CharSequence)" (", (CharSequence)", ", (CharSequence)")", (Functions.Function1)_function_1);
            _xifexpression = String.valueOf(_name_2) + _join;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    protected String _hintSuffix(ElementTypeConfiguration elementType) {
        return "";
    }

    protected String _hintSuffix(SpecializationTypeConfiguration elementType) {
        String _xifexpression = null;
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)elementType.getHint());
        if (_isNullOrEmpty) {
            _xifexpression = "";
        } else {
            String _hint = elementType.getHint();
            _xifexpression = "_" + _hint;
        }
        return _xifexpression;
    }

    protected String _getLabel(EObject object) {
        String _xblockexpression = null;
        Adapter _adapt = null;
        if (this.adapterFactory != null) {
            _adapt = this.adapterFactory.adapt((Notifier)object, IItemLabelProvider.class);
        }
        IItemLabelProvider labels = (IItemLabelProvider)_adapt;
        String _text = null;
        if (labels != null) {
            _text = labels.getText((Object)object);
        }
        _xblockexpression = _text;
        return _xblockexpression;
    }

    protected String _getLabel(EClassifier eClassifier) {
        String _xtrycatchfinallyexpression = null;
        try {
            ResourceLocator _resourceLocator = this.getResourceLocator((EObject)eClassifier);
            String _string = null;
            if (_resourceLocator != null) {
                String _name = eClassifier.getName();
                String _plus = "_UI_" + _name;
                String _plus_1 = String.valueOf(_plus) + "_type";
                _string = _resourceLocator.getString(_plus_1);
            }
            _xtrycatchfinallyexpression = _string;
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                Exception e = (Exception)_t;
                _xtrycatchfinallyexpression = eClassifier.getName();
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        return _xtrycatchfinallyexpression;
    }

    private ResourceLocator getResourceLocator(EObject object) {
        Adapter _switchResult = null;
        Adapter _adapt = null;
        if (this.adapterFactory != null) {
            _adapt = this.adapterFactory.adapt((Notifier)object, IItemLabelProvider.class);
        }
        Adapter adapter = _adapt;
        boolean _matched = false;
        if (adapter instanceof ResourceLocator) {
            _matched = true;
            _switchResult = adapter;
        }
        return (ResourceLocator)_switchResult;
    }

    public String hintSuffix(ElementTypeConfiguration elementType) {
        if (elementType instanceof SpecializationTypeConfiguration) {
            return this._hintSuffix((SpecializationTypeConfiguration)elementType);
        }
        if (elementType != null) {
            return this._hintSuffix(elementType);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(elementType).toString());
    }

    public String getLabel(EObject eClassifier) {
        if (eClassifier instanceof EClassifier) {
            return this._getLabel((EClassifier)eClassifier);
        }
        if (eClassifier != null) {
            return this._getLabel(eClassifier);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(eClassifier).toString());
    }

    @Pure
    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    @Pure
    public String getUmlElementTypesSet() {
        return "org.eclipse.papyrus.uml.service.types.UMLElementTypeSet";
    }

    @Pure
    public String getContextId() {
        return "org.eclipse.papyrus.infra.services.edit.TypeContext";
    }

    @Pure
    public String getBaseElementTypesSet() {
        return this.baseElementTypesSet;
    }

    public void setBaseElementTypesSet(String baseElementTypesSet) {
        this.baseElementTypesSet = baseElementTypesSet;
    }

    @Pure
    public ElementTypeSetConfiguration getBaseElementTypesSetConfiguration() {
        return this.baseElementTypesSetConfiguration;
    }

    public void setBaseElementTypesSetConfiguration(ElementTypeSetConfiguration baseElementTypesSetConfiguration) {
        this.baseElementTypesSetConfiguration = baseElementTypesSetConfiguration;
    }

    @Pure
    public boolean isSuppressSemanticSuperElementTypes() {
        return this.suppressSemanticSuperElementTypes;
    }

    public void setSuppressSemanticSuperElementTypes(boolean suppressSemanticSuperElementTypes) {
        this.suppressSemanticSuperElementTypes = suppressSemanticSuperElementTypes;
    }

    @Pure
    public AdapterFactory getAdapterFactory() {
        return this.adapterFactory;
    }

    public void setAdapterFactory(AdapterFactory adapterFactory) {
        this.adapterFactory = adapterFactory;
    }
}

