/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.parts;

import java.lang.reflect.Field;
import java.util.Collection;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Shape;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.figures.BorderedNodeFigure;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.FillStyle;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.runtime.notation.datatype.GradientData;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.papyrus.infra.internationalization.common.utils.InternationalizationPreferencesUtils;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.AppliedStereotypeNodeLabelDisplayEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.providers.UIAdapterImpl;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.InteractionUseEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.OLDGateCreationEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.OLDGatesHolderGraphicalNodeEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.figures.InteractionUseRectangleFigure;
import org.eclipse.papyrus.uml.diagram.sequence.util.CommandHelper;
import org.eclipse.papyrus.uml.diagram.sequence.util.InteractionUseUtil;
import org.eclipse.papyrus.uml.diagram.sequence.util.LifelineCoveredByUpdater;
import org.eclipse.papyrus.uml.diagram.sequence.util.NotificationHelper;
import org.eclipse.papyrus.uml.internationalization.utils.utils.UMLLabelInternationalization;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.uml.Gate;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.InteractionUse;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.UMLPackage;

public class OLDCustomInteractionUseEditPart
extends InteractionUseEditPart {
    private NotificationHelper notifier = null;

    public OLDCustomInteractionUseEditPart(View view) {
        super(view);
    }

    protected NotificationHelper getNotifier() {
        if (this.notifier == null) {
            try {
                Field f = InteractionUseEditPart.class.getDeclaredField("notifier");
                f.setAccessible(true);
                this.notifier = (NotificationHelper)f.get((Object)this);
            }
            catch (Exception e) {
                this.notifier = new NotificationHelper(new UIAdapterImpl(){

                    protected void safeNotifyChanged(Notification msg) {
                        OLDCustomInteractionUseEditPart.this.handleNotificationEvent(msg);
                    }
                });
            }
        }
        return this.notifier;
    }

    @Override
    protected void setLineWidth(int width) {
        if (this.primaryShape instanceof Shape) {
            ((Shape)this.primaryShape).setLineWidth(width);
        }
        super.setLineWidth(width);
    }

    @Override
    protected IFigure createNodeShape() {
        this.primaryShape = new InteractionUseRectangleFigure();
        this.getPrimaryShape().setShadow(false);
        return this.primaryShape;
    }

    @Override
    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new OLDGatesHolderGraphicalNodeEditPolicy());
        this.installEditPolicy("Gate Creation Edit Policy", (EditPolicy)new OLDGateCreationEditPolicy());
        this.installEditPolicy("AppliedStereotypeLabelDisplayEditPolicy", (EditPolicy)new AppliedStereotypeNodeLabelDisplayEditPolicy());
    }

    protected NodeFigure createNodeFigure() {
        return new BorderedNodeFigure((IFigure)super.createNodeFigure());
    }

    @Override
    protected IFigure getContentPaneFor(IGraphicalEditPart editPart) {
        if (editPart instanceof IBorderItemEditPart) {
            return this.getBorderedFigure().getBorderItemContainer();
        }
        return this.getContentPane();
    }

    @Override
    protected boolean removeFixedChild(EditPart childEditPart) {
        return super.removeFixedChild(childEditPart);
    }

    @Override
    protected boolean addFixedChild(EditPart childEditPart) {
        return super.addFixedChild(childEditPart);
    }

    protected void setTransparency(int transp) {
        this.getPrimaryShape().setTransparency(transp);
    }

    protected void setBackgroundColor(Color color) {
        this.getPrimaryShape().setBackgroundColor(color);
        this.getPrimaryShape().setIsUsingGradient(false);
        this.getPrimaryShape().setGradientData(-1, -1, 0);
    }

    protected void setGradient(GradientData gradient) {
        InteractionUseRectangleFigure fig = this.getPrimaryShape();
        FillStyle style = (FillStyle)this.getPrimaryView().getStyle(NotationPackage.Literals.FILL_STYLE);
        if (gradient != null) {
            fig.setIsUsingGradient(true);
            fig.setGradientData(style.getFillColor(), gradient.getGradientColor1(), gradient.getGradientStyle());
        } else {
            fig.setIsUsingGradient(false);
        }
    }

    public boolean supportsGradient() {
        return true;
    }

    @Override
    protected void handleNotificationEvent(Notification notification) {
        NotificationHelper notifier = this.getNotifier();
        Object feature = notification.getFeature();
        if (UMLPackage.eINSTANCE.getInteractionUse_RefersTo().equals(feature)) {
            if (notification.getOldValue() instanceof Interaction) {
                notifier.unlistenAll();
            }
            InteractionUse interactionUse = (InteractionUse)this.resolveSemanticElement();
            CommandHelper.executeCommandWithoutHistory(this.getEditingDomain(), RemoveCommand.create((EditingDomain)this.getEditingDomain(), (Object)interactionUse, (Object)UMLPackage.eINSTANCE.getInteractionUse_ActualGate(), (Collection)interactionUse.getActualGates()), true);
            if (notification.getNewValue() instanceof Interaction) {
                Interaction interaction = (Interaction)notification.getNewValue();
                notifier.listenObject((Notifier)interaction);
                interactionUse.getActualGates();
                EList formalGates = interaction.getFormalGates();
                for (Gate formalGate : formalGates) {
                    Gate newActualGate = (Gate)EcoreUtil.create((EClass)UMLPackage.Literals.GATE);
                    newActualGate.setName(formalGate.getName());
                    CommandHelper.executeCommandWithoutHistory(this.getEditingDomain(), AddCommand.create((EditingDomain)this.getEditingDomain(), (Object)this.resolveSemanticElement(), (Object)UMLPackage.eINSTANCE.getInteractionUse_ActualGate(), (Object)newActualGate), true);
                    if (InternationalizationPreferencesUtils.getInternationalizationPreference((EObject)formalGate) && UMLLabelInternationalization.getInstance().getLabelWithoutUML((NamedElement)formalGate) != null) {
                        UMLLabelInternationalization.getInstance().setLabel((NamedElement)newActualGate, UMLLabelInternationalization.getInstance().getLabelWithoutUML((NamedElement)formalGate), null);
                    }
                    notifier.listenObject((Notifier)formalGate);
                    notifier.listenObject((Notifier)newActualGate);
                }
            }
        } else if (UMLPackage.eINSTANCE.getInteractionFragment_Covered().equals(feature)) {
            this.activate();
            this.resizeInteractionFragmentFigure();
        } else if (UMLPackage.eINSTANCE.getInteraction_FormalGate().equals(feature)) {
            Object newValue;
            InteractionUse interactionUse = (InteractionUse)this.resolveSemanticElement();
            Object oldValue = notification.getOldValue();
            if (oldValue instanceof Gate) {
                notifier.unlistenObject((Notifier)((Gate)oldValue));
                EList actualGates = interactionUse.getActualGates();
                int i = actualGates.size() - 1;
                while (i >= 0) {
                    Gate element = (Gate)actualGates.get(i);
                    if (((Gate)oldValue).getName().equals(element.getName())) {
                        notifier.unlistenObject((Notifier)element);
                        CommandHelper.executeCommandWithoutHistory(this.getEditingDomain(), RemoveCommand.create((EditingDomain)this.getEditingDomain(), (Object)interactionUse, (Object)UMLPackage.eINSTANCE.getInteractionUse_ActualGate(), (Object)element), true);
                    }
                    --i;
                }
            }
            if ((newValue = notification.getNewValue()) instanceof Gate) {
                Gate actualGate = interactionUse.createActualGate(((Gate)newValue).getName());
                notifier.listenObject((Notifier)((Gate)newValue));
                notifier.listenObject((Notifier)actualGate);
            }
        } else if (UMLPackage.eINSTANCE.getInteractionUse_ActualGate().equals(feature)) {
            if (notification.getEventType() != 3) {
                notification.getEventType();
            }
        } else if (UMLPackage.eINSTANCE.getNamedElement_Name().equals(feature) && notification.getNotifier() instanceof Gate) {
            Gate gate = (Gate)notification.getNotifier();
            if (gate.eContainer() instanceof Interaction) {
                InteractionUse interactionUse = (InteractionUse)this.resolveSemanticElement();
                EList actualGates = interactionUse.getActualGates();
                String oldValue = notification.getOldStringValue();
                String newValue = notification.getNewStringValue();
                for (Gate actualGate : actualGates) {
                    if ((oldValue != null || actualGate.getName() != null) && (oldValue == null || !oldValue.equals(actualGate.getName()))) continue;
                    notifier.unlistenObject((Notifier)actualGate);
                    actualGate.setName(newValue);
                    notifier.listenObject((Notifier)actualGate);
                }
            } else if (gate.eContainer() instanceof InteractionUse) {
                notifier.unlistenObject((Notifier)gate);
                gate.setName(notification.getOldStringValue());
                notifier.listenObject((Notifier)gate);
            }
        }
        if (this.getModel() != null && this.getModel() == notification.getNotifier() && NotationPackage.eINSTANCE.getLineStyle_LineWidth().equals(feature)) {
            this.refreshLineWidth();
        }
        if (notification.getNotifier() instanceof Bounds) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    LifelineCoveredByUpdater updater = new LifelineCoveredByUpdater();
                    updater.update((GraphicalEditPart)OLDCustomInteractionUseEditPart.this);
                }
            });
        }
        this.refreshShadow();
        super.handleNotificationEvent(notification);
    }

    private boolean checkActualGateExistence(Gate actualGate) {
        InteractionUse interactionUse = (InteractionUse)this.resolveSemanticElement();
        Interaction interaction = interactionUse.getRefersTo();
        if (interaction != null) {
            for (Gate formalGate : interaction.getFormalGates()) {
                if (!formalGate.getName().equals(actualGate.getName())) continue;
                return true;
            }
        }
        return false;
    }

    public void activate() {
        super.activate();
        NotificationHelper notifier = this.getNotifier();
        if (this.resolveSemanticElement() instanceof InteractionUse) {
            InteractionUse interactionUse = (InteractionUse)this.resolveSemanticElement();
            Interaction interaction = interactionUse.getRefersTo();
            if (interaction != null) {
                notifier.listenObject((Notifier)interaction);
                for (Gate formalGate : interaction.getFormalGates()) {
                    notifier.listenObject((Notifier)formalGate);
                }
            }
            for (Gate actualGate : interactionUse.getActualGates()) {
                notifier.listenObject((Notifier)actualGate);
            }
        }
    }

    public void deactivate() {
        super.deactivate();
        if (this.notifier != null) {
            this.notifier.unlistenAll();
        }
    }

    public void removeNotify() {
        if (this.notifier != null) {
            this.notifier.unlistenAll();
        }
        super.removeNotify();
    }

    public void performRequest(Request request) {
        if (request.getType().equals("open")) {
            InteractionUse interactionUse = (InteractionUse)this.resolveSemanticElement();
            Interaction interaction = interactionUse.getRefersTo();
            if (interaction == null) {
                MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)"Warning", (String)"There is no referenced interaction!");
                return;
            }
            Diagram diagram = InteractionUseUtil.findDiagram(this.getNotationView(), interaction);
            if (diagram == null) {
                MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)"Warning", (String)"Cannot find diagram of the referenced interaction!");
            } else {
                InteractionUseUtil.openDiagram(diagram);
            }
            return;
        }
        super.performRequest(request);
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        this.refreshTransparency();
    }
}

