/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.library.oclany;

import com.google.common.collect.Iterables;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.evaluation.Executor;
import org.eclipse.ocl.pivot.ids.IdResolver;
import org.eclipse.ocl.pivot.library.AbstractUntypedUnaryOperation;
import org.eclipse.ocl.pivot.messages.PivotMessages;
import org.eclipse.ocl.pivot.values.InvalidValueException;

public class OclElementOclModelTypeOperation
extends AbstractUntypedUnaryOperation {
    public static final @NonNull OclElementOclModelTypeOperation INSTANCE = new OclElementOclModelTypeOperation();

    @Override
    public @NonNull Type evaluate(@NonNull Executor executor, @Nullable Object sourceVal) {
        if (sourceVal instanceof InvalidValueException) {
            throw (InvalidValueException)sourceVal;
        }
        Type sourceType = executor.getIdResolver().getDynamicTypeOf(sourceVal);
        if (sourceVal == null) {
            throw new InvalidValueException(PivotMessages.NullNavigation, "source value", "oclModelType");
        }
        Iterable<@NonNull Class> modelClasses = ((IdResolver.IdResolverExtension)executor.getIdResolver()).getModelClassesOf(sourceVal);
        if (modelClasses == null) {
            throw new InvalidValueException(PivotMessages.IncompatibleModelType, sourceType);
        }
        if (Iterables.size(modelClasses) == 1) {
            return modelClasses.iterator().next();
        }
        throw new InvalidValueException(PivotMessages.IncompatibleModelType, sourceType);
    }
}

