/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4j.jsonrpc.json.adapters;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Supplier;

public class CollectionTypeAdapterFactory
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
        if (!Collection.class.isAssignableFrom(typeToken.getRawType())) {
            return null;
        }
        Type elementType = this.getCollectionElementType(typeToken.getType(), typeToken.getRawType());
        TypeAdapter elementTypeAdapter = gson.getAdapter(TypeToken.get((Type)elementType));
        Supplier constructor = this.getConstructor(typeToken.getRawType());
        return new Adapter(gson, elementType, elementTypeAdapter, constructor);
    }

    private <E> Supplier<Collection<E>> getConstructor(Class<Collection<E>> rawType) {
        try {
            Constructor constructor = rawType.getDeclaredConstructor(new Class[0]);
            if (!constructor.isAccessible()) {
                constructor.setAccessible(true);
            }
            return () -> {
                try {
                    return (Collection)constructor.newInstance(new Object[0]);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            };
        }
        catch (NoSuchMethodException e) {
            if (SortedSet.class.isAssignableFrom(rawType)) {
                return () -> new TreeSet();
            }
            if (Set.class.isAssignableFrom(rawType)) {
                return () -> new LinkedHashSet();
            }
            if (Queue.class.isAssignableFrom(rawType)) {
                return () -> new LinkedList();
            }
            return () -> new ArrayList();
        }
    }

    private Type getCollectionElementType(Type type, Class<?> rawType) {
        Map<String, Type> varMapping = this.createVariableMapping(type, rawType, Collections.emptyMap());
        return this.getCollectionElementType(type, rawType, varMapping);
    }

    private Type getCollectionElementType(Type type, Class<?> rawType, Map<String, Type> varMapping) {
        Class<?> rawSupertype;
        if (rawType == Collection.class) {
            return this.getActualTypeParameter(type, 0, varMapping);
        }
        Class<?>[] interfaces = rawType.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (!Collection.class.isAssignableFrom(interfaces[i])) continue;
            Type genericInterface = rawType.getGenericInterfaces()[i];
            Map<String, Type> newVarMapping = this.createVariableMapping(genericInterface, interfaces[i], varMapping);
            return this.getCollectionElementType(genericInterface, interfaces[i], newVarMapping);
        }
        if (!rawType.isInterface() && Collection.class.isAssignableFrom(rawSupertype = rawType.getSuperclass())) {
            Type genericSuperclass = rawType.getGenericSuperclass();
            Map<String, Type> newVarMapping = this.createVariableMapping(genericSuperclass, rawSupertype, varMapping);
            return this.getCollectionElementType(genericSuperclass, rawSupertype, newVarMapping);
        }
        return Object.class;
    }

    private <T> Map<String, Type> createVariableMapping(Type type, Class<T> rawType, Map<String, Type> oldVarMapping) {
        if (type instanceof ParameterizedType) {
            TypeVariable<Class<T>>[] vars = rawType.getTypeParameters();
            HashMap<String, Type> newVarMapping = new HashMap<String, Type>(CollectionTypeAdapterFactory.capacity(vars.length));
            for (int i = 0; i < vars.length; ++i) {
                newVarMapping.put(vars[i].getName(), this.getActualTypeParameter(type, i, oldVarMapping));
            }
            return newVarMapping;
        }
        return Collections.emptyMap();
    }

    private static int capacity(int expectedSize) {
        if (expectedSize < 3) {
            return expectedSize + 1;
        }
        return expectedSize + expectedSize / 3;
    }

    private Type getActualTypeParameter(Type type, int index, Map<String, Type> varMapping) {
        Type[] args;
        if (type instanceof ParameterizedType && index < (args = ((ParameterizedType)type).getActualTypeArguments()).length) {
            Type arg = args[index];
            if (arg instanceof WildcardType) {
                arg = ((WildcardType)arg).getUpperBounds()[0];
            }
            if (arg instanceof TypeVariable) {
                String name = ((TypeVariable)arg).getName();
                if (varMapping.containsKey(name)) {
                    return varMapping.get(name);
                }
            } else {
                return arg;
            }
        }
        return Object.class;
    }

    private static class Adapter<E>
    extends TypeAdapter<Collection<E>> {
        private final Gson gson;
        private final Type elementType;
        private final TypeAdapter<E> elementTypeAdapter;
        private final Supplier<Collection<E>> constructor;

        Adapter(Gson gson, Type elementType, TypeAdapter<E> elementTypeAdapter, Supplier<Collection<E>> constructor) {
            this.gson = gson;
            this.elementType = elementType;
            this.elementTypeAdapter = elementTypeAdapter;
            this.constructor = constructor;
        }

        public Collection<E> read(JsonReader in) throws IOException {
            JsonToken peek = in.peek();
            if (peek == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            if (peek == JsonToken.BEGIN_ARRAY) {
                Collection<Object> collection = this.constructor.get();
                in.beginArray();
                while (in.hasNext()) {
                    Object instance = this.elementTypeAdapter.read(in);
                    collection.add(instance);
                }
                in.endArray();
                return collection;
            }
            Collection<Object> collection = this.constructor.get();
            Object instance = this.elementTypeAdapter.read(in);
            collection.add(instance);
            return collection;
        }

        public void write(JsonWriter out, Collection<E> collection) throws IOException {
            if (collection == null) {
                out.nullValue();
                return;
            }
            out.beginArray();
            for (E element : collection) {
                if (element != null && this.elementType != element.getClass() && (this.elementType instanceof TypeVariable || this.elementType instanceof Class)) {
                    TypeAdapter runtimeTypeAdapter = this.gson.getAdapter(TypeToken.get(element.getClass()));
                    runtimeTypeAdapter.write(out, element);
                    continue;
                }
                this.elementTypeAdapter.write(out, element);
            }
            out.endArray();
        }
    }
}

