/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.rpm.ui.editor;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.linuxtools.internal.rpm.ui.editor.Activator;
import org.eclipse.linuxtools.internal.rpm.ui.editor.Messages;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.osgi.framework.FrameworkUtil;

public final class RpmPackageBuildProposalsJob
extends Job {
    private static RpmPackageBuildProposalsJob job = null;
    private IJobChangeListener updateFinishedListener = new JobChangeAdapter();
    protected static final IPropertyChangeListener PROPERTY_LISTENER = event -> {
        if (event.getProperty().equals("currentRpmtools")) {
            RpmPackageBuildProposalsJob.update(true);
        }
    };
    protected static final IPreferenceStore STORE = new ScopedPreferenceStore(InstanceScope.INSTANCE, FrameworkUtil.getBundle(RpmPackageBuildProposalsJob.class).getSymbolicName());

    private RpmPackageBuildProposalsJob(String name) {
        super(name);
        this.addJobChangeListener(this.updateFinishedListener);
    }

    /*
     * Exception decompiling
     */
    protected IStatus run(IProgressMonitor monitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[TRYBLOCK]], but top level block is 22[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean shouldSchedule() {
        return ((Object)((Object)this)).equals((Object)job);
    }

    public static void update(boolean async) {
        boolean runJob = false;
        Date today = new Date();
        if (STORE.getBoolean("rpmListBackgroundBuild")) {
            int period = STORE.getInt("rpmListBuildPeriod");
            if (period == 1) {
                runJob = true;
            } else {
                long lastBuildTime = STORE.getLong("rpmLisMastBuild");
                if (lastBuildTime == 0L) {
                    runJob = true;
                } else {
                    long interval = (today.getTime() - lastBuildTime) / 86400000L;
                    if (period == 2 && interval >= 7L) {
                        runJob = true;
                    } else if (period == 3 && interval >= 30L) {
                        runJob = true;
                    }
                }
            }
            if (runJob) {
                if (job == null) {
                    job = new RpmPackageBuildProposalsJob(Messages.RpmPackageBuildProposalsJob_0);
                } else {
                    job.cancel();
                }
                if (async) {
                    job.schedule();
                } else {
                    job.run((IProgressMonitor)new NullProgressMonitor());
                }
                STORE.setValue("rpmLisMastBuild", today.getTime());
            }
        } else if (job != null) {
            job.cancel();
            job = null;
        }
    }

    public static Set<String> getPackages() throws InterruptedException, IOException {
        if (job.getThread() != Thread.currentThread()) {
            job.join();
        }
        HashSet<String> list = new HashSet<String>();
        String rpmpkgsFile = Activator.getDefault().getPreferenceStore().getString("rpmListFilePath");
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(rpmpkgsFile)));){
            String line = reader.readLine();
            while (line != null) {
                list.add(line.trim());
                line = reader.readLine();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return list;
    }

    public static void setPropertyChangeListener(boolean activated) {
        if (activated) {
            STORE.addPropertyChangeListener(PROPERTY_LISTENER);
        } else {
            STORE.removePropertyChangeListener(PROPERTY_LISTENER);
        }
    }
}

