/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.controllers.dnd;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.jubula.client.core.model.IEventExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.controllers.dnd.LocalSelectionTransfer;
import org.eclipse.jubula.client.ui.rcp.editors.JBEditorHelper;
import org.eclipse.jubula.client.ui.rcp.editors.TestCaseEditor;
import org.eclipse.jubula.client.ui.rcp.handlers.AddExistingEventHandlerHandler;
import org.eclipse.swt.dnd.TransferData;

public class EventHandlerDropTargetListener
extends ViewerDropAdapter {
    private TestCaseEditor m_editor;

    public EventHandlerDropTargetListener(TestCaseEditor editor) {
        super((Viewer)editor.getEventHandlerTreeViewer());
        this.m_editor = editor;
        boolean scrollExpand = Plugin.getDefault().getPreferenceStore().getBoolean("TREEAUTOSCROLL_PREF_KEY");
        this.setScrollExpandEnabled(scrollExpand);
    }

    public boolean performDrop(Object data) {
        if (this.m_editor.getEditorHelper().requestEditableState() != JBEditorHelper.EditableState.OK) {
            return false;
        }
        LocalSelectionTransfer transfer = LocalSelectionTransfer.getInstance();
        for (Object obj : transfer.getSelection()) {
            if (!(obj instanceof INodePO)) {
                return false;
            }
            INodePO node = (INodePO)obj;
            if (!(node instanceof ISpecTestCasePO)) continue;
            INodePO target = (INodePO)this.getCurrentTarget();
            ISpecTestCasePO specTcGUI = (ISpecTestCasePO)node;
            if (target == node) continue;
            this.addEventHandler(target, specTcGUI);
        }
        return true;
    }

    private void addEventHandler(INodePO target, ISpecTestCasePO eventSpecTc) {
        ISpecTestCasePO ownerSpecTc = (ISpecTestCasePO)this.m_editor.getEventHandlerTreeViewer().getInput();
        if (target == null || target instanceof IEventExecTestCasePO) {
            if (AddExistingEventHandlerHandler.hasTestCaseAllEventHandler(ownerSpecTc)) {
                return;
            }
            this.m_editor.addEventHandler(eventSpecTc, ownerSpecTc);
            LocalSelectionTransfer.getInstance().setSelection(null);
        }
    }

    public boolean validateDrop(Object target, int operation, TransferData transferType) {
        if (LocalSelectionTransfer.getInstance().getSelection() == null) {
            return false;
        }
        LocalSelectionTransfer transfer = LocalSelectionTransfer.getInstance();
        for (Object obj : transfer.getSelection()) {
            if (!(obj instanceof INodePO)) {
                return false;
            }
            INodePO node = (INodePO)obj;
            if (!(node instanceof ISpecTestCasePO)) {
                return false;
            }
            INodePO parent = (INodePO)this.getViewer().getInput();
            if (!node.hasCircularDependences(parent)) continue;
            return false;
        }
        return true;
    }
}

