/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.designtime.symbols;

import java.util.Arrays;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jst.jsf.common.internal.types.ValueType;
import org.eclipse.jst.jsf.common.util.TypeUtil;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContext;
import org.eclipse.jst.jsf.context.symbol.ERuntimeSource;
import org.eclipse.jst.jsf.context.symbol.IBeanInstanceSymbol;
import org.eclipse.jst.jsf.context.symbol.IBoundedMapTypeDescriptor;
import org.eclipse.jst.jsf.context.symbol.IComponentSymbol;
import org.eclipse.jst.jsf.context.symbol.IInstanceSymbol;
import org.eclipse.jst.jsf.context.symbol.IJavaTypeDescriptor2;
import org.eclipse.jst.jsf.context.symbol.IObjectSymbol;
import org.eclipse.jst.jsf.context.symbol.ISymbol;
import org.eclipse.jst.jsf.context.symbol.ITypeDescriptor;
import org.eclipse.jst.jsf.context.symbol.InitializedSymbolFactory;
import org.eclipse.jst.jsf.context.symbol.SymbolFactory;
import org.eclipse.jst.jsf.context.symbol.internal.util.IObjectSymbolBasedValueType;
import org.eclipse.jst.jsf.designtime.resolver.IStructuredDocumentSymbolResolverFactory;
import org.eclipse.jst.jsf.designtime.resolver.StructuredDocumentSymbolResolverFactory;
import org.eclipse.jst.jsf.validation.internal.IJSFViewValidator;
import org.eclipse.jst.jsf.validation.internal.el.ELExpressionValidator;
import org.eclipse.jst.jsf.validation.internal.el.IExpressionSemanticValidator;

public final class JSFSymbolFactory
extends InitializedSymbolFactory {
    public ValueType getValueTypeFromEL(String elText, IStructuredDocumentContext elContext, IFile file, IStructuredDocumentSymbolResolverFactory symbolResolverFactory) {
        assert (elText != null);
        assert (elContext != null);
        assert (file != null);
        IJSFViewValidator.ReporterAdapter reporter = new IJSFViewValidator.ReporterAdapter();
        ELExpressionValidator validator = new ELExpressionValidator(elContext, elText, symbolResolverFactory, reporter);
        validator.validateXMLNode();
        IExpressionSemanticValidator semValidator = validator.getSemanticValidator();
        if (semValidator != null && semValidator.getExpressionType() instanceof ValueType) {
            return (ValueType)semValidator.getExpressionType();
        }
        return null;
    }

    public ValueType getValueTypeFromEL(String elText, IStructuredDocumentContext elContext, IFile file) {
        return this.getValueTypeFromEL(elText, elContext, file, StructuredDocumentSymbolResolverFactory.getInstance());
    }

    private boolean isFacesDataModel(ValueType type) {
        return type.isInstanceOf("Ljavax.faces.model.DataModel;");
    }

    public String getRowSignatureFromDataModel(ValueType type) {
        String signature;
        ISymbol resSymbol;
        if (type instanceof IObjectSymbolBasedValueType && (resSymbol = ((IObjectSymbolBasedValueType)type).getSymbol().call("getRowData", ECollections.emptyEList(), "res")) != null && resSymbol instanceof IObjectSymbol && !"Ljava.lang.Object;".equals(signature = ((IObjectSymbol)resSymbol).getTypeDescriptor().getTypeSignature())) {
            return signature;
        }
        return null;
    }

    public boolean isContainerType(ValueType type) {
        return type.isArray() || type.isInstanceOf("Ljava.util.Collection;");
    }

    public String getRowSignatureFromValueType(ValueType type) {
        if (this.isContainerType(type)) {
            return this.getElementSignatureFromContainerType(type);
        }
        if (this.isFacesDataModel(type)) {
            return this.getRowSignatureFromDataModel(type);
        }
        return type.getSignature();
    }

    public final ISymbol createArraySymbol(String symbolName, String signature, ERuntimeSource source, IJavaProject javaProject) {
        assert (symbolName != null);
        assert (signature != null);
        assert (javaProject != null);
        String arrayElementType = Signature.getElementType((String)signature);
        int arrayCount = Signature.getArrayCount((String)signature);
        String adjustedSignature = null;
        adjustedSignature = arrayCount > 0 ? Signature.createArraySignature((String)arrayElementType, (int)(arrayCount - 1)) : arrayElementType;
        return this.createScalarSymbol(symbolName, adjustedSignature, source, javaProject);
    }

    public final ISymbol createScalarSymbol(String symbolName, String signature, ERuntimeSource source, IJavaProject javaProject) {
        IType type;
        assert (symbolName != null);
        assert (signature != null);
        assert (javaProject != null);
        String elementType = Signature.getElementType((String)signature);
        IJavaTypeDescriptor2 desc = SymbolFactory.eINSTANCE.createIJavaTypeDescriptor2();
        int arrayCount = Signature.getArrayCount((String)signature);
        if (arrayCount > 0) {
            desc.setArrayCount(arrayCount);
        }
        if ((type = TypeUtil.resolveType((IJavaProject)javaProject, (String)elementType)) != null) {
            desc.setType(type);
        } else {
            desc.setTypeSignatureDelegate(Signature.getTypeErasure((String)signature));
        }
        desc.getTypeParameterSignatures().addAll(Arrays.asList(Signature.getTypeArguments((String)signature)));
        IComponentSymbol symbol = SymbolFactory.eINSTANCE.createIComponentSymbol();
        symbol.setName(symbolName);
        symbol.setTypeDescriptor((ITypeDescriptor)desc);
        symbol.setRuntimeSource(ERuntimeSource.TAG_INSTANTIATED_SYMBOL_LITERAL);
        return symbol;
    }

    public final ISymbol createFromList(String symbolName, ValueType valueType, ERuntimeSource source, String description, IJavaProject javaProject) {
        String typeArg;
        assert (symbolName != null);
        assert (valueType != null);
        assert (javaProject != null);
        assert ("Ljava.util.List;".equals(valueType.getSignature()));
        String[] typeArguments = valueType.getTypeArguments();
        if (typeArguments != null && typeArguments.length > 0 && Signature.getTypeSignatureKind((String)(typeArg = typeArguments[0])) == 1) {
            return this.createScalarSymbol(symbolName, typeArg, source, javaProject);
        }
        return this.createDefaultSymbol(symbolName, ERuntimeSource.TAG_INSTANTIATED_SYMBOL_LITERAL, description);
    }

    public final ISymbol createDefaultSymbol(String symbolName, ERuntimeSource source, String description) {
        assert (symbolName != null);
        IBoundedMapTypeDescriptor typeDesc = SymbolFactory.eINSTANCE.createIBoundedMapTypeDescriptor();
        typeDesc.setMapSource(new HashMap());
        IComponentSymbol symbol = SymbolFactory.eINSTANCE.createIComponentSymbol();
        symbol.setName(symbolName);
        symbol.setTypeDescriptor((ITypeDescriptor)typeDesc);
        symbol.setDetailedDescription(description);
        symbol.setRuntimeSource(source);
        return symbol;
    }

    public IInstanceSymbol createMessageBundleSymbol(String symbolName, String bundleName, IJavaProject project) {
        throw new UnsupportedOperationException("see https://bugs.eclipse.org/bugs/show_bug.cgi?id=215461");
    }

    public IBeanInstanceSymbol createManagedBeanSymbol(String symbolName, String fullyQualifiedName, ERuntimeSource source, String description, IJavaProject javaProject) {
        throw new UnsupportedOperationException("see https://bugs.eclipse.org/bugs/show_bug.cgi?id=215461");
    }
}

