/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lfs.server.fs;

import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.lfs.internal.AtomicObjectOutputStream;
import org.eclipse.jgit.lfs.lib.AnyLongObjectId;
import org.eclipse.jgit.lfs.server.LargeFileRepository;
import org.eclipse.jgit.lfs.server.Response;

public class FileLfsRepository
implements LargeFileRepository {
    private final String url;
    private final Path dir;
    private static final char[] hexchar = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public FileLfsRepository(String url, Path dir) throws IOException {
        this.url = url;
        this.dir = dir;
        Files.createDirectories(dir, new FileAttribute[0]);
    }

    @Override
    public Response.Action getDownloadAction(AnyLongObjectId id) {
        return this.getAction(id);
    }

    @Override
    public Response.Action getUploadAction(AnyLongObjectId id, long size) {
        return this.getAction(id);
    }

    @Override
    @Nullable
    public Response.Action getVerifyAction(AnyLongObjectId id) {
        return null;
    }

    @Override
    public long getSize(AnyLongObjectId id) throws IOException {
        Path p = this.getPath(id);
        if (Files.exists(p, new LinkOption[0])) {
            return Files.size(p);
        }
        return -1L;
    }

    public Path getDir() {
        return this.dir;
    }

    protected Path getPath(AnyLongObjectId id) {
        StringBuilder s = new StringBuilder(70);
        s.append(FileLfsRepository.toHexCharArray(id.getFirstByte())).append('/');
        s.append(FileLfsRepository.toHexCharArray(id.getSecondByte())).append('/');
        s.append(id.name());
        return this.dir.resolve(s.toString());
    }

    private Response.Action getAction(AnyLongObjectId id) {
        Response.Action a = new Response.Action();
        a.href = this.url + id.getName();
        a.header = Collections.singletonMap("Authorization", "not:required");
        return a;
    }

    ReadableByteChannel getReadChannel(AnyLongObjectId id) throws IOException {
        return FileChannel.open(this.getPath(id), StandardOpenOption.READ);
    }

    AtomicObjectOutputStream getOutputStream(AnyLongObjectId id) throws IOException {
        Path path = this.getPath(id);
        Path parent = path.getParent();
        if (parent != null) {
            Files.createDirectories(parent, new FileAttribute[0]);
        }
        return new AtomicObjectOutputStream(path, id);
    }

    private static char[] toHexCharArray(int b) {
        char[] dst = new char[2];
        FileLfsRepository.formatHexChar(dst, 0, b);
        return dst;
    }

    private static void formatHexChar(char[] dst, int p, int b) {
        int o = p + 1;
        while (o >= p && b != 0) {
            dst[o--] = hexchar[b & 0xF];
            b >>>= 4;
        }
        while (o >= p) {
            dst[o--] = 48;
        }
    }
}

