/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.net4j.protocol;

import java.io.IOException;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.server.internal.net4j.bundle.OM;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOServerProtocol;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOServerReadIndication;
import org.eclipse.emf.cdo.spi.server.InternalTransaction;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class ResetTransactionIndication
extends CDOServerReadIndication {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_PROTOCOL, ResetTransactionIndication.class);
    private int transactionID;
    private int commitNumber;

    public ResetTransactionIndication(CDOServerProtocol protocol) {
        super(protocol, (short)61);
    }

    protected void indicating(CDODataInput in) throws IOException {
        this.transactionID = in.readXInt();
        if (TRACER.isEnabled()) {
            TRACER.format("Read transactionID: {0}", new Object[]{this.transactionID});
        }
        this.commitNumber = in.readXInt();
        if (TRACER.isEnabled()) {
            TRACER.format("Read commitNumber: {0}", new Object[]{this.commitNumber});
        }
    }

    protected void responding(CDODataOutput out) throws IOException {
        InternalTransaction transaction = (InternalTransaction)this.getView(this.transactionID);
        InternalTransaction.CommitAttempt lastCommitSuccess = transaction.getLastCommitAttempt();
        if (lastCommitSuccess != null && lastCommitSuccess.getCommitNumber() == this.commitNumber) {
            out.writeBoolean(true);
            out.writeXLong(lastCommitSuccess.getTimeStamp());
            out.writeXLong(lastCommitSuccess.getPreviousTimeStamp());
        } else {
            out.writeBoolean(false);
        }
    }
}

