/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.security.internal.ui.editor;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.databinding.beans.PojoProperties;
import org.eclipse.emf.cdo.security.Directory;
import org.eclipse.emf.cdo.security.Realm;
import org.eclipse.emf.cdo.security.SecurityFactory;
import org.eclipse.emf.cdo.security.SecurityPackage;
import org.eclipse.emf.cdo.security.internal.ui.editor.AbstractSectionPart;
import org.eclipse.emf.cdo.security.internal.ui.messages.Messages;
import org.eclipse.emf.cdo.security.internal.ui.util.ActionBarsHelper;
import org.eclipse.emf.cdo.security.internal.ui.util.ObjectExistsConverter;
import org.eclipse.emf.cdo.security.internal.ui.util.SecurityUIUtil;
import org.eclipse.emf.cdo.security.internal.ui.util.TableLabelProvider;
import org.eclipse.emf.cdo.ui.shared.SharedIcons;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.CommandActionDelegate;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.CreateChildCommand;
import org.eclipse.emf.edit.command.DeleteCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.net4j.util.ui.UIUtil;
import org.eclipse.net4j.util.ui.actions.SelectionListenerAction;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TableSection<T extends EObject>
extends AbstractSectionPart<Directory> {
    private final Class<T> elementType;
    private final EClass elementEClass;
    private TableViewer viewer;

    public TableSection(Class<T> elementType, EClass elementEClass, EditingDomain domain, AdapterFactory adapterFactory) {
        super(Directory.class, SecurityPackage.Literals.DIRECTORY, domain, adapterFactory);
        this.elementType = elementType;
        this.elementEClass = elementEClass;
    }

    @Override
    protected void createContents(Composite parent, FormToolkit toolkit) {
        parent.setLayout((Layout)new GridLayout());
        Table table = toolkit.createTable(parent, 768);
        table.setLayoutData((Object)new GridData(4, 4, true, true));
        this.viewer = new TableViewer(table);
        this.viewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider(this.getAdapterFactory()));
        this.viewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider(this.getAdapterFactory()));
        this.addFilters(this.viewer);
        this.forwardSelection((StructuredViewer)this.viewer);
        this.getContext().bindValue(ViewersObservables.observeInput((Viewer)this.viewer), this.getValue());
        this.configureDragSupport(this.viewer);
        this.configureDropSupport(this.viewer);
    }

    public void setFocus() {
        if (this.viewer != null) {
            this.viewer.getControl().setFocus();
        } else {
            super.setFocus();
        }
    }

    protected void addFilters(TableViewer viewer) {
        SecurityUIUtil.applyTypeFilter((StructuredViewer)viewer, this.elementEClass);
        SecurityUIUtil.applySupportedElementFilter((StructuredViewer)viewer, this.elementEClass);
    }

    @Override
    public boolean setFormInput(Object input) {
        if (this.elementType.isInstance(input)) {
            this.viewer.setSelection((ISelection)new StructuredSelection(input), true);
            return true;
        }
        if (input instanceof Directory && input == this.getDirectory(((Directory)input).getRealm())) {
            boolean result = super.setFormInput(input);
            this.checkForUnsupportedModelContent();
            return result;
        }
        if (input instanceof Realm) {
            return this.setFormInput(this.getDirectory((Realm)input));
        }
        return false;
    }

    protected Directory getDirectory(Realm realm) {
        return SecurityUIUtil.getDirectory(realm, this.elementEClass);
    }

    @Override
    protected void createActionToolbar(Section section, FormToolkit toolkit) {
        ToolBarManager mgr = new ToolBarManager(0x800000);
        ToolBar toolbar = mgr.createControl((Composite)section);
        toolbar.setCursor(section.getDisplay().getSystemCursor(21));
        mgr.add(this.createAddNewAction());
        IAction deleteAction = this.createDeleteAction();
        mgr.add(deleteAction);
        if (deleteAction instanceof ISelectionChangedListener) {
            ISelectionChangedListener scl = (ISelectionChangedListener)deleteAction;
            this.viewer.addSelectionChangedListener(scl);
            scl.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this.viewer, this.viewer.getSelection()));
        }
        mgr.update(true);
        section.setTextClient((Control)toolbar);
        ActionBarsHelper actionBarsHelper = new ActionBarsHelper(this.getEditorActionBars());
        ActionBarsHelper globalAction = actionBarsHelper.addGlobalAction(ActionFactory.DELETE.getId(), deleteAction);
        globalAction.install((Viewer)this.viewer);
    }

    protected IAction createAddNewAction() {
        Command dummy = this.createCreateNewCommand();
        ImageDescriptor image = null;
        if (dummy instanceof CommandActionDelegate) {
            image = ExtendedImageRegistry.getInstance().getImageDescriptor(((CommandActionDelegate)dummy).getImage());
        }
        Action result = new Action(dummy.getLabel(), image){

            public void run() {
                final Command command = TableSection.this.createCreateNewCommand();
                if (command.canExecute()) {
                    TableSection.this.getEditingDomain().getCommandStack().execute(command);
                    TableSection.this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            TableSection.this.viewer.getControl().setFocus();
                            TableSection.this.viewer.setSelection((ISelection)new StructuredSelection(command.getResult().toArray()));
                        }
                    });
                }
            }
        };
        this.getContext().bindValue(PojoProperties.value((String)"enabled").observe(this.getContext().getValidationRealm(), (Object)result), this.getValue(), null, ObjectExistsConverter.ObjectWritableConverter.createUpdateValueStrategy());
        return result;
    }

    protected Command createCreateNewCommand() {
        Object input = this.viewer.getInput();
        Directory parent = input instanceof Directory ? (Directory)input : SecurityFactory.eINSTANCE.createDirectory();
        EObject child = EcoreUtil.create((EClass)this.elementEClass);
        CommandParameter param = new CommandParameter((Object)parent, (Object)SecurityPackage.Literals.DIRECTORY__ITEMS, (Object)child);
        return CreateChildCommand.create((EditingDomain)this.getEditingDomain(), (Object)parent, (Object)param, Collections.singleton(parent));
    }

    protected IAction createDeleteAction() {
        Command dummy = this.createDeleteCommand(EcoreUtil.create((EClass)this.elementEClass));
        return new SelectionListenerAction<EObject>(dummy.getLabel(), SharedIcons.getDescriptor((String)"etool16/delete.gif")){

            public void run() {
                Command delete = TableSection.this.createDeleteCommand((EObject)this.getSelectedObject());
                if (delete.canExecute()) {
                    TableSection.this.getEditingDomain().getCommandStack().execute(delete);
                }
            }

            protected boolean updateSelection(IStructuredSelection selection) {
                return super.updateSelection(selection) && SecurityUIUtil.isEditable(TableSection.this.getInput());
            }

            protected Class<EObject> getType() {
                return EObject.class;
            }
        };
    }

    protected Command createDeleteCommand(EObject toDelete) {
        return DeleteCommand.create((EditingDomain)this.getEditingDomain(), (Object)toDelete);
    }

    private void forwardSelection(StructuredViewer viewer) {
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IManagedForm form = TableSection.this.getManagedForm();
                if (form != null) {
                    form.fireSelectionChanged((IFormPart)TableSection.this, event.getSelection());
                }
            }
        });
    }

    protected void configureDragSupport(TableViewer viewer) {
        UIUtil.addDragSupport((StructuredViewer)viewer);
    }

    protected void configureDropSupport(final TableViewer viewer) {
        viewer.addDropSupport(7, new Transfer[]{LocalSelectionTransfer.getTransfer()}, (DropTargetListener)new ViewerDropAdapter((Viewer)viewer){
            {
                super($anonymous0);
                this.setFeedbackEnabled(false);
            }

            public boolean validateDrop(Object target, int operation, TransferData transferType) {
                EObject objectToDrop;
                boolean result = false;
                if (target instanceof EObject && LocalSelectionTransfer.getTransfer().isSupportedType(transferType) && (objectToDrop = this.getObjectToDrop(transferType)) != null) {
                    boolean bl = result = TableSection.this.getDropReference((EObject)target, objectToDrop) != null;
                    if (result && (this.getCurrentEvent().operations | 1) != 0) {
                        this.overrideOperation(1);
                    }
                }
                return result;
            }

            public boolean performDrop(Object data) {
                IStructuredSelection selection = (IStructuredSelection)data;
                EObject objectToDrop = (EObject)UIUtil.getElement((ISelection)selection, EObject.class);
                EObject target = (EObject)this.getCurrentTarget();
                Command command = AddCommand.create((EditingDomain)TableSection.this.getEditingDomain(), (Object)target, (Object)TableSection.this.getDropReference(target, objectToDrop), (Collection)selection.toList());
                boolean result = TableSection.this.execute(command);
                if (result) {
                    viewer.getControl().setFocus();
                    viewer.setSelection((ISelection)new StructuredSelection((Object)target));
                }
                return result;
            }

            private EObject getObjectToDrop(TransferData transferType) {
                return (EObject)UIUtil.getElement((ISelection)LocalSelectionTransfer.getTransfer().getSelection(), EObject.class);
            }
        });
    }

    protected EReference getDropReference(EObject target, EObject objectToDrop) {
        return null;
    }

    protected boolean execute(Command command) {
        boolean result = command.canExecute();
        if (result) {
            this.getEditingDomain().getCommandStack().execute(command);
        }
        return result;
    }

    protected void checkForUnsupportedModelContent() {
        if (this.getInput() == null) {
            this.getManagedForm().getMessageManager().addMessage((Object)this, Messages.TableSection_2, null, 2, this.viewer.getControl());
        } else if (this.viewer.getTable().getItemCount() < ((Directory)this.getInput()).getItems().size()) {
            this.getManagedForm().getMessageManager().addMessage((Object)this, Messages.TableSection_3, null, 2, this.viewer.getControl());
        }
    }
}

