/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.js.common.ui;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class PopUpPropertyDialog
extends Dialog {
    private final String title;
    private final String initialValue;
    private final VerifyListener verifyListener;
    private String valueLabel;
    private Text valueText;
    private String name;

    public PopUpPropertyDialog(Shell shell, String title, String valueLabel, String initialValue, VerifyListener verifyListener) {
        super(shell);
        this.title = title;
        this.valueLabel = valueLabel;
        this.initialValue = initialValue;
        this.verifyListener = verifyListener;
    }

    protected Control createDialogArea(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginTop = 7;
        gridLayout.marginWidth = 12;
        comp.setLayout((Layout)gridLayout);
        Label label = new Label(comp, 0);
        label.setText(this.valueLabel);
        label.setFont(comp.getFont());
        this.valueText = new Text(comp, 2052);
        GridData gd = new GridData(768);
        gd.widthHint = 300;
        this.valueText.setLayoutData((Object)gd);
        this.valueText.setFont(comp.getFont());
        this.valueText.setText(this.initialValue == null ? "" : this.initialValue);
        this.valueText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PopUpPropertyDialog.this.updateButtons();
            }
        });
        return comp;
    }

    public String getName() {
        return this.name;
    }

    protected void buttonPressed(int buttonId) {
        this.name = buttonId == 0 ? this.valueText.getText() : null;
        super.buttonPressed(buttonId);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    protected void updateButtons() {
        String name = this.valueText.getText().trim();
        Event e = new Event();
        e.widget = this.valueText;
        VerifyEvent ev = new VerifyEvent(e);
        ev.doit = true;
        if (this.verifyListener != null) {
            ev.text = name;
            this.verifyListener.verifyText(ev);
        }
        this.getButton(0).setEnabled(name.length() > 0);
    }

    public void create() {
        super.create();
        this.updateButtons();
    }
}

