/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.core.util;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.wst.jsdt.chromium.debug.core.ScriptNameManipulator;

public class JavaScriptRegExpSupport {
    private static final Set<Character> BAD_CHARS = new HashSet<Character>(Arrays.asList(Character.valueOf('/'), Character.valueOf('['), Character.valueOf(']'), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('?'), Character.valueOf('.')));

    public static String encodeLiteral(String literal) {
        StringBuilder builder = new StringBuilder(literal.length() * 2);
        int i = 0;
        while (i < literal.length()) {
            char ch = literal.charAt(i);
            if (BAD_CHARS.contains(Character.valueOf(ch))) {
                builder.append('\\');
            }
            builder.append(ch);
            ++i;
        }
        return builder.toString();
    }

    public static Pattern convertToJavaPattern(ScriptNameManipulator.ScriptNamePattern pattern) {
        return Pattern.compile(pattern.getJavaScriptRegExp());
    }
}

