/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.databinding.model.presentation;

import org.eclipse.swt.graphics.Image;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.broadcast.ObjectInfoPresentationDecorateIcon;
import org.eclipse.wb.internal.core.databinding.Activator;
import org.eclipse.wb.internal.core.databinding.model.IBindingInfo;
import org.eclipse.wb.internal.core.databinding.model.IDatabindingsProvider;
import org.eclipse.wb.internal.core.databinding.model.IObserveInfo;
import org.eclipse.wb.internal.core.utils.ui.SwtResourceManager;

public abstract class JavaInfoDecorator {
    public static final Image IMAGE = Activator.getImage("decorator.gif");
    private final IDatabindingsProvider m_provider;

    public JavaInfoDecorator(IDatabindingsProvider provider, ObjectInfo objectInfoRoot) {
        this.m_provider = provider;
        objectInfoRoot.addBroadcastListener((Object)new ObjectInfoPresentationDecorateIcon(){

            public void invoke(ObjectInfo object, Image[] icon) throws Exception {
                if (JavaInfoDecorator.this.hasDecorate(object)) {
                    icon[0] = SwtResourceManager.decorateImage((Image)icon[0], (Image)IMAGE, (int)2);
                }
            }
        });
    }

    private boolean hasDecorate(ObjectInfo object) throws Exception {
        String objectReference;
        if (!this.m_provider.getBindings().isEmpty() && this.accept(object) && (objectReference = this.getReference(object)) != null) {
            for (IBindingInfo binding : this.m_provider.getBindings()) {
                if (!this.equals(object, objectReference, binding.getTarget()) && !this.equals(object, objectReference, binding.getModel())) continue;
                return true;
            }
        }
        return false;
    }

    protected abstract boolean accept(ObjectInfo var1) throws Exception;

    protected abstract String getReference(ObjectInfo var1) throws Exception;

    protected abstract boolean equals(ObjectInfo var1, String var2, IObserveInfo var3) throws Exception;
}

