/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.core.stateprovider;

import java.nio.file.Path;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.stateprovider.XmlStateProvider;
import org.eclipse.tracecompass.tmf.analysis.xml.core.module.TmfXmlUtils;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfStateProvider;
import org.eclipse.tracecompass.tmf.core.statesystem.TmfStateSystemAnalysisModule;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.w3c.dom.Element;

public class XmlStateSystemModule
extends TmfStateSystemAnalysisModule {
    private @Nullable Path fXmlFile;

    protected TmfStateSystemAnalysisModule.StateSystemBackendType getBackendType() {
        return TmfStateSystemAnalysisModule.StateSystemBackendType.FULL;
    }

    protected @NonNull ITmfStateProvider createStateProvider() {
        return new XmlStateProvider((ITmfTrace)NonNullUtils.checkNotNull((Object)this.getTrace()), this.getId(), this.fXmlFile);
    }

    public String getName() {
        List<Element> labels;
        String id = this.getId();
        Path xmlFile = this.fXmlFile;
        if (xmlFile == null) {
            return id;
        }
        Element doc = TmfXmlUtils.getElementInFile(xmlFile.toAbsolutePath().toString(), "stateProvider", id);
        List<Element> head = TmfXmlUtils.getChildElements(doc, "head");
        String name = null;
        if (head.size() == 1 && !(labels = TmfXmlUtils.getChildElements(head.get(0), "label")).isEmpty()) {
            name = labels.get(0).getAttribute("value");
        }
        return name == null ? id : name;
    }

    public void setXmlFile(Path file) {
        this.fXmlFile = file;
    }

    public Path getXmlFile() {
        return this.fXmlFile;
    }
}

