/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.statesystem.core.backend.historytree;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.common.core.log.TraceCompassLog;
import org.eclipse.tracecompass.common.core.log.TraceCompassLogUtils;
import org.eclipse.tracecompass.internal.statesystem.core.Activator;
import org.eclipse.tracecompass.internal.statesystem.core.backend.historytree.HTConfig;
import org.eclipse.tracecompass.internal.statesystem.core.backend.historytree.HTNode;
import org.eclipse.tracecompass.internal.statesystem.core.backend.historytree.IHistoryTree;

public class HT_IO {
    private static final Logger LOGGER = TraceCompassLog.getLogger(HT_IO.class);
    private static final int CACHE_SIZE = 256;
    private static final LoadingCache<CacheKey, HTNode> NODE_CACHE = (LoadingCache)NonNullUtils.checkNotNull((Object)CacheBuilder.newBuilder().maximumSize(256L).build((CacheLoader)new CacheLoader<CacheKey, HTNode>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public HTNode load(CacheKey key) throws IOException {
            HT_IO io = key.fStateHistory;
            int seqNb = key.fSeqNumber;
            TraceCompassLogUtils.traceInstant((Logger)LOGGER, (Level)Level.FINEST, (String)"Ht_Io:CacheMiss", (Object[])new Object[]{"seqNum", seqNb});
            HT_IO hT_IO = io;
            synchronized (hT_IO) {
                io.seekFCToNodePos(io.fFileChannelIn, seqNb);
                return HTNode.readNode(io.fConfig, io.fFileChannelIn, key.fStateHistory.fNodeFactory);
            }
        }
    }));
    private final HTConfig fConfig;
    private final FileInputStream fFileInputStream;
    private final FileOutputStream fFileOutputStream;
    private final FileChannel fFileChannelIn;
    private final FileChannel fFileChannelOut;
    private final IHistoryTree.IHTNodeFactory fNodeFactory;

    public HT_IO(HTConfig config, boolean newFile, IHistoryTree.IHTNodeFactory nodeFactory) throws IOException {
        this.fConfig = config;
        File historyTreeFile = config.getStateFile();
        if (newFile) {
            boolean success1 = true;
            if (historyTreeFile.exists()) {
                success1 = historyTreeFile.delete();
            }
            boolean success2 = historyTreeFile.createNewFile();
            if (!success1 || !success2) {
                throw new IOException("Cannot create new file at " + historyTreeFile.getName());
            }
            this.fFileInputStream = new FileInputStream(historyTreeFile);
            this.fFileOutputStream = new FileOutputStream(historyTreeFile, false);
        } else {
            this.fFileInputStream = new FileInputStream(historyTreeFile);
            this.fFileOutputStream = new FileOutputStream(historyTreeFile, true);
        }
        this.fFileChannelIn = this.fFileInputStream.getChannel();
        this.fFileChannelOut = this.fFileOutputStream.getChannel();
        this.fNodeFactory = nodeFactory;
    }

    public @NonNull HTNode readNode(int seqNumber) throws ClosedChannelException {
        TraceCompassLogUtils.traceInstant((Logger)LOGGER, (Level)Level.FINEST, (String)"Ht_Io:CacheLookup", (Object[])new Object[]{"seqNum", seqNumber});
        CacheKey key = new CacheKey(this, seqNumber);
        try {
            return (HTNode)NonNullUtils.checkNotNull((Object)((HTNode)NODE_CACHE.get((Object)key)));
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof ClosedChannelException) {
                throw (ClosedChannelException)cause;
            }
            Activator.getDefault().logError(e.getMessage(), e);
            throw new IllegalStateException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeNode(HTNode node) {
        try {
            int seqNumber = node.getSequenceNumber();
            CacheKey key = new CacheKey(this, seqNumber);
            NODE_CACHE.put((Object)key, (Object)node);
            HT_IO hT_IO = this;
            synchronized (hT_IO) {
                this.seekFCToNodePos(this.fFileChannelOut, seqNumber);
                node.writeSelf(this.fFileChannelOut);
            }
        }
        catch (IOException e) {
            Activator.getDefault().logError(e.getMessage(), e);
        }
    }

    public FileChannel getFcOut() {
        return this.fFileChannelOut;
    }

    public FileInputStream supplyATReader(int nodeOffset) {
        try {
            this.seekFCToNodePos(this.fFileChannelIn, nodeOffset);
        }
        catch (IOException e) {
            Activator.getDefault().logError(e.getMessage(), e);
        }
        return this.fFileInputStream;
    }

    public synchronized void closeFile() {
        try {
            this.fFileInputStream.close();
            this.fFileOutputStream.close();
        }
        catch (IOException e) {
            Activator.getDefault().logError(e.getMessage(), e);
        }
    }

    public synchronized void deleteFile() {
        this.closeFile();
        File historyTreeFile = this.fConfig.getStateFile();
        if (!historyTreeFile.delete()) {
            Activator.getDefault().logError("Failed to delete" + historyTreeFile.getName());
        }
    }

    private void seekFCToNodePos(FileChannel fc, int seqNumber) throws IOException {
        fc.position(4096L + (long)seqNumber * (long)this.fConfig.getBlockSize());
    }

    private static final class CacheKey {
        public final HT_IO fStateHistory;
        public final int fSeqNumber;

        public CacheKey(HT_IO stateHistory, int seqNumber) {
            this.fStateHistory = stateHistory;
            this.fSeqNumber = seqNumber;
        }

        public int hashCode() {
            return Objects.hash(this.fStateHistory, this.fSeqNumber);
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CacheKey other = (CacheKey)obj;
            return this.fStateHistory.equals(other.fStateHistory) && this.fSeqNumber == other.fSeqNumber;
        }
    }
}

