/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.local.change.visitors;

import java.util.Arrays;
import java.util.LinkedHashSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.operation.local.change.IActionOperationProcessor;
import org.eclipse.team.svn.core.operation.local.change.IResourceChangeVisitor;
import org.eclipse.team.svn.core.operation.local.change.ResourceChange;

public class CompositeVisitor
implements IResourceChangeVisitor {
    protected static IResourceChangeVisitor[] EMPTY = new IResourceChangeVisitor[0];
    protected IResourceChangeVisitor[] visitors = EMPTY;

    public void add(IResourceChangeVisitor visitor) {
        LinkedHashSet<IResourceChangeVisitor> visitors = new LinkedHashSet<IResourceChangeVisitor>(Arrays.asList(this.visitors));
        visitors.add(visitor);
        this.visitors = visitors.toArray(new IResourceChangeVisitor[visitors.size()]);
    }

    public void postVisit(ResourceChange change, IActionOperationProcessor processor, IProgressMonitor monitor) throws Exception {
        int i = 0;
        while (i < this.visitors.length && !monitor.isCanceled()) {
            this.visitors[i].postVisit(change, processor, monitor);
            ++i;
        }
    }

    public void preVisit(ResourceChange change, IActionOperationProcessor processor, IProgressMonitor monitor) throws Exception {
        int i = 0;
        while (i < this.visitors.length && !monitor.isCanceled()) {
            this.visitors[i].preVisit(change, processor, monitor);
            ++i;
        }
    }
}

